/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.html;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Vector;
import org.makumba.FieldDefinition;
import org.makumba.HtmlUtils;
import org.makumba.Pointer;
import org.makumba.ProgrammerError;
import org.makumba.commons.SingletonReleaser;
import org.makumba.commons.StringUtils;
import org.makumba.commons.attributes.HttpParameters;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.RecordFormatter;
import org.makumba.forms.html.ChoiceSet;
import org.makumba.forms.html.FieldEditor;
import org.makumba.forms.html.RecordEditor;
import org.makumba.forms.html.choiceEditor;
import org.makumba.providers.Configuration;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ptrEditor
extends choiceEditor {
    protected ptrEditor() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    @Override
    public void onStartup(RecordFormatter rf, int fieldIndex) {
        ((RecordEditor)rf).db[fieldIndex] = ((RecordEditor)rf).database;
        HashMap<String, String> m = new HashMap<String, String>();
        ((RecordEditor)rf).query[fieldIndex] = m;
        String titleField = rf.dd.getFieldDefinition(fieldIndex).getTitleField();
        String titleExpr = "choice." + titleField;
        String choiceType = rf.dd.getFieldDefinition(fieldIndex).getPointedType().getName();
        m.put("oql", "SELECT choice as choice, " + titleExpr + " as title FROM " + choiceType + " choice " + "ORDER BY title");
        FieldDefinition titleFieldDef = rf.dd.getFieldDefinition(fieldIndex).getPointedType().getFieldOrPointedFieldDefinition(titleField);
        if (titleFieldDef != null && titleFieldDef.getType().equals("ptr")) {
            titleExpr = titleExpr + ".id";
        }
        m.put("hql", "SELECT choice.id as choice, " + titleExpr + " as title FROM " + choiceType + " choice " + "ORDER BY " + titleExpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getOptions(RecordFormatter rf, int fieldIndex, Dictionary<String, Object> formatParams) {
        ChoiceSet c = (ChoiceSet)formatParams.get("org.makumba.ChoiceSet");
        if (c != null) {
            return c;
        }
        Vector<Dictionary<String, Object>> v = null;
        String queryLang = (String)formatParams.get("org.makumba.forms.queryLanguage");
        QueryProvider qp = QueryProvider.makeQueryRunner(((RecordEditor)rf).db[fieldIndex], queryLang);
        try {
            v = qp.execute(((RecordEditor)rf).query[fieldIndex].get(queryLang), null, 0, -1);
        }
        finally {
            qp.close();
        }
        c = new ChoiceSet();
        if (this.nullOption != null) {
            c.add("", this.nullOption, false, false);
        }
        for (Dictionary<String, Object> d : v) {
            Object ttl = d.get("title");
            if (ttl == null) {
                Pointer ptr = (Pointer)d.get("choice");
                StringBuilder msg = new StringBuilder(150);
                msg.append("Object ").append(ptr).append(" (external ID: ").append(ptr.toExternalForm()).append(") has a null value for the title-field (").append(ptr.getType()).append(".").append(DataDefinitionProvider.getInstance().getDataDefinition(ptr.getType()).getTitleFieldName()).append("), and can't be displayed in the drop-down.\nEither make sure you have no null values in this field, or use a different field for the title display, using the '!title=' directive in the MDD.");
                throw new ProgrammerError(msg.toString());
            }
            c.add(d.get("choice"), ttl.toString(), false, false);
        }
        return c;
    }

    @Override
    public int getOptionsLength(RecordFormatter rf, int fieldIndex, Object opts) {
        return ((ChoiceSet)opts).size();
    }

    @Override
    public Object getOptionValue(RecordFormatter rf, int fieldIndex, Object options, int i) {
        return ((ChoiceSet.Choice)((ChoiceSet)options).get(i)).getValue();
    }

    @Override
    public String formatOptionValue(RecordFormatter rf, int fieldIndex, Object val) {
        if (val == Pointer.Null) {
            return "";
        }
        if (val instanceof String) {
            return (String)val;
        }
        return ((Pointer)val).toExternalForm();
    }

    @Override
    public String formatOptionValue(RecordFormatter rf, int fieldIndex, Object opts, int i, Object val) {
        return this.formatOptionValue(rf, fieldIndex, val);
    }

    @Override
    public String formatOptionTitle(RecordFormatter rf, int fieldIndex, Object options, int i) {
        return ((ChoiceSet.Choice)((ChoiceSet)options).get(i)).getTitle();
    }

    @Override
    public Object readFrom(RecordFormatter rf, int fieldIndex, HttpParameters p, String suffix) {
        Object o = super.readFrom(rf, fieldIndex, p, suffix);
        if ("".equals(o)) {
            return null;
        }
        return o;
    }

    @Override
    public boolean isMultiple(RecordFormatter rf, int fieldIndex) {
        return false;
    }

    @Override
    public int getDefaultSize(RecordFormatter rf, int fieldIndex) {
        return 1;
    }

    @Override
    public String format(RecordFormatter rf, int fieldIndex, Object o, Dictionary<String, Object> formatParams) {
        boolean autoComplete;
        boolean bl = autoComplete = formatParams.get("autoComplete") != null && formatParams.get("autoComplete").equals("true");
        if (autoComplete && this instanceof ptrEditor) {
            return this.formatAutoComplete(rf, fieldIndex, o, formatParams);
        }
        return super.format(rf, fieldIndex, o, formatParams);
    }

    private String formatAutoComplete(RecordFormatter rf, int fieldIndex, Object o, Dictionary<String, Object> formatParams) {
        String res = "";
        String id = "";
        String inputName = "";
        inputName = ptrEditor.getInputName(rf, fieldIndex, formatParams);
        id = StringUtils.getParam("id", ptrEditor.getExtraFormatting(rf, fieldIndex, formatParams));
        String extraFormattingVisible = ptrEditor.getExtraFormatting(rf, fieldIndex, formatParams);
        int cutIndex = extraFormattingVisible.indexOf("id=") + 4 + id.length();
        extraFormattingVisible = extraFormattingVisible.substring(0, cutIndex) + "_visible" + extraFormattingVisible.substring(cutIndex);
        res = res + "<input name=\"" + inputName + "_visible\" type=\"text\" value=\"" + this.formatValue(rf, fieldIndex, o, formatParams) + "\" " + extraFormattingVisible + "autocomplete=\"off\">";
        res = res + "<input name=\"" + inputName + "\" type=\"hidden\" value=\"" + this.formatValue(rf, fieldIndex, o, formatParams) + "\" " + ptrEditor.getExtraFormatting(rf, fieldIndex, formatParams) + ">";
        res = res + "<div id=\"autocomplete_choices_" + id + "\" class=\"autocomplete\"></div>";
        res = res + "<script type=\"text/javascript\">MakumbaAutoComplete.AutoComplete(\"" + id + "\", \"" + Configuration.getMakumbaAutoCompleteLocation() + "\", \"" + rf.dd.getFieldDefinition(fieldIndex).getOriginalFieldDefinition().getDataDefinition().getName() + "\", \"" + rf.dd.getFieldDefinition(fieldIndex).getOriginalFieldDefinition().getName() + "\", \"ptr\", \"" + (String)formatParams.get("org.makumba.forms.queryLanguage") + "\");</script>";
        return res;
    }

    @Override
    public String formatValue(RecordFormatter rf, int fieldIndex, Object o, Dictionary<String, Object> formatParams) {
        String s = o == null ? null : HtmlUtils.string2html(o.toString());
        return this.resetValueFormat(rf, fieldIndex, s, formatParams);
    }

    private static final class SingletonHolder
    implements org.makumba.commons.SingletonHolder {
        static FieldEditor singleton = new ptrEditor();

        public void release() {
            singleton = null;
        }

        public SingletonHolder() {
            SingletonReleaser.register(this);
        }
    }
}

