/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba;

import antlr.collections.AST;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.ValidationDefinitionParseError;
import org.makumba.ValidationRule;
import org.makumba.commons.ClassResource;
import org.makumba.commons.OrderedProperties;
import org.makumba.commons.RegExpUtils;
import org.makumba.commons.ReservedKeywords;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.datadefinition.makumba.FieldCursor;
import org.makumba.providers.datadefinition.makumba.FieldInfo;
import org.makumba.providers.datadefinition.makumba.FileRecordInfo;
import org.makumba.providers.datadefinition.makumba.RecordInfo;
import org.makumba.providers.datadefinition.makumba.validation.BasicValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.ComparisonValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.NumberRangeValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.RangeValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.RegExpValidationRule;
import org.makumba.providers.datadefinition.makumba.validation.StringLengthValidationRule;
import org.makumba.providers.query.mql.HqlParser;

public class RecordParser {
    public static final String VALIDATION_INDICATOR = "%";
    public static final String multiUniqueRegExpElement = "[ \\t]*([a-zA-Z]\\w*(?:\\.\\w+)?)[ \\t]*";
    public static final String multiUniqueRegExpElementRepeatment = "(?:[ \\t]*,(?:[ \\t]*([a-zA-Z]\\w*(?:\\.\\w+)?)[ \\t]*))*";
    public static final String multiUniqueRegExp = "[ \\t]*(?:[ \\t]*([a-zA-Z]\\w*(?:\\.\\w+)?)[ \\t]*)(?:[ \\t]*,(?:[ \\t]*([a-zA-Z]\\w*(?:\\.\\w+)?)[ \\t]*))*[ \\t]*";
    public static final Pattern multiUniquePattern = Pattern.compile("[ \\t]*(?:[ \\t]*([a-zA-Z]\\w*(?:\\.\\w+)?)[ \\t]*)(?:[ \\t]*,(?:[ \\t]*([a-zA-Z]\\w*(?:\\.\\w+)?)[ \\t]*))*[ \\t]*");
    public static final String validationRuleErrorMessageSeparatorChar = " : ";
    public static final String validationDefinitionRegExp = "[ \\t]*([a-zA-Z]\\w*(?:\\.\\w+)?)[ \\t]*%(matches|length|range|compare|unique)[ \\t]*=[ \\t]*(.+)[ \\t]* : [ \\t]*.+";
    public static final Pattern validationDefinitionPattern = Pattern.compile("[ \\t]*([a-zA-Z]\\w*(?:\\.\\w+)?)[ \\t]*%(matches|length|range|compare|unique)[ \\t]*=[ \\t]*(.+)[ \\t]* : [ \\t]*.+");
    public static final String funcDefParamTypeRegExp = "(?:char|char\\[\\]|int|real|date|intEnum|charEnum|text|binary|ptr|set|setIntEnum|setCharEnum|ptr)";
    public static final String funcDefParamValueRegExp = "(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?)";
    public static final String funcDefParamRegExp = "(?:char|char\\[\\]|int|real|date|intEnum|charEnum|text|binary|ptr|set|setIntEnum|setCharEnum|ptr)[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?)(?:[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?))?";
    public static final String funcDefParamRepeatRegExp = "\\(((?:(?:char|char\\[\\]|int|real|date|intEnum|charEnum|text|binary|ptr|set|setIntEnum|setCharEnum|ptr)[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?)(?:[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?))?)(?:[ \\t]*,[ \\t]*(?:char|char\\[\\]|int|real|date|intEnum|charEnum|text|binary|ptr|set|setIntEnum|setCharEnum|ptr)[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?)(?:[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?))?)*[ \\t]*)?\\)";
    public static final String funcDefRegExp = "([a-zA-Z]\\w*(?:\\.\\w+)?%)?([a-zA-Z]\\w*(?:\\.\\w+)?)\\(((?:(?:char|char\\[\\]|int|real|date|intEnum|charEnum|text|binary|ptr|set|setIntEnum|setCharEnum|ptr)[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?)(?:[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?))?)(?:[ \\t]*,[ \\t]*(?:char|char\\[\\]|int|real|date|intEnum|charEnum|text|binary|ptr|set|setIntEnum|setCharEnum|ptr)[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?)(?:[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?))?)*[ \\t]*)?\\)[ \\t]*\\{[ \\t]*(.[^\\}]+)[ \\t]*(?:\\}[ \\t]*(.*))?";
    public static final Pattern funcDefPattern = Pattern.compile("([a-zA-Z]\\w*(?:\\.\\w+)?%)?([a-zA-Z]\\w*(?:\\.\\w+)?)\\(((?:(?:char|char\\[\\]|int|real|date|intEnum|charEnum|text|binary|ptr|set|setIntEnum|setCharEnum|ptr)[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?)(?:[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?))?)(?:[ \\t]*,[ \\t]*(?:char|char\\[\\]|int|real|date|intEnum|charEnum|text|binary|ptr|set|setIntEnum|setCharEnum|ptr)[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?)(?:[ \\t]+(?:\\d+|[a-zA-Z]\\w*(?:\\.\\w+)?))?)*[ \\t]*)?\\)[ \\t]*\\{[ \\t]*(.[^\\}]+)[ \\t]*(?:\\}[ \\t]*(.*))?");
    public static final Pattern ident = Pattern.compile("[a-zA-Z]\\w*");
    OrderedProperties text;
    OrderedProperties fields = new OrderedProperties();
    OrderedProperties subfields = new OrderedProperties();
    DataDefinitionParseError mpe;
    Properties definedTypes;
    RecordInfo dd;
    HashMap<String, RecordParser> ptrOne_RecordParsers = new HashMap();
    HashMap<String, DataDefinition> setParser_settbls = new HashMap();
    HashMap<String, RecordInfo> subtableParser_subtables = new HashMap();
    HashMap<String, RecordInfo> subtableParser_here = new HashMap();
    private ArrayList<String> unparsedValidationDefinitions = new ArrayList();
    private String titleExpressionToEvaluate;
    private String titleExpressionToEvaluateOrigCmd;
    FieldCursor currentRowCursor;
    HashMap<String, DataDefinition.QueryFragmentFunction> funcNames = new HashMap();

    public static boolean isValidationRule(String s) {
        return validationDefinitionPattern.matcher(s).matches();
    }

    public static boolean isFunction(String s) {
        return funcDefPattern.matcher(s).matches();
    }

    RecordParser() {
        this.definedTypes = new Properties();
    }

    RecordParser(RecordInfo dd, RecordParser rp) {
        this.dd = dd;
        this.text = new OrderedProperties();
        this.definedTypes = rp.definedTypes;
        this.mpe = rp.mpe;
    }

    void parse(RecordInfo dd) {
        this.dd = dd;
        this.text = new OrderedProperties();
        this.mpe = new DataDefinitionParseError();
        try {
            this.read(this.text, dd.origin);
        }
        catch (IOException e) {
            throw this.fail(e);
        }
        try {
            dd.addStandardFields(dd.name.substring(dd.name.lastIndexOf(46) + 1));
            this.parse();
        }
        catch (RuntimeException e) {
            throw new MakumbaError(e, "Internal error in parser while parsing " + dd.getName() + " from " + dd.origin);
        }
        if (!this.mpe.isSingle() && dd.getParentField() == null) {
            throw this.mpe;
        }
    }

    DataDefinition parse(URL u, String path) {
        this.dd = new RecordInfo(u, path);
        this.parse(this.dd);
        return this.dd;
    }

    RecordInfo parse(String txt) {
        this.dd = new RecordInfo();
        this.text = new OrderedProperties();
        this.mpe = new DataDefinitionParseError();
        try {
            this.read(this.text, txt);
        }
        catch (IOException e) {
            throw this.fail(e);
        }
        try {
            this.dd.addStandardFields(this.dd.getName().substring(this.dd.getName().lastIndexOf(46) + 1));
            this.parse();
        }
        catch (RuntimeException e) {
            throw new MakumbaError(e, "Internal error in parser while parsing " + this.dd.getName());
        }
        if (!this.mpe.isSingle() && this.dd.getParentField() == null) {
            throw this.mpe;
        }
        return this.dd;
    }

    void parse() {
        this.solveIncludes();
        this.separateFields();
        this.setTitle();
        this.readTypes();
        if (this.text.size() != 0) {
            this.mpe.add(this.fail("unrecognized commands", this.text.toString()));
        }
        this.treatMyFields();
        this.compileFunctions();
        this.configSubfields();
        this.treatSubfields();
        this.evaluateTitleExpressionInPointedType();
        this.parseValidationDefinition();
        this.checkMultipleUniqueFields();
    }

    private void evaluateTitleExpressionInPointedType() {
        if (this.titleExpressionToEvaluate != null) {
            try {
                FieldDefinition fieldDef = this.dd.getFieldOrPointedFieldDefinition(this.titleExpressionToEvaluate);
                if (fieldDef == null) {
                    this.mpe.add(this.fail("no such field in a pointed type for title", RecordParser.makeLine(this.titleExpressionToEvaluateOrigCmd, this.titleExpressionToEvaluate)));
                    return;
                }
                this.dd.title = this.titleExpressionToEvaluate;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkMultipleUniqueFields() {
        for (int i = 0; i < this.dd.getMultiFieldUniqueKeys().length; ++i) {
            DataDefinition.MultipleUniqueKeyDefinition multiUniqueKeyDefinition = this.dd.getMultiFieldUniqueKeys()[i];
            for (int j = 0; j < multiUniqueKeyDefinition.getFields().length; ++j) {
                String fieldName = multiUniqueKeyDefinition.getFields()[j];
                DataDefinition checkedDataDef = this.dd;
                int indexOf = -1;
                while ((indexOf = fieldName.indexOf(".")) != -1) {
                    String subFieldName = fieldName.substring(0, indexOf);
                    fieldName = fieldName.substring(indexOf + 1);
                    checkedDataDef = checkedDataDef.getFieldDefinition(subFieldName).getPointedType();
                }
                if (checkedDataDef.getFieldDefinition(fieldName) == null) {
                    this.mpe.add(new DataDefinitionParseError(this.dd.getName(), "Unique index contains an unknown field: " + fieldName, multiUniqueKeyDefinition.getLine()));
                    continue;
                }
                if (checkedDataDef == this.dd) continue;
                multiUniqueKeyDefinition.setKeyOverSubfield(true);
            }
        }
    }

    void separateFields() {
        Enumeration<String> e = this.text.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement();
            if (k.indexOf(33) == 0) continue;
            if (k.indexOf("->") == -1) {
                this.fields.putLast(k, this.text.getOriginal(k), this.text.remove(k));
                continue;
            }
            this.subfields.putLast(k, this.text.getOriginal(k), this.text.remove(k));
        }
    }

    void setTitle() {
        String origCmd = this.text.getOriginal("!title");
        String ttl = this.text.remove("!title");
        String ttlt = null;
        if (ttl != null) {
            if (ttl.contains(".")) {
                this.titleExpressionToEvaluateOrigCmd = origCmd;
                this.titleExpressionToEvaluate = ttl;
                return;
            }
            ttlt = ttl.trim();
            if (this.fields.get(ttlt) == null) {
                this.mpe.add(this.fail("no such field for title", RecordParser.makeLine(origCmd, ttl)));
                return;
            }
        } else if (this.fields.get("name") != null) {
            ttlt = "name";
        } else if (this.fields.size() > 0) {
            ttlt = this.fields.keyAt(0);
        }
        this.dd.title = ttlt;
    }

    static URL getResource(String s) {
        return ClassResource.get(s);
    }

    public static URL findDataDefinition(String s, String ext) {
        URL u = RecordParser.findDataDefinitionOrDirectory(s, ext);
        if (u != null && (s.endsWith("/") || RecordParser.getResource(s + '/') != null)) {
            return null;
        }
        return u;
    }

    public static URL findDataDefinitionOrDirectory(String s, String ext) {
        URL u = null;
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        if (s.endsWith(".") || s.endsWith("//")) {
            return null;
        }
        if (RecordInfo.webappRoot != null) {
            File f = new File(RecordInfo.webappRoot);
            if (!f.exists() || f.exists() && !f.isDirectory()) {
                throw new MakumbaError("webappRoot " + RecordInfo.webappRoot + " does not appear to be a valid directory");
            }
            String mddPath = RecordInfo.webappRoot + "/WEB-INF/classes/dataDefinitions/" + s.replace('.', '/') + "." + ext;
            File mdd = new File(mddPath.replaceAll("/", File.separator));
            if (mdd.exists()) {
                try {
                    u = new URL("file://" + mdd.getAbsolutePath());
                }
                catch (MalformedURLException e) {
                    throw new MakumbaError("internal error while trying to retrieve URL for MDD " + mdd.getAbsolutePath());
                }
            }
        }
        if (u == null) {
            u = RecordParser.getResource("dataDefinitions/" + s.replace('.', '/') + "." + ext);
            if (u == null) {
                u = RecordParser.getResource("dataDefinitions" + (s.length() == 0 ? "" : "/") + s);
            }
            if (u == null) {
                u = RecordParser.getResource(s.replace('.', '/') + "." + ext);
            }
        }
        return u;
    }

    void solveIncludes() {
        int line = 0;
        Vector<String> overridenFields = new Vector<String>();
        Enumeration<String> e = this.text.keys();
        while (e.hasMoreElements()) {
            String st = e.nextElement();
            if (st.startsWith("!include")) {
                OrderedProperties inclText;
                String ok = this.text.getOriginal(st);
                String incl = this.text.remove(st);
                --line;
                String s = incl.trim();
                URL u = RecordParser.findDataDefinition(s, "idd");
                if (u == null) {
                    this.mpe.add(this.fail("could not find include file " + s, ok + "=" + incl));
                    return;
                }
                try {
                    inclText = new OrderedProperties();
                    this.read(inclText, u);
                }
                catch (IOException ioe) {
                    this.mpe.add(this.fail("could not find include file " + s + " " + ioe, ok + "=" + incl));
                    return;
                }
                Enumeration<String> k = inclText.keys();
                while (k.hasMoreElements()) {
                    String key = k.nextElement();
                    String val = this.text.getProperty(key);
                    if (val == null) {
                        this.text.putAt(++line, key, inclText.getOriginal(key), inclText.getProperty(key));
                        continue;
                    }
                    overridenFields.add(key);
                }
            }
            ++line;
        }
        for (String key : overridenFields) {
            if (this.text.get(key).trim().length() != 0) continue;
            this.text.remove(key);
        }
    }

    void readTypes() {
        Enumeration<String> e = this.text.keys();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            if (!s.startsWith("!type.")) continue;
            String nm = s.substring(6);
            this.definedTypes.put(nm, this.text.remove(s));
        }
    }

    FieldInfo getFieldInfo(String fieldName) {
        return (FieldInfo)this.dd.getFieldDefinition(fieldName);
    }

    void treatMyFields() {
        int line = 0;
        Enumeration<String> e = this.fields.keys();
        while (e.hasMoreElements()) {
            String nm = e.nextElement();
            String val = this.fields.get(nm);
            if (!this.matchFunction(nm + val)) {
                for (int i = 0; i < nm.length(); ++i) {
                    if ((i != 0 || Character.isJavaIdentifierStart(nm.charAt(i))) && (i <= 0 || Character.isJavaIdentifierPart(nm.charAt(i)))) continue;
                    this.mpe.add(this.fail("Invalid character \"" + nm.charAt(i) + "\" in field name \"" + nm + "\"", nm));
                }
                if (ReservedKeywords.isReservedKeyword(nm)) {
                    this.mpe.add(this.fail("Error: field name cannot be one of the reserved keywords " + ReservedKeywords.getKeywordsAsString(), nm));
                }
                FieldInfo fi = new FieldInfo(this.dd, nm);
                this.dd.addField1(fi);
                try {
                    this.parse(nm, new FieldCursor(this, RecordParser.makeLine(this.fields, nm)));
                }
                catch (DataDefinitionParseError pe) {
                    this.dd.fields.remove(nm);
                    this.dd.fieldOrder.remove(nm);
                    this.mpe.add(pe);
                }
            }
            ++line;
        }
    }

    boolean matchFunction(String line) {
        String name;
        Matcher matcher = funcDefPattern.matcher(line);
        if (!matcher.matches()) {
            return false;
        }
        String sessionVariableName = matcher.group(1);
        if (sessionVariableName != null) {
            sessionVariableName = sessionVariableName.replace(VALIDATION_INDICATOR, "");
        }
        if (this.funcNames.get(name = matcher.group(2)) != null) {
            this.mpe.add(new DataDefinitionParseError(this.dd.getName(), "Duplicate function name: " + name, line));
        }
        String paramsBlock = matcher.group(3);
        String queryFragment = matcher.group(4);
        String errorMessage = matcher.group(5);
        RecordInfo ddParams = new RecordInfo(this.dd.getName() + "." + matcher.group(0));
        if (StringUtils.isNotBlank((String)paramsBlock)) {
            String[] params;
            for (String element : params = paramsBlock.split(",")) {
                String paramType = element.trim().split(" ")[0].trim();
                if (paramType.equals("ptr")) {
                    String paramMdd = element.trim().split(" ")[1].trim();
                    String paramName = element.trim().split(" ")[2].trim();
                    DataDefinition pointedDD = DataDefinitionProvider.getInstance().getDataDefinition(paramMdd);
                    ddParams.addField(new FieldInfo(paramName, (FieldInfo)pointedDD.getFieldDefinition(pointedDD.getIndexPointerFieldName())));
                    continue;
                }
                String paramName = element.trim().split(" ")[1].trim();
                if (paramType.equals("char[]")) {
                    paramType = "char[255]";
                }
                ddParams.addField(new FieldInfo(paramName, paramType));
            }
        }
        DataDefinition.QueryFragmentFunction function = new DataDefinition.QueryFragmentFunction(name, sessionVariableName, queryFragment, ddParams, errorMessage, null);
        this.funcNames.put(function.getName(), function);
        return true;
    }

    void compileFunctions() {
        for (String fn : this.funcNames.keySet()) {
            DataDefinition.QueryFragmentFunction f = this.funcNames.get(fn);
            StringBuffer sb = new StringBuffer();
            String queryFragment = f.getQueryFragment();
            Matcher m = ident.matcher(queryFragment);
            boolean found = false;
            while (m.find()) {
                String id = queryFragment.substring(m.start(), m.end());
                int after = -1;
                for (int index = m.end(); index < queryFragment.length(); ++index) {
                    char c = queryFragment.charAt(index);
                    if (c == ' ' || c == '\t') continue;
                    after = c;
                    break;
                }
                int before = -1;
                for (int index = m.start() - 1; index >= 0; --index) {
                    char c = queryFragment.charAt(index);
                    if (c == ' ' || c == '\t') continue;
                    before = c;
                    break;
                }
                if (before == 46 || id.equals("this") || id.equals("actor") || f.getParameters().getFieldDefinition(id) != null || this.dd.getFieldDefinition(id) == null && (after != 40 || this.funcNames.get(id) == null)) continue;
                m.appendReplacement(sb, "this." + id);
                found = true;
            }
            m.appendTail(sb);
            if (found) {
                Logger.getLogger("org.makumba.db.query.inline").fine(queryFragment + " -> " + sb.toString());
                AST tree = this.getParsedFunction(f.getName(), sb.toString(), f.toString());
                f = new DataDefinition.QueryFragmentFunction(f.getName(), f.getSessionVariableName(), sb.toString(), f.getParameters(), f.getErrorMessage(), tree);
            }
            this.dd.addFunction(f.getName(), f);
        }
    }

    private AST getParsedFunction(String fName, String expression, String line) {
        boolean subquery = expression.toUpperCase().startsWith("SELECT ");
        String query = "SELECT " + (subquery ? "(" : "") + expression + (subquery ? ")" : "") + " FROM " + this.dd.getName() + " makumbaGeneratedAlias";
        HqlParser parser = HqlParser.getInstance(query);
        try {
            parser.statement();
        }
        catch (Exception e) {
            this.mpe.add(new DataDefinitionParseError(this.dd.getName(), "Error in function " + fName + ": " + e.getMessage(), line));
        }
        return parser.getAST();
    }

    void configSubfields() {
        Enumeration<String> e = this.subfields.keys();
        while (e.hasMoreElements()) {
            int p;
            String nm = e.nextElement();
            FieldInfo fieldInfo = this.getFieldInfo(nm.substring(0, p = nm.indexOf("->")));
            if (fieldInfo == null) {
                this.mpe.add(this.fail("Could not find subfield '" + nm.substring(0, p) + "'", RecordParser.makeLine(this.subfields, nm)));
                continue;
            }
            String type = fieldInfo.type;
            if (type == null) {
                this.mpe.add(this.fail("no such field in subfield definition", RecordParser.makeLine(this.subfields, nm)));
                continue;
            }
            String s = this.addText(nm.substring(0, p), nm.substring(p + 2), this.subfields.getOriginal(nm), this.subfields.getProperty(nm));
            if (s == null) continue;
            this.mpe.add(this.fail(s, RecordParser.makeLine(this.subfields, nm)));
        }
    }

    void treatSubfields() {
        Iterator<String> i$ = this.dd.getFieldNames().iterator();
        while (i$.hasNext()) {
            String string;
            String fieldName = string = i$.next();
            this.parseSubfields(fieldName);
        }
    }

    static String makeLine(String origKey, String value) {
        return origKey + "=" + value;
    }

    static String makeLine(OrderedProperties p, String k) {
        return p.getOriginal(k) + "=" + p.getProperty(k);
    }

    DataDefinitionParseError fail(String why, String where) {
        return new DataDefinitionParseError(this.dd.getName(), why, where, where.length());
    }

    DataDefinitionParseError fail(IOException ioe) {
        return new DataDefinitionParseError(this.dd.getName(), ioe);
    }

    void read(OrderedProperties op, String txt) throws IOException {
        this.read(op, new BufferedReader(new StringReader(txt)));
    }

    void read(OrderedProperties op, URL u) throws IOException {
        Object o = u.getContent();
        URLConnection uconn = u.openConnection();
        if (uconn.getClass().getName().endsWith("FileURLConnection")) {
            this.read(op, new BufferedReader(new InputStreamReader((InputStream)o)));
        } else if (uconn.getClass().getName().endsWith("JarURLConnection")) {
            JarFile jf = ((JarURLConnection)uconn).getJarFile();
            String[] jarURL = u.toExternalForm().split("!");
            JarEntry je = jf.getJarEntry(jarURL[1].substring(1));
            this.read(op, new BufferedReader(new InputStreamReader(jf.getInputStream(je))));
        }
    }

    void read(OrderedProperties op, BufferedReader rd) throws IOException {
        while (true) {
            String val;
            String s = null;
            s = rd.readLine();
            if (s == null) break;
            String st = s.trim();
            if (st.length() == 0 || st.charAt(0) == '#') continue;
            String lineWithoutComment = null;
            lineWithoutComment = st.indexOf(";") == -1 ? st : st.substring(0, st.indexOf(";"));
            String lineToCheck = lineWithoutComment.contains("->") ? lineWithoutComment.split("->")[lineWithoutComment.split("->").length - 1].trim() : lineWithoutComment;
            Matcher matcher = validationDefinitionPattern.matcher(lineToCheck);
            if (matcher.matches()) {
                this.unparsedValidationDefinitions.add(lineWithoutComment);
                continue;
            }
            int l = s.indexOf(61);
            int lpar = s.indexOf(123);
            if (l == -1 && lpar == -1) {
                this.mpe.add(this.fail("non-empty, non-comment line without = or {", s));
                continue;
            }
            if ((l == -1 || l > lpar) && lpar != -1) {
                l = lpar;
            } else {
                lpar = l + 1;
            }
            String k = s.substring(0, l);
            String kt = k.trim();
            if (kt.length() == 0) {
                this.mpe.add(this.fail("zero length key", s));
                continue;
            }
            if (kt.charAt(0) == '!' && kt.length() == 1) {
                this.mpe.add(this.fail("zero length command", s));
                continue;
            }
            if (kt.startsWith("!include")) {
                if (kt.length() > 8) {
                    this.mpe.add(this.fail("unknown command: " + kt, s));
                    continue;
                }
                while (op.get(kt) != null) {
                    kt = kt + "_";
                }
            }
            if (op.putLast(kt, k, val = s.substring(lpar)) == null) continue;
            this.mpe.add(this.fail("ambiguous key " + kt, s));
        }
        rd.close();
    }

    public void parseSubfields(String fieldName) {
        switch (this.getFieldInfo(fieldName).getIntegerType()) {
            case 2: 
            case 13: {
                this.parse_ptrOne_Subfields(fieldName);
                break;
            }
            case 12: {
                this.parse_set_Subfields(fieldName);
                break;
            }
        }
    }

    public void parse_ptrOne_Subfields(String fieldName) {
        this.ptrOne_RecordParsers.get(fieldName).parse();
        this.getFieldInfo((String)fieldName).extra2 = this.ptrOne_RecordParsers.get((Object)fieldName).dd.getTitleFieldName();
    }

    public void parse_set_Subfields(String fieldName) {
        if (this.getFieldInfo((String)fieldName).extra2 == null) {
            this.subtableParser_subtables.get((Object)fieldName).title = this.setParser_settbls.get(fieldName).getTitleFieldName();
            this.getFieldInfo((String)fieldName).extra2 = this.subtableParser_subtables.get((Object)fieldName).title;
        }
    }

    String acceptTitle(String fieldName, String nm, String origNm, String val, Object o) {
        val = val.trim();
        if (nm.equals("!title")) {
            DataDefinition ri = (DataDefinition)o;
            if (ri.getFieldDefinition(val) == null) {
                return ri.getName() + " has no field called " + val;
            }
            this.getFieldInfo((String)fieldName).extra2 = val;
            return null;
        }
        return this.addText(fieldName, nm, origNm, val);
    }

    String addText(String fieldName, String nm, String origNm, String val) {
        switch (this.getFieldInfo(fieldName).getIntegerType()) {
            case 0: 
            case 1: {
                return this.add_ptr_Text(fieldName, nm, origNm, val);
            }
            case 2: 
            case 13: {
                return this.add_ptrOne_Text(fieldName, nm, origNm, val);
            }
            case 12: {
                return this.add_set_Text(fieldName, nm, origNm, val);
            }
        }
        return this.base_addText(fieldName, nm, origNm, val);
    }

    String base_addText(String fieldName, String nm, String origNm, String val) {
        return "subfield not allowed";
    }

    String add_ptr_Text(String fieldName, String nm, String origNm, String val) {
        return this.acceptTitle(fieldName, nm, origNm, val, this.getFieldInfo((String)fieldName).extra1);
    }

    String add_ptrOne_Text(String fieldName, String nm, String origNm, String val) {
        if (this.ptrOne_RecordParsers.get((Object)fieldName).text.putLast(nm, origNm, val) != null) {
            return "field already exists";
        }
        return null;
    }

    String add_set_Text(String fieldName, String nm, String origNm, String val) {
        String s = this.acceptTitle(fieldName, nm, origNm, val, this.setParser_settbls.get(fieldName));
        if (s == null) {
            this.subtableParser_subtables.get((Object)fieldName).title = val.trim();
        }
        return s;
    }

    void parse(String fieldName, FieldCursor fc) throws DataDefinitionParseError {
        while (true) {
            if (fc.lookup("not")) {
                if (this.getFieldInfo((String)fieldName).notNull) {
                    throw fc.fail("too many not null");
                }
                if (this.getFieldInfo((String)fieldName).notEmpty) {
                    throw fc.fail("too many not empty");
                }
                if (fc.lookup("null")) {
                    this.getFieldInfo((String)fieldName).notNull = true;
                } else if (fc.lookup("empty")) {
                    this.getFieldInfo((String)fieldName).notEmpty = true;
                } else {
                    throw fc.fail("null or empty expected");
                }
                fc.expectWhitespace();
                continue;
            }
            if (fc.lookup("fixed")) {
                fc.expectWhitespace();
                if (this.getFieldInfo((String)fieldName).fixed) {
                    throw fc.fail("too many fixed");
                }
                this.getFieldInfo((String)fieldName).fixed = true;
                continue;
            }
            if (!fc.lookup("unique")) break;
            fc.expectWhitespace();
            if (this.getFieldInfo((String)fieldName).unique) {
                throw fc.fail("already unique");
            }
            this.getFieldInfo((String)fieldName).unique = true;
        }
        if (this.setType(fieldName, fc.expectTypeLiteral(), fc) == null) {
            String s = this.definedTypes.getProperty(this.getFieldInfo((String)fieldName).type);
            if (s == null) {
                throw fc.fail("unknown type: " + this.getFieldInfo((String)fieldName).type);
            }
            fc.substitute(this.getFieldInfo((String)fieldName).type.length(), s);
            if (this.setType(fieldName, fc.expectTypeLiteral(), fc) == null) {
                throw fc.fail("unknown type: " + this.getFieldInfo((String)fieldName).type);
            }
        }
        this.getFieldInfo((String)fieldName).description = this.getFieldInfo((String)fieldName).description == null ? this.getFieldInfo((String)fieldName).name : this.getFieldInfo((String)fieldName).description;
    }

    String setType(String fieldName, String type, FieldCursor fc) throws DataDefinitionParseError {
        String initialType = type;
        this.getFieldInfo((String)fieldName).type = type;
        while (FieldInfo.integerTypeMap.get((Object)this.getFieldInfo((String)fieldName).type) != null) {
            this.parse1(fieldName, fc);
            if (initialType.equals(FieldInfo.getStringType(20))) {
                return this.getFieldInfo((String)fieldName).type;
            }
            if (this.getFieldInfo((String)fieldName).type.equals(initialType)) {
                return initialType;
            }
            initialType = this.getFieldInfo((String)fieldName).type;
        }
        return null;
    }

    void parse1(String fieldName, FieldCursor fc) {
        switch (this.getFieldInfo(fieldName).getIntegerType()) {
            case 7: {
                this.charEnum_parse1(fieldName, fc);
                return;
            }
            case 6: {
                this.char_parse1(fieldName, fc);
                return;
            }
            case 5: {
                this.intEnum_parse1(fieldName, fc);
                return;
            }
            case 4: {
                this.int_parse1(fieldName, fc);
                return;
            }
            case 2: {
                this.ptrOne_parse1(fieldName, fc);
                return;
            }
            case 20: {
                this.parseFile(fieldName, fc);
                return;
            }
            case 0: 
            case 1: {
                this.ptr_parse1(fieldName, fc);
                return;
            }
            case 16: {
                this.setCharEnum_parse1(fieldName, fc);
                return;
            }
            case 13: {
                this.setComplex_parse1(fieldName, fc);
                return;
            }
            case 17: {
                this.setIntEnum_parse1(fieldName, fc);
                return;
            }
            case 12: {
                this.set_parse1(fieldName, fc);
                return;
            }
            case 8: {
                this.text_parse1(fieldName, fc);
                return;
            }
            case 9: {
                this.date_parse1(fieldName, fc);
                return;
            }
            case 3: 
            case 10: 
            case 11: 
            case 15: {
                this.simple_parse1(fieldName, fc);
                return;
            }
        }
    }

    public void int_parse1(String fieldName, FieldCursor fc) {
        if (!fc.lookup("{")) {
            this.getFieldInfo((String)fieldName).description = fc.lookupDescription();
            return;
        }
        this.getFieldInfo((String)fieldName).type = "intEnum";
    }

    public void intEnum_parse1(String fieldName, FieldCursor fc) {
        fc.expectIntEnum(this.getFieldInfo(fieldName));
        this.getFieldInfo((String)fieldName).description = fc.lookupDescription();
    }

    public void char_parse1(String fieldName, FieldCursor fc) {
        if (!fc.lookup("{")) {
            fc.expect("[");
            Integer size = fc.expectInteger();
            if (size > 255 || size < 0) {
                throw fc.fail("char size must be between 0 and 255, not " + size.toString());
            }
            this.getFieldInfo((String)fieldName).extra2 = size;
            fc.expect("]");
            this.getFieldInfo((String)fieldName).description = fc.lookupDescription();
            return;
        }
        this.getFieldInfo((String)fieldName).type = "charEnum";
    }

    public void charEnum_parse1(String fieldName, FieldCursor fc) {
        fc.expectCharEnum(this.getFieldInfo(fieldName));
        this.getFieldInfo((String)fieldName).description = fc.lookupDescription();
    }

    public void simple_parse1(String fieldName, FieldCursor fc) {
        this.getFieldInfo((String)fieldName).description = fc.lookupDescription();
    }

    public void date_parse1(String fieldName, FieldCursor fc) {
        this.getFieldInfo((String)fieldName).description = fc.lookupDescription();
    }

    public void text_parse1(String fieldName, FieldCursor fc) throws DataDefinitionParseError {
        if (this.getFieldInfo(fieldName).isUnique()) {
            throw fc.fail("text fields can't be declared unique");
        }
    }

    public void setComplex_parse1(String fieldName, FieldCursor fc) {
        this.ptrOne_parse1(fieldName, fc);
        this.subtableParser_subtables.get((Object)fieldName).mainPtr = this.addPtrHere(fieldName);
    }

    public void ptrOne_parse1(String fieldName, FieldCursor fc) {
        this.makeSubtable(fieldName, fc);
        this.ptrOne_RecordParsers.put(fieldName, new RecordParser(this.subtableParser_subtables.get(fieldName), this));
    }

    public void parseFile(String fieldName, FieldCursor fc) {
        this.subtableParser_here.put(fieldName, this.dd);
        String name = this.getFieldInfo((String)fieldName).name;
        this.subtableParser_subtables.put(fieldName, new FileRecordInfo(this.dd, name));
        this.getFieldInfo((String)fieldName).type = FieldInfo.getStringType(2);
        this.subtableParser_subtables.get(fieldName).addStandardFields(this.subtableParser_subtables.get((Object)fieldName).subfield);
        this.getFieldInfo((String)fieldName).extra1 = this.subtableParser_subtables.get(fieldName);
        this.ptrOne_RecordParsers.put(fieldName, new RecordParser(this.subtableParser_subtables.get(fieldName), this));
    }

    public void setCharEnum_parse1(String fieldName, FieldCursor fc) {
        FieldInfo _enum = new FieldInfo(this.subtableParser_subtables.get(fieldName), "enum");
        this.makeSubtable(fieldName, fc);
        this.subtableParser_subtables.get((Object)fieldName).mainPtr = this.addPtrHere(fieldName);
        this.subtableParser_subtables.get(fieldName).addField1(_enum);
        this.subtableParser_subtables.get((Object)fieldName).title = _enum.name;
        this.subtableParser_subtables.get((Object)fieldName).setField = _enum.name;
        _enum.type = "charEnum";
        fc.expectCharEnum(_enum);
        this.getFieldInfo((String)fieldName).description = fc.lookupDescription();
        _enum.description = this.getFieldInfo(fieldName).getDescription() == null ? _enum.name : this.getFieldInfo(fieldName).getDescription();
    }

    public void setIntEnum_parse1(String fieldName, FieldCursor fc) {
        FieldInfo _enum = new FieldInfo(this.subtableParser_subtables.get(fieldName), "enum");
        this.makeSubtable(fieldName, fc);
        this.subtableParser_subtables.get((Object)fieldName).mainPtr = this.addPtrHere(fieldName);
        this.subtableParser_subtables.get(fieldName).addField1(_enum);
        this.subtableParser_subtables.get((Object)fieldName).title = _enum.name;
        this.subtableParser_subtables.get((Object)fieldName).setField = _enum.name;
        _enum.type = "intEnum";
        fc.expectIntEnum(_enum);
        this.getFieldInfo((String)fieldName).description = fc.lookupDescription();
        _enum.description = this.getFieldInfo(fieldName).getDescription() == null ? _enum.name : this.getFieldInfo(fieldName).getDescription();
    }

    public void ptr_parse1(String fieldName, FieldCursor fc) {
        DataDefinition o = fc.lookupTableSpecifier();
        if (o != null) {
            this.getFieldInfo((String)fieldName).extra1 = o;
        }
        try {
            this.getFieldInfo((String)fieldName).description = fc.lookupDescription();
        }
        catch (DataDefinitionParseError e) {
            throw fc.fail("table specifier or nothing expected");
        }
        if (o != null) {
            return;
        }
        this.getFieldInfo((String)fieldName).type = "ptrOne";
    }

    public void set_parse1(String fieldName, FieldCursor fc) {
        if (this.getFieldInfo(fieldName).isUnique()) {
            throw fc.fail("sets can't be declared unique");
        }
        DataDefinition ori = fc.lookupTableSpecifier();
        if (ori == null) {
            String word = fc.lookupTypeLiteral();
            if (word == null) {
                try {
                    this.getFieldInfo((String)fieldName).description = fc.lookupDescription();
                }
                catch (DataDefinitionParseError pe) {
                    throw fc.fail("table specifier, enumeration type, or nothing expected");
                }
                this.getFieldInfo((String)fieldName).type = "setComplex";
                return;
            }
            String newName = this.enumSet(fieldName, fc, word);
            if (newName != null) {
                this.getFieldInfo((String)fieldName).type = newName;
                return;
            }
            String s = fc.rp.definedTypes.getProperty(word);
            if (s == null) {
                throw fc.fail("table, char{}, int{} or macro type expected after set");
            }
            fc.substitute(word.length(), s);
            newName = this.enumSet(fieldName, fc, fc.expectTypeLiteral());
            if (newName != null) {
                this.getFieldInfo((String)fieldName).type = newName;
                return;
            }
            throw fc.fail("int{} or char{} macro expected after set");
        }
        this.makeSubtable(fieldName, fc);
        this.subtableParser_subtables.get((Object)fieldName).mainPtr = this.addPtrHere(fieldName);
        this.setParser_settbls.put(fieldName, ori);
        this.subtableParser_subtables.get((Object)fieldName).setField = this.addPtr(fieldName, ((RecordInfo)this.setParser_settbls.get(fieldName)).getBaseName(), ori);
    }

    String enumSet(String fieldName, FieldCursor fc, String word) {
        if (fc.lookup("{")) {
            String newName;
            this.getFieldInfo((String)fieldName).type = newName = "set" + word + "Enum";
            if (newName != null) {
                return newName;
            }
            fc.fail("int{} or char{} expected after set");
        }
        return null;
    }

    void makeSubtable(String fieldName, FieldCursor fc) {
        this.subtableParser_here.put(fieldName, this.dd);
        this.subtableParser_subtables.put(fieldName, this.subtableParser_here.get(fieldName).makeSubtable(this.getFieldInfo((String)fieldName).name));
        this.subtableParser_subtables.get(fieldName).addStandardFields(this.subtableParser_subtables.get((Object)fieldName).subfield);
        this.getFieldInfo((String)fieldName).extra1 = this.subtableParser_subtables.get(fieldName);
    }

    String addPtr(String fieldName, String name, DataDefinition o) {
        int n = name.lastIndexOf(46);
        if (n != -1) {
            name = name.substring(n + 1);
        }
        while (this.subtableParser_subtables.get((Object)fieldName).fields.get(name) != null) {
            name = name + "_";
        }
        FieldInfo ptr = new FieldInfo(this.subtableParser_subtables.get(fieldName), name);
        this.subtableParser_subtables.get(fieldName).addField1(ptr);
        ptr.fixed = true;
        ptr.notNull = true;
        ptr.type = "ptrRel";
        ptr.extra1 = o;
        ptr.description = "relational pointer";
        return name;
    }

    String addPtrHere(String fieldName) {
        this.subtableParser_subtables.get((Object)fieldName).relations = 1;
        if (this.subtableParser_here.get(fieldName).getParentField() != null) {
            return this.addPtr(fieldName, this.subtableParser_here.get((Object)fieldName).subfield, this.subtableParser_here.get(fieldName));
        }
        return this.addPtr(fieldName, this.subtableParser_here.get((Object)fieldName).name, this.subtableParser_here.get(fieldName));
    }

    public void parseValidationDefinition() throws ValidationDefinitionParseError {
        ValidationDefinitionParseError mpe = new ValidationDefinitionParseError();
        for (String line : this.unparsedValidationDefinitions) {
            try {
                Matcher matcher;
                FieldDefinition fd;
                Matcher singleValidationMatcher;
                line = line.trim();
                if (line.indexOf(";") != -1) {
                    line = line.substring(0, line.indexOf(";")).trim();
                }
                String subFieldName = null;
                RecordInfo targetDD = this.dd;
                if (line.contains("->")) {
                    int index = line.lastIndexOf("->");
                    subFieldName = line.substring(0, index).replace("->", ".");
                    line = line.substring(index + 2);
                    targetDD = (RecordInfo)this.dd.getFieldOrPointedFieldDefinition(subFieldName).getPointedType();
                }
                if (!(singleValidationMatcher = validationDefinitionPattern.matcher(line)).matches()) {
                    throw new ValidationDefinitionParseError(targetDD.getName(), "Illegal rule definition!", line);
                }
                if (line.indexOf(validationRuleErrorMessageSeparatorChar) == -1) {
                    throw new ValidationDefinitionParseError(targetDD.getName(), "Rule does not consist of the two parts <rule>:<message>!", line);
                }
                String fieldName = singleValidationMatcher.group(1).trim();
                String operation = singleValidationMatcher.group(2).trim();
                String ruleDef = singleValidationMatcher.group(3).trim();
                String errorMessage = line.substring(line.lastIndexOf(validationRuleErrorMessageSeparatorChar) + validationRuleErrorMessageSeparatorChar.length()).trim();
                String ruleName = line;
                BasicValidationRule rule = null;
                if (StringUtils.equals((String)operation, (String)RegExpValidationRule.getOperator())) {
                    fd = DataDefinitionProvider.getFieldDefinition(targetDD, fieldName, line);
                    rule = new RegExpValidationRule(fd, fieldName, ruleName, errorMessage, ruleDef);
                } else if (StringUtils.equals((String)operation, (String)NumberRangeValidationRule.getOperator())) {
                    fd = DataDefinitionProvider.getFieldDefinition(targetDD, fieldName, line);
                    matcher = RangeValidationRule.getMatcher(ruleDef);
                    if (!matcher.matches()) {
                        throw new ValidationDefinitionParseError("", "Illegal range definition", line);
                    }
                    rule = new NumberRangeValidationRule(fd, fieldName, ruleName, errorMessage, matcher.group(1).trim(), matcher.group(2).trim());
                } else if (StringUtils.equals((String)operation, (String)StringLengthValidationRule.getOperator())) {
                    fd = DataDefinitionProvider.getFieldDefinition(targetDD, fieldName, line);
                    matcher = RangeValidationRule.getMatcher(ruleDef);
                    if (!matcher.matches()) {
                        throw new ValidationDefinitionParseError("", "Illegal range definition", line);
                    }
                    rule = new StringLengthValidationRule(fd, fieldName, ruleName, errorMessage, matcher.group(1).trim(), matcher.group(2).trim());
                } else if (StringUtils.equals((String)operation, (String)ComparisonValidationRule.getOperator())) {
                    matcher = ComparisonValidationRule.getMatcher(ruleDef);
                    if (!matcher.matches()) {
                        throw new ValidationDefinitionParseError("", "Illegal comparison definition", line);
                    }
                    if (targetDD.getFieldDefinition(fieldName) == null) {
                        fieldName = matcher.group(1);
                    }
                    String functionName = null;
                    if (BasicValidationRule.isValidFunctionCall(fieldName)) {
                        functionName = BasicValidationRule.extractFunctionNameFromStatement(fieldName);
                        fieldName = BasicValidationRule.extractFunctionArgument(fieldName);
                    }
                    FieldDefinition fd2 = DataDefinitionProvider.getFieldDefinition(targetDD, fieldName, line);
                    String operator = matcher.group(2).trim();
                    String compareTo = matcher.group(3).trim();
                    if (fd2.getIntegerType() == 9 && ComparisonValidationRule.matchesDateExpression(compareTo)) {
                        rule = new ComparisonValidationRule(fd2, fieldName, compareTo, ruleName, errorMessage, operator);
                    } else {
                        FieldDefinition otherFd = DataDefinitionProvider.getFieldDefinition(targetDD, compareTo, line);
                        rule = new ComparisonValidationRule(fd2, fieldName, functionName, otherFd, compareTo, ruleName, errorMessage, operator);
                    }
                } else {
                    if (StringUtils.equals((String)operation, (String)"unique")) {
                        matcher = multiUniquePattern.matcher(ruleDef);
                        if (!matcher.matches()) {
                            throw new ValidationDefinitionParseError("", "Illegal multi-field unique definition", line);
                        }
                        ArrayList<String> groupList = new ArrayList<String>();
                        for (int j = 1; j <= matcher.groupCount(); ++j) {
                            if (matcher.group(j) == null) continue;
                            groupList.add(matcher.group(j).trim());
                        }
                        String[] groups = groupList.toArray(new String[groupList.size()]);
                        targetDD.addMultiUniqueKey(new DataDefinition.MultipleUniqueKeyDefinition(groups, line, errorMessage));
                        Logger.getLogger("org.makumba.datadefinition.makumba").finer("added multi-field unique key: " + new DataDefinition.MultipleUniqueKeyDefinition(groups, line, errorMessage));
                        continue;
                    }
                    throw new ValidationDefinitionParseError("", "Rule type not recognised!", line);
                }
                rule.getFieldDefinition().addValidationRule(rule);
                targetDD.addValidationRule(rule);
                Logger.getLogger("org.makumba.datadefinition.makumba").finer("added rule: " + rule);
            }
            catch (ValidationDefinitionParseError e) {
                mpe.add(e);
            }
            if (mpe.isSingle()) continue;
            throw mpe;
        }
        if (!mpe.isSingle()) {
            throw mpe;
        }
    }

    public static void main(String[] args) {
        System.out.println("Testing some reg-exps:");
        RegExpUtils.evaluate(funcDefPattern, " someFunc() { abc } errorMessage", " someFunc(char[] a, int 5) {abc}errorMessages", "someFunction(int a, char[] b) { yeah}errorMessage3", "someOtherFunction(int age, char[] b) { this.age > age } You are too young!");
        System.out.println("\n\n*****************************************************************************");
        RegExpUtils.evaluate(multiUniquePattern, "unique12%unique = age, email : these need to be unique!");
        System.out.println("\n\n*****************************************************************************");
        System.out.println("Testing reading test.Person MDD:");
        DataDefinition recordInfo = RecordInfo.getRecordInfo("test.Person");
        System.out.println("\n\n*****************************************************************************");
        RecordParser.printFunctions(recordInfo);
        RecordParser.printFunctions(recordInfo.getFieldDefinition("address").getPointedType());
        RecordParser.printFunctions(recordInfo.getFieldOrPointedFieldDefinition("address.sth").getPointedType());
        System.out.println("\n\n*****************************************************************************");
        RecordParser.printValidationDefinitions(recordInfo);
        RecordParser.printValidationDefinitions(recordInfo.getFieldDefinition("address").getPointedType());
        RecordParser.printValidationDefinitions(recordInfo.getFieldOrPointedFieldDefinition("address.sth").getPointedType());
        System.out.println("\n\n*****************************************************************************");
        FieldDefinition fi = recordInfo.getFieldDefinition("someAttachment");
        System.out.println("extra1:" + ((FieldInfo)fi).extra1);
        System.out.println("extra2:" + ((FieldInfo)fi).extra2);
        System.out.println("extra3:" + ((FieldInfo)fi).extra3);
        System.out.println("File sub-ptr in test.Person:");
        System.out.println("\ttype: " + fi);
        DataDefinition pointedType = fi.getPointedType();
        System.out.println("\tname: " + pointedType);
        System.out.println("\tfields: " + pointedType.getFieldNames());
        for (String string : pointedType.getFieldNames()) {
            System.out.println("\t\t" + string + ": " + pointedType.getFieldDefinition(string));
        }
    }

    private static void printValidationDefinitions(DataDefinition recordInfo) {
        System.out.println("Validation definitions in " + recordInfo);
        for (String field : recordInfo.getFieldNames()) {
            Collection<ValidationRule> validationRules = recordInfo.getValidationDefinition().getValidationRules(field);
            if (validationRules.size() > 0) {
                System.out.println("\t" + field);
            }
            for (ValidationRule validationRule : validationRules) {
                System.out.println("\t\t" + validationRule);
            }
        }
        System.out.println("\n");
    }

    private static void printFunctions(DataDefinition dd) {
        System.out.println("Functions in " + dd);
        Collection<DataDefinition.QueryFragmentFunction> functions = dd.getFunctions();
        for (DataDefinition.QueryFragmentFunction queryFragmentFunction : functions) {
            System.out.println("\t" + queryFragmentFunction);
            System.out.println("\t\tparameters:");
            DataDefinition parameters = queryFragmentFunction.getParameters();
            for (int i = 0; i < parameters.getFieldNames().size(); ++i) {
                FieldDefinition fieldDefinition = parameters.getFieldDefinition(i);
                System.out.println("\t\t\t" + fieldDefinition.getDataType() + " " + fieldDefinition.getName());
            }
            if (parameters.getFieldNames().size() != 0) continue;
            System.out.println("\t\t\t--None--");
        }
        System.out.println("\n");
    }
}

