/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservedKeywords {
    private static Set<String> reservedKeywords;
    private static String[] javaReserved;
    private static String[] hibernateReserved;
    private static String[] sqlReserved;

    public static Set<String> getReservedKeywords() {
        return reservedKeywords;
    }

    public static boolean isReservedKeyword(String s) {
        return reservedKeywords.contains(s);
    }

    public static String getKeywordsAsString() {
        String reserved = new String();
        Iterator<String> i = reservedKeywords.iterator();
        while (i.hasNext()) {
            reserved = reserved + i.next();
            if (!i.hasNext()) continue;
            reserved = reserved + ", ";
        }
        return reserved;
    }

    static {
        javaReserved = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"};
        hibernateReserved = new String[0];
        sqlReserved = new String[]{"avg", "count", "distinct", "group", "order", "sum", "database", "from"};
        reservedKeywords = new HashSet<String>();
        CollectionUtils.addAll(reservedKeywords, (Object[])javaReserved);
        CollectionUtils.addAll(reservedKeywords, (Object[])hibernateReserved);
        CollectionUtils.addAll(reservedKeywords, (Object[])sqlReserved);
    }
}

