/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons.documentation;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import java.util.Map;
import org.apache.commons.lang.WordUtils;

public class Box
implements WikiPlugin {
    private static final String PARAM_LABEL = "label";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_AUTHOR = "author";
    private static final String BODY = "_body";
    private BoxType type;
    private String label;
    private String body;

    public String execute(WikiContext context, Map parameters) throws PluginException {
        this.label = (String)parameters.get(PARAM_LABEL);
        String t = (String)parameters.get(PARAM_TYPE);
        this.type = t == null ? BoxType.NOTE : BoxType.valueOf(t.toUpperCase());
        if (this.label == null) {
            this.label = WordUtils.capitalizeFully((String)this.type.name());
        }
        this.body = (String)parameters.get(BODY);
        if (this.body == null) {
            this.body = "";
        }
        String style = (String)context.getEngine().getWikiProperties().get("box." + this.type.name().toLowerCase() + ".styleName");
        switch (this.type) {
            case NOTE: {
                if (style != null) break;
                style = "note";
                break;
            }
            case WARNING: {
                if (style != null) break;
                style = "warning";
                break;
            }
            case FIXME: {
                String author;
                if (style == null) {
                    style = "fixme";
                }
                if ((author = (String)parameters.get(PARAM_AUTHOR)) == null) {
                    throw new PluginException("You can't have a FIXME box without specifying an author!");
                }
                this.label = this.label + " (" + author + ")";
            }
        }
        StringBuilder b = new StringBuilder();
        b.append("<div class=\"" + style + "\"><div class=\"label\">");
        b.append(this.label);
        b.append("</div><div class=\"content\">");
        b.append(context.getEngine().textToHTML(context, this.body));
        b.append("</div></div>");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoxType {
        NOTE,
        WARNING,
        FIXME;

    }
}

