/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.makumba.Attributes;
import org.makumba.commons.SingletonHolder;
import org.makumba.commons.SingletonReleaser;
import org.makumba.providers.QueryAnalysisProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryProvider
implements SingletonHolder {
    private static String[] queryProviders = new String[]{"oql", "org.makumba.db.makumba.OQLQueryProvider", "hql", "org.makumba.db.hibernate.HQLQueryProvider"};
    static final Map<String, QueryAnalysisProvider> analyzersByClass = new HashMap<String, QueryAnalysisProvider>();
    static final Map<String, QueryAnalysisProvider> analyzersByName = new HashMap<String, QueryAnalysisProvider>();
    static final Map<String, Class<?>> providerClasses = new HashMap();
    private String dataSource;
    private QueryAnalysisProvider qap;

    public QueryProvider() {
        SingletonReleaser.register(this);
        try {
            this.qap = analyzersByClass.get(this.getQueryAnalysisProviderClass());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected String getQueryAnalysisProviderClass() {
        return null;
    }

    public static QueryAnalysisProvider getQueryAnalzyer(String name) {
        return analyzersByName.get(name);
    }

    public static QueryProvider makeQueryRunner(String dataSource, String name, Attributes a) {
        QueryProvider qeep = null;
        try {
            qeep = (QueryProvider)providerClasses.get(name).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        qeep.init(dataSource, a);
        return qeep;
    }

    public static QueryProvider makeQueryRunner(String string, String queryLang) {
        return QueryProvider.makeQueryRunner(string, queryLang, null);
    }

    protected void init(String dataSource, Attributes a) {
        this.dataSource = dataSource;
    }

    public abstract Vector<Dictionary<String, Object>> executeRaw(String var1, Map var2, int var3, int var4);

    public Vector<Dictionary<String, Object>> execute(String query, Map args, int offset, int limit) {
        return this.executeRaw(this.qap.inlineFunctions(query), args, offset, limit);
    }

    public abstract void close();

    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public void release() {
        analyzersByClass.clear();
        analyzersByName.clear();
        providerClasses.clear();
    }

    static {
        for (int i = 0; i < queryProviders.length; i += 2) {
            try {
                QueryProvider qp = (QueryProvider)Class.forName(queryProviders[i + 1]).newInstance();
                QueryAnalysisProvider qa = (QueryAnalysisProvider)Class.forName(qp.getQueryAnalysisProviderClass()).newInstance();
                analyzersByClass.put(qp.getQueryAnalysisProviderClass(), qa);
                analyzersByName.put(queryProviders[i], qa);
                providerClasses.put(queryProviders[i], Class.forName(queryProviders[i + 1]));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

