/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd.validation;

import antlr.collections.AST;
import org.makumba.InvalidValueException;
import org.makumba.Text;
import org.makumba.Transaction;
import org.makumba.providers.datadefinition.mdd.FieldNode;
import org.makumba.providers.datadefinition.mdd.MDDNode;
import org.makumba.providers.datadefinition.mdd.ValidationRuleNode;
import org.makumba.providers.datadefinition.mdd.ValidationType;

public class RangeValidationRule
extends ValidationRuleNode {
    private static final long serialVersionUID = 3906776093230956372L;
    private Number lowerLimit;
    private Number upperLimit;

    public RangeValidationRule(MDDNode mdd, AST originAST, FieldNode field, ValidationType type) {
        super(mdd, originAST, field);
        this.type = type;
    }

    public boolean validate(Object value, Transaction t) throws InvalidValueException {
        if (this.lowerLimit == null || this.upperLimit == null) {
            this.lowerLimit = this.lowerBound.equals("?") ? new Double(Double.MIN_VALUE) : Double.valueOf(this.lowerBound);
            this.upperLimit = this.upperBound.equals("?") ? new Double(Double.MAX_VALUE) : Double.valueOf(this.upperBound);
        }
        switch (this.type) {
            case RANGE: {
                if (!(value instanceof Number)) {
                    return false;
                }
                if (this.lowerLimit.doubleValue() <= ((Number)value).doubleValue() && ((Number)value).doubleValue() <= this.upperLimit.doubleValue()) {
                    return true;
                }
                this.throwException();
                return false;
            }
            case LENGTH: {
                if (!(value instanceof String) && !(value instanceof Text)) {
                    return false;
                }
                String s = value instanceof Text ? ((Text)value).getString() : (String)value;
                if (this.lowerLimit.intValue() <= s.length() && s.length() <= this.upperLimit.intValue()) {
                    return true;
                }
                this.throwException();
                return false;
            }
        }
        throw new RuntimeException("should not be here");
    }

    public String getRuleName() {
        return this.type.name().toLowerCase() + "(" + this.field.getName() + ") {" + this.lowerBound + ".." + this.upperBound + "} : " + this.message + " (line " + this.getLine() + ")";
    }
}

