/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXhtmlWriter
extends PrintWriter {
    protected String filename = "";
    protected String path = "";
    public static final char SLASH = File.separatorChar;
    public static final String DTD_HTML4_LOOSE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
    public static final String DTD_XHTML1_TRANS = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    public static final String DTD_XHTML1_STRICT = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    public static final String DTD_XHTML1_FRAMES = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">";
    public static final String HTML_XML = "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">";
    public static final String META_UTF8 = "<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />";

    protected AbstractXhtmlWriter(String path, String filename, String encoding) throws IOException {
        super(AbstractXhtmlWriter.createOutputStream(path, filename));
        this.path = path;
        this.filename = filename;
    }

    protected static FileOutputStream createOutputStream(String path, String filename) throws IOException {
        if (path != null) {
            AbstractXhtmlWriter.createDirectory(path);
            String filePathPrefix = path.length() > 0 ? path + SLASH : "";
            return new FileOutputStream(filePathPrefix + filename);
        }
        return new FileOutputStream(filename);
    }

    protected static void createDirectory(String path) throws IOException {
        if (path == null || path.length() == 0) {
            return;
        }
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            System.out.println("Unable to create directory: " + path);
            throw new IOException();
        }
    }

    public String empty(String tagContents) {
        return "<" + tagContents + " />";
    }

    public String empty(String tagName, Map<String, String> attributes) {
        return "<" + tagName + this.attributeStringFromMap(attributes) + " />";
    }

    public String open(String tagContents) {
        return "<" + tagContents + ">";
    }

    public String open(String tagName, Map<String, String> attributes) {
        return "<" + tagName + this.attributeStringFromMap(attributes) + ">";
    }

    public String close(String tagName) {
        return "</" + tagName + ">";
    }

    protected String attributeStringFromMap(Map<String, String> attributes) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            sb.append(" " + entry.getKey() + "=\"" + this.escapeHTML(entry.getValue()) + "\"");
        }
        return sb.toString();
    }

    protected String escapeHTML(String input) {
        String output = input;
        output = output.replaceAll("&", "&amp;");
        output = output.replaceAll("<", "&lt;");
        output = output.replaceAll(">", "&gt;");
        output = output.replaceAll("\"", "&quot;");
        output = output.replaceAll("'", "&apos;");
        return output;
    }

    protected final String definitionList(String term, String definition) {
        return this.definitionList(term, new String[]{definition});
    }

    protected final String definitionList(String term, String[] definitions) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.open("dl") + "\n");
        buffer.append(this.open("dt") + term + this.close("dt") + "\n");
        if (definitions != null) {
            for (String definition : definitions) {
                buffer.append(this.open("dd") + definition + this.close("dd") + "\n");
            }
        }
        buffer.append(this.close("dl"));
        return buffer.toString();
    }

    protected final String openDivWithClass(String classValue) {
        return "<div class=\"" + classValue + "\">";
    }

    protected final String openDivWithID(String idValue) {
        return "<div id=\"" + idValue + "\">";
    }

    protected final String openULWithID(String idValue) {
        return "<ul id=\"" + idValue + "\">";
    }

    protected final String hiddenBR() {
        return "<br style=\"display: none;\" />";
    }

    protected final String hrefForPageAnchor(String page, String anchor) {
        return "" + (page != null ? page : "") + (anchor != null && !anchor.equals("") ? "#" + anchor : "");
    }

    protected final String listItem(String innerText) {
        return "<li>" + innerText + "</li>";
    }

    protected final String linkToLabelHref(String label, String href) {
        if (href == null) {
            return label;
        }
        return new TagBuilder("a").add("href", href).getOpenTextClose(label);
    }

    protected final String linkToLabelHrefName(String label, String href, String name) {
        return new TagBuilder("a").add("href", href).add("name", name).getOpenTextClose(label);
    }

    protected final String linkToLabelHrefTitle(String label, String href, String title) {
        return new TagBuilder("a").add("href", href).add("title", title).getOpenTextClose(label);
    }

    protected final String linkToLabelHrefTarget(String label, String href, String target) {
        return new TagBuilder("a").add("target", target).add("href", href).getOpenTextClose(label);
    }

    protected final String linkToLabelHrefTargetTitle(String label, String href, String target, String title) {
        return new TagBuilder("a").add("href", href).add("target", target).add("title", title).getOpenTextClose(label);
    }

    protected final String scriptOpenJavascript() {
        return new TagBuilder("script").add("language", "JavaScript").add("type", "text/javascript").getOpen();
    }

    protected String spaces(int length, boolean nonBreaking) {
        StringBuffer spaces = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            spaces.append(nonBreaking ? "&nbsp;" : " ");
        }
        return spaces.toString();
    }

    protected void printDD(String text) {
        if (text != null && !text.equals("")) {
            this.println(this.open("dd") + text + this.close("dd"));
        }
    }

    protected void printDT(String text) {
        if (text != null && !text.equals("")) {
            this.println(this.open("dt") + text + this.close("dt"));
        }
    }

    protected void printDTWithClass(String text, String cssClass) {
        this.println(this.open("dt class=\"" + cssClass + "\"") + text + this.close("dt"));
    }

    protected void printTH(String text) {
        this.println(this.open("th") + text + this.close("th"));
    }

    protected void printTD(String text) {
        this.println(this.open("td") + text + this.close("td"));
    }

    protected void printTDWithClass(String text, String cssClass) {
        this.println(this.open("td class=\"" + cssClass + "\"") + text + this.close("td"));
    }

    protected String bold(Object obj) {
        return new TagBuilder("strong").getOpenTextClose(obj.toString());
    }

    protected final String getComment(String innerText) {
        return "<!-- " + innerText + " -->";
    }

    protected final String getJoinedStrings(List<String> strings, String separator) {
        return strings == null ? null : this.getJoinedStrings(strings.toArray(new String[0]), separator);
    }

    protected final String getJoinedStrings(Object[] elements, String separator) {
        if (elements == null || separator == null) {
            return null;
        }
        StringBuffer joinedStrings = new StringBuffer();
        boolean first = true;
        for (Object obj : elements) {
            if (!first) {
                joinedStrings.append(separator);
            }
            joinedStrings.append(obj.toString());
            first = false;
        }
        return joinedStrings.toString();
    }

    protected final String getSectionDelimiter(String sectionName) {
        return "<!-- =========== " + sectionName + " =========== -->";
    }

    protected final String today() {
        return new GregorianCalendar(TimeZone.getDefault()).getTime().toString();
    }

    public class TagBuilder {
        private String tagName;
        private Map<String, String> attributes;

        public TagBuilder(String tagName) {
            this.tagName = tagName;
            this.attributes = new LinkedHashMap<String, String>();
        }

        public TagBuilder(TagBuilder builder) {
            this.tagName = builder.tagName;
            this.attributes = new LinkedHashMap<String, String>(builder.attributes);
        }

        public TagBuilder add(String attribute, String value) {
            if (attribute != null && !attribute.equals("") && value != null) {
                this.attributes.put(attribute.toLowerCase(), value);
            }
            return this;
        }

        public TagBuilder remove(String attribute) {
            this.attributes.remove(attribute);
            return this;
        }

        public TagBuilder clear() {
            this.attributes.clear();
            return this;
        }

        public TagBuilder setName(String newName) {
            this.tagName = newName;
            return this;
        }

        public String getEmpty() {
            return AbstractXhtmlWriter.this.empty(this.tagName, this.attributes);
        }

        public String getOpen() {
            return AbstractXhtmlWriter.this.open(this.tagName, this.attributes);
        }

        public String getClose() {
            return AbstractXhtmlWriter.this.close(this.tagName);
        }

        public String getOpenTextClose(String text) {
            return AbstractXhtmlWriter.this.open(this.tagName, this.attributes) + text + AbstractXhtmlWriter.this.close(this.tagName);
        }
    }
}

