/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.Doclet;

public final class Help
extends AbstractPageWriter {
    public static void generateHelp() {
        if (Help.CONF.nohelp) {
            return;
        }
        String filename = "help-doc" + Help.CONF.ext;
        try {
            new Help(filename);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private Help(String filename) throws IOException {
        super(filename);
        int n;
        this.pageType = "HELP";
        this.windowTitle = Help.CONF.windowtitle.length() > 0 ? Help.CONF.windowtitle : CONF.propertyText("Help", new Object[0]);
        this.printXhtmlHeader();
        InputStreamReader stream = !Help.CONF.helpfile.equals("") ? new InputStreamReader(new FileInputStream(Help.CONF.helpfile)) : new InputStreamReader(AbstractPageWriter.class.getResourceAsStream("resources/help" + Help.CONF.ext));
        char[] buf = new char[1024];
        while ((n = stream.read(buf)) > 0) {
            this.write(buf, 0, n);
        }
        stream.close();
        this.println();
        this.printXhtmlFooter();
        this.close();
    }

    protected void navLinkHelp() {
        this.println(this.listItemCurrent(HELP));
    }
}

