/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.util.ClassDocCatalog;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.AbstractXhtmlWriter;
import net.sourceforge.xhtmldoclet.Doclet;

public final class PackageFrame
extends AbstractPageWriter {
    private Set<ClassDoc> documentedClasses;

    public static void generatePackageFrame(PackageDoc pkg) {
        String filename = "package-frame" + PackageFrame.CONF.ext;
        String pathToFile = DirectoryManager.getDirectoryPath((PackageDoc)pkg);
        try {
            new PackageFrame(pkg, filename, pathToFile);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, pathToFile + SLASH + filename);
        }
    }

    private PackageFrame(PackageDoc pkg, String filename, String pathToFile) throws IOException {
        super(filename, pathToFile);
        this.pageType = "PACKAGE_FRAME";
        if (PackageFrame.CONF.root.specifiedPackages().length == 0) {
            this.documentedClasses = new HashSet<ClassDoc>(Arrays.asList(PackageFrame.CONF.root.classes()));
        }
        String pkgName = Util.getPackageName((PackageDoc)pkg);
        String[] metaKeywords = new String[]{pkgName + " " + "package"};
        this.windowTitle = CONF.propertyText("Package", new Object[0]) + " " + pkgName;
        this.printXhtmlHeader(metaKeywords, false);
        this.println(this.open("h3") + this.linkToLabelHrefTarget(pkgName, this.pathToPackageFile(pkg, "package-summary" + PackageFrame.CONF.ext), "classFrame") + this.close("h3"));
        if (pkg.isIncluded()) {
            this.printClassListing(pkg.interfaces(), "Interfaces");
            this.printClassListing(pkg.ordinaryClasses(), "Classes");
            this.printClassListing(pkg.enums(), "Enums");
            this.printClassListing(pkg.exceptions(), "Exceptions");
            this.printClassListing(pkg.errors(), "Errors");
            this.printClassListing((ClassDoc[])pkg.annotationTypes(), "Annotation_Types");
        } else {
            String name = Util.getPackageName((PackageDoc)pkg);
            ClassDocCatalog classes = PackageFrame.CONF.classDocCatalog;
            this.printClassListing(classes.interfaces(name), "Interfaces");
            this.printClassListing(classes.ordinaryClasses(name), "Classes");
            this.printClassListing(classes.enums(name), "Enums");
            this.printClassListing(classes.exceptions(name), "Exceptions");
            this.printClassListing(classes.errors(name), "Errors");
            this.printClassListing(classes.annotationTypes(name), "Annotation_Types");
        }
        this.printXhtmlFooter();
        this.close();
    }

    private void printClassListing(ClassDoc[] classes, String labelProperty) {
        String label = CONF.propertyText(labelProperty, new Object[0]);
        if (classes.length > 0) {
            Arrays.sort(classes);
            this.println(this.openDivWithID(label));
            this.println((AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("h4").getOpenTextClose(label));
            for (ClassDoc cur : classes) {
                if (this.documentedClasses != null && !this.documentedClasses.contains(cur) || !Util.isCoreClass((ClassDoc)cur) || !CONF.isGeneratedDoc((Doc)cur)) continue;
                this.println(this.linkToLabelHrefTarget(cur.name(), cur.name() + PackageFrame.CONF.ext, "classFrame") + this.empty("br"));
            }
            this.println(this.close("div") + this.getComment(label));
        }
    }
}

