/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.xhtmldoclet.Doclet;
import net.sourceforge.xhtmldoclet.pages.AbstractIndex;

public final class SplitIndex
extends AbstractIndex {
    private static Character curLetter;
    private static Character prevLetter;
    private static Character nextLetter;
    private static String prevLabel;
    private static String nextLabel;

    public static void generateSplitIndexPages() {
        String filename = null;
        String pathToFile = "index-files" + SLASH;
        try {
            Object[] indexLetters = SplitIndex.CONF.indexBuilder.elements();
            System.out.println(CONF.propertyText("doclet.index", new Object[0]));
            for (int i = 0; i < indexLetters.length; ++i) {
                prevLetter = curLetter;
                curLetter = (Character)indexLetters[i];
                nextLetter = i + 1 < indexLetters.length ? (Character)indexLetters[i + 1] : null;
                filename = "index-" + curLetter + SplitIndex.CONF.ext;
                new SplitIndex(filename, pathToFile);
            }
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private SplitIndex(String filename, String pathToFile) throws IOException {
        super(filename, pathToFile);
        this.windowTitle = SplitIndex.CONF.windowtitle.length() > 0 ? SplitIndex.CONF.windowtitle : CONF.propertyText("Index", curLetter.toString());
        this.printXhtmlHeader();
        this.characterList(curLetter, SplitIndex.CONF.indexBuilder.getMemberList(curLetter));
        this.printXhtmlFooter();
        this.close();
    }

    protected void navPreviousNext() {
        this.println(this.openULWithID("PreviousNext"));
        String prevLink = prevLetter == null ? prevLabel : this.linkToLabelHref(prevLabel, "index-" + prevLetter + SplitIndex.CONF.ext);
        String nextLink = nextLetter == null ? nextLabel : this.linkToLabelHref(nextLabel, "index-" + nextLetter + SplitIndex.CONF.ext);
        this.println(this.listItem(prevLink) + this.listItemLast(nextLink));
        this.println(this.close("ul"));
    }

    protected void navWithinPage() {
        Vector<String> letters = new Vector<String>();
        for (Object letter : SplitIndex.CONF.indexBuilder.elements()) {
            String letterLink = curLetter.equals(letter) ? letter.toString() : this.linkToLabelHref(letter.toString(), "index-" + letter + SplitIndex.CONF.ext);
            letters.add(letterLink);
        }
        this.print(this.open("td id=\"WithinPage\""));
        this.printUnorderedListWithLast(letters);
        this.println(this.close("td"));
    }

    static {
        prevLabel = CONF.propertyText("PrevLetter", new Object[0]);
        nextLabel = CONF.propertyText("NextLetter", new Object[0]);
    }
}

