/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers.locators;

import java.io.File;
import java.io.FilenameFilter;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;
import org.openqa.selenium.server.browserlaunchers.locators.FirefoxLocator;

public class Firefox3Locator
extends FirefoxLocator {
    private static final String UBUNTU_BASE_DIR = "/usr/lib";
    private static final String[] USUAL_OS_X_LAUNCHER_LOCATIONS = new String[]{"/Applications/Firefox-3.app/Contents/MacOS", "/Applications/Firefox.app/Contents/MacOS"};
    private static final String[] USUAL_WINDOWS_LAUNCHER_LOCATIONS = new String[]{WindowsUtils.getProgramFilesPath() + "\\Firefox-3", WindowsUtils.getProgramFilesPath() + "\\Mozilla Firefox", WindowsUtils.getProgramFilesPath() + "\\Firefox"};
    private String[] usualLauncherLocations;

    protected String browserName() {
        return "Firefox 3";
    }

    protected String seleniumBrowserName() {
        return "firefox3";
    }

    protected String[] standardlauncherFilenames() {
        if (this.runningOnWindows()) {
            return new String[]{"firefox.exe"};
        }
        return new String[]{"firefox-bin", "firefox"};
    }

    protected synchronized String[] usualLauncherLocations() {
        if (null == this.usualLauncherLocations) {
            this.usualLauncherLocations = this.runningOnWindows() ? USUAL_WINDOWS_LAUNCHER_LOCATIONS : this.usualUnixLauncherLocations();
        }
        return this.usualLauncherLocations;
    }

    protected String[] usualUnixLauncherLocations() {
        String[] ubuntuLocations = this.firefoxDefaultLocationsOnUbuntu();
        if (ubuntuLocations.length == 0) {
            return USUAL_OS_X_LAUNCHER_LOCATIONS;
        }
        String[] ubuntoLocationPaths = new String[ubuntuLocations.length];
        for (int i = 0; i < ubuntuLocations.length; ++i) {
            ubuntoLocationPaths[i] = "/usr/lib/" + ubuntuLocations[i];
        }
        return ubuntoLocationPaths;
    }

    protected String[] firefoxDefaultLocationsOnUbuntu() {
        File dir = new File(UBUNTU_BASE_DIR);
        if (!dir.exists() && dir.isDirectory()) {
            return new String[0];
        }
        return dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("firefox-");
            }
        });
    }

    protected boolean runningOnWindows() {
        return WindowsUtils.thisIsWindows();
    }
}

