/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;

public class Chunk
extends Token {
    public boolean accessable;
    public boolean visible;
    public boolean initialized;
    public SyntaxStyle style;
    public Color background;
    public float width;
    public GlyphVector gv;
    public String str;
    private float[] positions;

    public static float paintChunkList(Chunk chunks, Graphics2D gfx, float x, float y, boolean glyphVector) {
        Rectangle clipRect = gfx.getClipBounds();
        float _x = 0.0f;
        while (chunks != null) {
            if (x + _x + chunks.width > (float)clipRect.x && x + _x < (float)(clipRect.x + clipRect.width) && chunks.accessable && chunks.visible) {
                gfx.setFont(chunks.style.getFont());
                gfx.setColor(chunks.style.getForegroundColor());
                if (glyphVector && chunks.gv != null) {
                    gfx.drawGlyphVector(chunks.gv, x + _x, y);
                } else if (chunks.str != null) {
                    gfx.drawString(chunks.str, (int)(x + _x), (int)y);
                }
            }
            _x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return _x;
    }

    public static float paintChunkBackgrounds(Chunk chunks, Graphics2D gfx, float x, float y) {
        Rectangle clipRect = gfx.getClipBounds();
        float _x = 0.0f;
        FontMetrics forBackground = gfx.getFontMetrics();
        int ascent = forBackground.getAscent();
        int height = forBackground.getHeight();
        while (chunks != null) {
            Color bgColor;
            if (x + _x + chunks.width > (float)clipRect.x && x + _x < (float)(clipRect.x + clipRect.width) && chunks.accessable && (bgColor = chunks.background) != null) {
                gfx.setColor(bgColor);
                gfx.fill(new Rectangle2D.Float(x + _x, y - (float)ascent, _x + chunks.width - _x, height));
            }
            _x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return _x;
    }

    public static float offsetToX(Chunk chunks, int offset) {
        if (chunks != null && offset < chunks.offset) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(offset) + " < " + chunks.offset);
        }
        float x = 0.0f;
        while (chunks != null) {
            if (chunks.accessable && offset < chunks.offset + chunks.length) {
                return x + chunks.offsetToX(offset - chunks.offset);
            }
            x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return x;
    }

    public static int xToOffset(Chunk chunks, float x, boolean round) {
        float _x = 0.0f;
        while (chunks != null) {
            if (chunks.accessable && x < _x + chunks.width) {
                return chunks.xToOffset(x - _x, round);
            }
            _x += chunks.width;
            chunks = (Chunk)chunks.next;
        }
        return -1;
    }

    public Chunk(float width, int offset, ParserRuleSet rules) {
        super((byte)0, offset, 0, rules);
        this.width = width;
    }

    public Chunk(byte id, int offset, int length, ParserRuleSet rules, SyntaxStyle[] styles, byte defaultID) {
        super(id, offset, length, rules);
        this.accessable = true;
        this.style = styles[id];
        this.background = this.style.getBackgroundColor();
        if (this.background == null) {
            this.background = styles[defaultID].getBackgroundColor();
        }
    }

    public final float[] getPositions() {
        if (this.gv == null) {
            return null;
        }
        if (this.positions == null) {
            this.positions = this.gv.getGlyphPositions(0, this.length, null);
        }
        return this.positions;
    }

    public final float offsetToX(int offset) {
        if (!this.visible) {
            return 0.0f;
        }
        return this.getPositions()[offset * 2];
    }

    public final int xToOffset(float x, boolean round) {
        if (!this.visible) {
            if (round && this.width - x < x) {
                return this.offset + this.length;
            }
            return this.offset;
        }
        float[] pos = this.getPositions();
        int i = 0;
        while (i < this.length) {
            float nextX;
            float glyphX = pos[i * 2];
            float f = nextX = i == this.length - 1 ? this.width : pos[i * 2 + 2];
            if (nextX > x) {
                if (!round || nextX - x > x - glyphX) {
                    return this.offset + i;
                }
                return this.offset + i + 1;
            }
            ++i;
        }
        return -1;
    }

    public void init(Segment seg, TabExpander expander, float x, FontRenderContext fontRenderContext) {
        this.initialized = true;
        if (this.accessable) {
            if (this.length == 1 && seg.array[seg.offset + this.offset] == '\t') {
                this.visible = false;
                float newX = expander.nextTabStop(x, this.offset + this.length);
                this.width = newX - x;
            } else {
                this.visible = true;
                this.str = new String(seg.array, seg.offset + this.offset, this.length);
                this.gv = this.style.getFont().createGlyphVector(fontRenderContext, this.str);
                this.width = (float)this.gv.getLogicalBounds().getWidth();
            }
        }
    }
}

