/*
 * Decompiled with CFR 0.152.
 */
package studio.beansoft.syntax.sample;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class HtmlOutputTokenHandler
implements TokenHandler {
    private StringBuffer buff = new StringBuffer();

    public void handleToken(Segment seg, byte id, int offset, int length, TokenMarker.LineContext context) {
        String segText = new String(seg.array, offset, length);
        if (segText != null) {
            segText = segText.replaceAll("<", "&lt");
            segText = segText.replaceAll(">", "&gt");
        }
        switch (id) {
            case 127: {
                break;
            }
            case 17: {
                this.buff.append("<span class=tag>");
                this.buff.append(segText).append("</span>");
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.buff.append("<span class=reservedWord>");
                this.buff.append(segText).append("</span>");
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.buff.append("<span class=comment>");
                this.buff.append(segText).append("</span>");
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.buff.append("<span class=literal>");
                this.buff.append(segText).append("</span>");
                break;
            }
            case 18: {
                this.buff.append("<span class=operator>");
                this.buff.append(segText).append("</span>");
                break;
            }
            default: {
                this.buff.append(segText);
            }
        }
    }

    public void reset() {
        this.buff.delete(0, this.buff.length());
    }

    public String getOutputText() {
        return this.buff.toString();
    }

    public void setLineContext(TokenMarker.LineContext lineContext) {
    }
}

