/*
 * Decompiled with CFR 0.152.
 */
package beansoft.net;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;

public class HttpPostBean {
    private String encoding = "UTF-8";
    private Hashtable parameters = new Hashtable();
    private String url;
    private byte[] response;
    private String method = "post";

    public boolean doPost() {
        if (this.url == null || this.url.length() == 0) {
            return false;
        }
        try {
            URL url = new URL(this.getUrl());
            boolean isPost = "post".equalsIgnoreCase(this.getMethod());
            String urlGetMethod = this.getUrl().indexOf("?") == -1 ? String.valueOf(this.getUrl()) + "?" : this.getUrl();
            String content = "";
            Enumeration enumeration = this.parameters.keys();
            boolean first = true;
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement().toString();
                if (!first) {
                    content = String.valueOf(content) + "&";
                }
                content = String.valueOf(content) + URLEncoder.encode(key, this.getEncoding()) + "=" + URLEncoder.encode(this.parameters.get(key).toString(), this.getEncoding());
                first = false;
            }
            if (!isPost) {
                urlGetMethod = String.valueOf(urlGetMethod) + content;
                url = new URL(urlGetMethod);
            }
            URLConnection urlConn = url.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            if (isPost) {
                urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
                printout.writeBytes(content);
                printout.flush();
                printout.close();
            }
            this.setResponse(null);
            int data = 0;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            InputStream in = urlConn.getInputStream();
            while ((data = in.read()) != -1) {
                bout.write(data);
            }
            this.setResponse(bout.toByteArray());
            in.close();
            return true;
        }
        catch (MalformedURLException me) {
            this.setResponse(("" + me).getBytes());
            return false;
        }
        catch (Exception ex) {
            System.err.println("Exception: " + ex.getMessage());
            this.setResponse(("" + ex).getBytes());
            return false;
        }
    }

    public void addParameter(String key, String value) {
        if (value == null || value.length() == 0) {
            this.removeParameter(key);
        } else {
            this.parameters.put(key, value);
        }
    }

    public void removeParameter(String key) {
        if (key != null) {
            this.parameters.remove(key);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public byte[] getResponse() {
        return this.response;
    }

    private void setResponse(byte[] response) {
        this.response = response;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

