/*
 * Decompiled with CFR 0.152.
 */
package beansoft.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class DatabaseUtil {
    private Connection connection;
    private ArrayList resourcesList = new ArrayList(5);

    public void close() {
        this.closeAllResources();
        DatabaseUtil.close(this.getConnection());
    }

    public static void close(Connection connection) {
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeAllResources() {
        int i = 0;
        while (i < this.getResourcesList().size()) {
            this.closeJDBCResource(this.getResourcesList().get(i));
            ++i;
        }
    }

    public void closeJDBCResource(Object resource) {
        try {
            Class<?> clazz = resource.getClass();
            Method method = clazz.getMethod("close", null);
            method.invoke(resource, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ResultSet executeQuery(String sql) {
        try {
            Statement statement = this.getStatement();
            ResultSet rs = statement.executeQuery(sql);
            this.getResourcesList().add(rs);
            this.getResourcesList().add(statement);
            return rs;
        }
        catch (Exception ex) {
            System.out.println("Error in executeQuery(\"" + sql + "\"):" + ex);
            return null;
        }
    }

    public int executeUpdate(String sql) {
        try {
            Statement statement = this.getStatement();
            return statement.executeUpdate(sql);
        }
        catch (Exception ex) {
            System.out.println("Error in executeUpdate(): " + sql + " " + ex);
            ex.printStackTrace();
            return -1;
        }
    }

    public int getAllCount(String sql) {
        try {
            int cnt = 0;
            Statement statement = this.getConnection().createStatement();
            this.getResourcesList().add(statement);
            ResultSet rs = statement.executeQuery(sql);
            if (rs.next()) {
                cnt = rs.getInt(1);
            }
            rs.close();
            try {
                statement.close();
                this.getResourcesList().remove(statement);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return cnt;
        }
        catch (Exception ex) {
            System.out.println("Exception in DatabaseUtil.getAllCount(" + sql + "):" + ex);
            ex.printStackTrace();
            return 0;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        if (this.connection != null) {
            try {
                this.getConnection().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connection = connection;
    }

    public Statement getStatement() {
        Statement updatableStmt = this.getUpdatableStatement();
        if (updatableStmt != null) {
            return updatableStmt;
        }
        try {
            Statement statement = this.getConnection().createStatement();
            this.getResourcesList().add(statement);
            return statement;
        }
        catch (Exception ex) {
            System.out.println("Error in getStatement(): " + ex);
            return null;
        }
    }

    public Statement getUpdatableStatement() {
        try {
            Statement statement = this.getConnection().createStatement(1005, 1008);
            this.getResourcesList().add(statement);
            return statement;
        }
        catch (Exception ex) {
            System.out.println("Error in getUpdatableStatement(): " + ex);
            return null;
        }
    }

    public PreparedStatement getPreparedStatement(String sql) {
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql, 1004, 1008);
            this.getResourcesList().add(preparedStatement);
            return preparedStatement;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ArrayList getResourcesList() {
        return this.resourcesList;
    }

    public static String getString(ResultSet rs, String columnName) {
        try {
            String result = rs.getString(columnName);
            if (result == null) {
                result = "";
            }
            return result;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String[] getColumns(ResultSet resultSet) {
        int numberOfColumns;
        ResultSetMetaData metaData;
        block5: {
            if (resultSet == null) {
                return null;
            }
            metaData = resultSet.getMetaData();
            numberOfColumns = metaData.getColumnCount();
            if (numberOfColumns > 0) break block5;
            return null;
        }
        try {
            String[] columns = new String[numberOfColumns];
            int column = 0;
            while (column < numberOfColumns) {
                columns[column] = metaData.getColumnName(column + 1);
                ++column;
            }
            return columns;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getRowCount(ResultSet resultset) {
        int row = 0;
        try {
            int currentRow = resultset.getRow();
            resultset.last();
            row = resultset.getRow();
            if (currentRow > 0) {
                resultset.absolute(row);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return row;
    }

    public static int getColumnCount(ResultSet resultSet) {
        if (resultSet == null) {
            return 0;
        }
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int numberOfColumns = metaData.getColumnCount();
            return numberOfColumns;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public static final Hashtable readResultToHashtable(ResultSet resultSet) {
        if (resultSet == null) {
            return null;
        }
        Hashtable<String, String> resultHash = new Hashtable<String, String>();
        try {
            String[] columns = DatabaseUtil.getColumns(resultSet);
            if (columns != null) {
                int i = 0;
                while (i < columns.length) {
                    resultHash.put(columns[i], DatabaseUtil.getString(resultSet, columns[i]));
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultHash;
    }

    public static final Hashtable readResultToHashtableISO(ResultSet resultSet) {
        Hashtable<String, String> resultHash;
        block6: {
            if (resultSet == null) {
                return null;
            }
            resultHash = new Hashtable<String, String>();
            try {
                String[] columns = DatabaseUtil.getColumns(resultSet);
                if (columns == null) break block6;
                int i = 0;
                while (i < columns.length) {
                    String isoString = DatabaseUtil.getString(resultSet, columns[i]);
                    try {
                        resultHash.put(columns[i], new String(isoString.getBytes("ISO8859-1"), "GBK"));
                    }
                    catch (Exception ex) {
                        resultHash.put(columns[i], isoString);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return resultHash;
    }

    public static void main(String[] args) throws Exception {
        DatabaseUtil util = new DatabaseUtil();
        ResultSet rs = util.executeQuery("SELECT * FROM e_hyx_trans_info");
        while (rs.next()) {
            Hashtable hash = DatabaseUtil.readResultToHashtableISO(rs);
            Enumeration keys = hash.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                System.out.println(key + "=" + hash.get(key));
            }
        }
        rs.close();
        util.close();
    }
}

