/*
 * Decompiled with CFR 0.152.
 */
package beansoft.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class StringCellEditor
implements TableCellEditor,
ActionListener {
    JButton button = new JButton("...");
    JTextField textField = new JTextField();
    JTextArea textArea = new JTextArea(10, 80);
    JPanel editPanel = new JPanel();
    Component parent;
    Object eventSource;
    Object value;
    Object oldValue;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    static /* synthetic */ Class class$0;

    public StringCellEditor() {
        this.button.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.button.addActionListener(this);
        this.button.setToolTipText("Editing string with a multiple line editor");
        this.textField.addActionListener(this);
        this.textField.setBorder(null);
        this.editPanel.setLayout(new BorderLayout());
        this.editPanel.add((Component)this.textField, "Center");
        this.editPanel.add((Component)this.button, "East");
    }

    public void actionPerformed(ActionEvent e) {
        this.eventSource = e.getSource();
        if (this.eventSource == this.textField) {
            this.stopCellEditing();
            return;
        }
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        if (JOptionPane.showConfirmDialog(this.button, scrollPane, "Edit String", 2) != 0) {
            this.cancelCellEditing();
            return;
        }
        this.stopCellEditing();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.parent = table;
        this.value = value;
        this.textField.setText("" + value);
        this.textArea.setText("" + value);
        this.eventSource = null;
        this.textField.setFont(table.getFont());
        this.oldValue = value;
        return this.editPanel;
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.value = this.textField.getText();
        if (this.eventSource == this.button) {
            this.value = this.textArea.getText();
        }
        if (this.value.equals(this.oldValue)) {
            this.fireEditingCanceled();
            return true;
        }
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.CellEditorListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.CellEditorListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.CellEditorListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
            i -= 2;
        }
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.CellEditorListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
            i -= 2;
        }
    }

    public static void main(String[] args) {
        JTable t = new JTable();
        t.setModel(new AbstractTableModel(){

            public int getColumnCount() {
                return 1;
            }

            public int getRowCount() {
                return 2;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                return "a";
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        });
        t.getColumnModel().getColumn(0).setCellEditor(new StringCellEditor());
        JFrame f = new JFrame();
        f.getContentPane().add(new JScrollPane(t));
        f.pack();
        f.show();
    }
}

