/*
 * Decompiled with CFR 0.152.
 */
package brushed.jspwiki.tableplugin;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Table
implements WikiPlugin {
    private static Logger log = Logger.getLogger((Class)Table.class);
    private WikiContext m_context;
    private WikiEngine m_engine;
    private StringBuffer m_result = new StringBuffer();
    private String m_style;
    private String m_style_header;
    private String m_style_data;
    private String m_styleRowEven;
    private String m_styleRowOdd;
    private int m_startRow;
    public static final String PARAM_BODY = "_body";
    public static final String PARAM_STYLE = "style";
    public static final String PARAM_STYLE_HEADER = "headerStyle";
    public static final String PARAM_STYLE_DATA = "dataStyle";
    public static final String PARAM_STYLE_ROW_ODD = "evenRowStyle";
    public static final String PARAM_STYLE_ROW_EVEN = "oddRowStyle";
    public static final String PARAM_ROW_NUMBER = "rowNumber";

    public String execute(WikiContext context, Map params) throws PluginException {
        this.m_context = context;
        this.m_engine = context.getEngine();
        WikiPage page = context.getPage();
        if (page == null) {
            return "";
        }
        String body = (String)params.get(PARAM_BODY);
        if (body == null) {
            return "";
        }
        this.m_style = (String)params.get(PARAM_STYLE);
        this.m_style_header = (String)params.get(PARAM_STYLE_HEADER);
        this.m_style_data = (String)params.get(PARAM_STYLE_DATA);
        this.m_styleRowEven = (String)params.get(PARAM_STYLE_ROW_EVEN);
        this.m_styleRowOdd = (String)params.get(PARAM_STYLE_ROW_ODD);
        this.m_startRow = TextUtil.parseIntParameter((String)((String)params.get(PARAM_ROW_NUMBER)), (int)0);
        log.info((Object)"Running TABLE plugin\n");
        this.m_result = new StringBuffer("");
        this.processTable(body);
        return this.m_result.toString();
    }

    protected void processTable(String aBody) {
        int i;
        StringBuffer sb = new StringBuffer(aBody);
        int bLen = sb.length();
        boolean opaqueCode = false;
        boolean opaquePre = false;
        boolean opaqueLink = false;
        boolean opaqueCSS = false;
        int opaquePlugin = 0;
        boolean S_IDLE = false;
        boolean S_IDLE_BLANK = true;
        int S_ONE_CELL = 2;
        int S_STANDARD_ROW = 3;
        int S_MULTILINE_ROW = 4;
        int S_MULTILINE_ROW_DELIM = 5;
        int state = 0;
        TableCell cell = null;
        ArrayList<TableCell> row = new ArrayList<TableCell>();
        ArrayList<ArrayList<TableCell>> table = new ArrayList<ArrayList<TableCell>>();
        for (i = 0; i < bLen; ++i) {
            char bi = sb.charAt(i);
            if (cell == null) {
                if (bi == '\n') {
                    state = 0;
                    continue;
                }
                if (Character.isWhitespace(bi)) {
                    state = 1;
                    continue;
                }
                if (bi == '|' && state == 0) {
                    cell = new TableCell();
                    i = cell.registerStart(sb, i);
                    row.add(cell);
                    state = 2;
                    continue;
                }
                log.info((Object)("ERR: CHAR outside table \"" + bi + "\""));
                break;
            }
            if (this.startsWith("[{", sb, i)) {
                ++opaquePlugin;
                ++i;
                continue;
            }
            if (this.startsWith("}]", sb, i)) {
                --opaquePlugin;
                ++i;
                continue;
            }
            if (opaquePlugin > 0) continue;
            if (opaqueCode) {
                if (!this.startsWith("}}}", sb, i)) continue;
                opaqueCode = false;
                i += 2;
                continue;
            }
            if (this.startsWith("{{{", sb, i)) {
                opaqueCode = true;
                i += 2;
                continue;
            }
            if (opaquePre) {
                if (!this.startsWith("}}", sb, i)) continue;
                opaquePre = false;
                ++i;
                continue;
            }
            if (this.startsWith("{{", sb, i)) {
                opaquePre = true;
                ++i;
                continue;
            }
            if (opaqueCSS) {
                if (!this.startsWith("%%", sb, i)) continue;
                opaqueCSS = false;
                ++i;
                continue;
            }
            if (this.startsWith("%%", sb, i)) {
                opaqueCSS = true;
                ++i;
                continue;
            }
            if (opaqueLink) {
                if (bi != ']') continue;
                opaqueLink = false;
                continue;
            }
            if (bi == '[') {
                opaqueLink = true;
                continue;
            }
            if (cell.cssStyle) {
                cell.handleCss(sb, i);
                continue;
            }
            if (this.startsWith("~#", sb, i)) {
                ++i;
                continue;
            }
            if (bi == '#') {
                sb.deleteCharAt(i);
                sb.insert(i, table.size() + this.m_startRow);
                bLen = sb.length();
                continue;
            }
            if (this.startsWith("~|", sb, i)) {
                ++i;
                continue;
            }
            if (this.startsWith("\n|", sb, i) && (state == 2 || state == 4)) {
                cell.registerEnd(sb, i - 1);
                cell = new TableCell();
                i = cell.registerStart(sb, i + 1);
                row.add(cell);
                state = 4;
                continue;
            }
            if (bi == '|' && (state == 2 || state == 3)) {
                cell.registerEnd(sb, i);
                cell = new TableCell();
                i = cell.registerStart(sb, i);
                row.add(cell);
                state = 3;
                continue;
            }
            if (bi == '\n' && (state == 2 || state == 4)) {
                state = 5;
                continue;
            }
            if (bi == '\n' && (state == 3 || state == 5)) {
                cell.registerEnd(sb, i);
                table.add(row);
                row = new ArrayList();
                cell = null;
                state = 0;
                continue;
            }
            if (state != 5 || Character.isWhitespace(bi)) continue;
            state = 4;
        }
        if (cell != null) {
            cell.registerEnd(sb, i);
            table.add(row);
        }
        this.processTableFlush(table, sb);
    }

    protected void processTableFlush(List aTable, StringBuffer aBody) {
        if (aTable.isEmpty()) {
            return;
        }
        this.m_result.append("<table border='1' class='wikitable'");
        if (this.m_style != null) {
            this.m_result.append(" style=\"" + this.m_style + "\" ");
        }
        this.m_result.append("> \n");
        for (int r = 0; r < aTable.size(); ++r) {
            List row = (List)aTable.get(r);
            this.m_result.append("<tr>\n");
            for (int c = 0; c < row.size(); ++c) {
                int rowspan;
                int colspan;
                TableCell cell = (TableCell)row.get(c);
                if (cell.colspan || cell.rowspan) continue;
                if (cell.isHeader) {
                    this.m_result.append("<th");
                    if (this.m_style_header != null) {
                        this.m_result.append(" style=\"" + this.m_style_header + "\"");
                    }
                } else {
                    this.m_result.append("<td");
                    String style = "";
                    if (this.m_style_data != null) {
                        style = style + this.m_style_data + " ";
                    }
                    if (cell.cssStart != -1) {
                        style = style + aBody.substring(cell.cssStart, cell.cssEnd);
                    }
                    if (this.m_styleRowEven != null && r % 2 == 0) {
                        style = style + this.m_styleRowEven + " ";
                    }
                    if (this.m_styleRowOdd != null && r % 2 != 0) {
                        style = style + this.m_styleRowOdd;
                    }
                    if (style != "") {
                        this.m_result.append(" style=\"" + style + "\"");
                    }
                }
                if ((colspan = this.getColSpan(aTable, r, c)) > 1) {
                    this.m_result.append(" colspan='" + colspan + "'");
                }
                if ((rowspan = this.getRowSpan(aTable, r, c)) > 1) {
                    this.m_result.append(" rowspan='" + rowspan + "'");
                }
                this.m_result.append(">");
                this.m_result.append(this.m_engine.textToHTML(this.m_context, aBody.substring(cell.start, cell.end)));
                if (cell.isHeader) {
                    this.m_result.append("</th>\n");
                    continue;
                }
                this.m_result.append("</td>\n");
            }
            this.m_result.append("</tr>\n");
            row.clear();
        }
        aTable.clear();
        this.m_result.append("</table>\n");
    }

    protected int getColSpan(List aTable, int rowIndex, int columnIndex) {
        int colspan = 1;
        List row = (List)aTable.get(rowIndex);
        while (++columnIndex < row.size()) {
            TableCell nextCell = (TableCell)row.get(columnIndex);
            if (!nextCell.colspan) break;
            ++colspan;
        }
        return colspan;
    }

    protected int getRowSpan(List aTable, int rowIndex, int columnIndex) {
        int rowspan = 1;
        while (++rowIndex < aTable.size()) {
            List nextRow = (List)aTable.get(rowIndex);
            if (columnIndex >= nextRow.size()) continue;
            TableCell nextRowCell = (TableCell)nextRow.get(columnIndex);
            if (!nextRowCell.rowspan) break;
            ++rowspan;
        }
        return rowspan;
    }

    protected boolean startsWith(String s, StringBuffer sb, int startIndex) {
        if (s.length() > sb.length() - startIndex) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == sb.charAt(i + startIndex)) continue;
            return false;
        }
        return true;
    }

    private class TableCell {
        public int start;
        public int end;
        public boolean isHeader;
        public boolean colspan;
        public boolean rowspan;
        public boolean cssStyle;
        public int cssBracket;
        public int cssStart;
        public int cssEnd;

        private TableCell() {
        }

        public int registerStart(StringBuffer sb, int aCursor) {
            char c;
            this.end = -1;
            this.cssStart = -1;
            this.cssEnd = -1;
            this.cssStyle = false;
            this.cssBracket = 0;
            this.colspan = false;
            this.rowspan = false;
            this.isHeader = false;
            if (aCursor + 1 < sb.length() && (c = sb.charAt(aCursor + 1)) == '|') {
                this.isHeader = true;
                ++aCursor;
            }
            if (aCursor + 1 < sb.length()) {
                c = sb.charAt(aCursor + 1);
                if (c == '<') {
                    this.colspan = true;
                    ++aCursor;
                } else if (c == '^') {
                    this.rowspan = true;
                    ++aCursor;
                } else if (c == '(') {
                    this.cssStyle = true;
                    this.cssBracket = 1;
                    ++aCursor;
                }
            }
            this.start = aCursor + 1;
            return aCursor;
        }

        public void handleCss(StringBuffer sb, int aCursor) {
            char c = sb.charAt(aCursor);
            if (c == '(') {
                ++this.cssBracket;
            } else if (c == ')') {
                --this.cssBracket;
            }
            if (this.cssBracket == 0) {
                this.cssStyle = false;
                this.cssStart = this.start;
                this.cssEnd = aCursor;
                this.start = this.cssEnd + 1;
            }
        }

        public TableCell registerEnd(StringBuffer sb, int aCursor) {
            this.end = aCursor;
            log.debug((Object)("Cell $$" + sb.substring(this.start, this.end) + "$$"));
            return this;
        }
    }
}

