/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.NoSuchVariableException;
import com.ecyrd.jspwiki.Release;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.filters.PageFilter;
import com.ecyrd.jspwiki.modules.InternalModule;
import com.ecyrd.jspwiki.providers.WikiAttachmentProvider;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class VariableManager {
    private static Logger log = Logger.getLogger(VariableManager.class);
    public static final String VAR_ERROR = "error";
    public static final String VAR_MSG = "msg";
    static final String[] THE_BIG_NO_NO_LIST = new String[]{"jspwiki.auth.masterpassword"};

    public VariableManager(Properties props) {
    }

    public static boolean isVariableLink(String link) {
        return link.startsWith("{$");
    }

    public String parseAndGetValue(WikiContext context, String link) throws IllegalArgumentException, NoSuchVariableException {
        if (!link.startsWith("{$")) {
            throw new IllegalArgumentException("Link does not start with {$");
        }
        if (!link.endsWith("}")) {
            throw new IllegalArgumentException("Link does not end with }");
        }
        String varName = link.substring(2, link.length() - 1);
        return this.getValue(context, varName.trim());
    }

    public String expandVariables(WikiContext context, String source) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) == '{') {
                if (i < source.length() - 2 && source.charAt(i + 1) == '$') {
                    String value;
                    int end = source.indexOf(125, i);
                    if (end == -1) continue;
                    String varname = source.substring(i + 2, end);
                    try {
                        value = this.getValue(context, varname);
                    }
                    catch (NoSuchVariableException e) {
                        value = e.getMessage();
                    }
                    catch (IllegalArgumentException e) {
                        value = e.getMessage();
                    }
                    result.append(value);
                    i = end;
                    continue;
                }
                result.append('{');
                continue;
            }
            result.append(source.charAt(i));
        }
        return result.toString();
    }

    public String getValue(WikiContext context, String varName, String defValue) {
        try {
            return this.getValue(context, varName);
        }
        catch (NoSuchVariableException e) {
            return defValue;
        }
    }

    public String getValue(WikiContext context, String varName) throws IllegalArgumentException, NoSuchVariableException {
        if (varName == null) {
            throw new IllegalArgumentException("Null variable name.");
        }
        if (varName.length() == 0) {
            throw new IllegalArgumentException("Zero length variable name.");
        }
        String name = varName.toLowerCase();
        for (int i = 0; i < THE_BIG_NO_NO_LIST.length; ++i) {
            if (!name.equals(THE_BIG_NO_NO_LIST[i])) continue;
            return "";
        }
        try {
            SystemVariables sysvars = new SystemVariables(context);
            String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            Method method = sysvars.getClass().getMethod(methodName, new Class[0]);
            return (String)method.invoke((Object)sysvars, new Object[0]);
        }
        catch (NoSuchMethodException e1) {
            Properties props;
            String s;
            Object metadata;
            Object metadata2;
            WikiPage pg;
            if (context.getVariable(varName) != null) {
                return context.getVariable(varName).toString();
            }
            HttpServletRequest req = context.getHttpRequest();
            if (req != null && req.getSession() != null) {
                HttpSession session = req.getSession();
                try {
                    String s2 = (String)session.getAttribute(varName);
                    if (s2 != null) {
                        return s2;
                    }
                    s2 = context.getHttpParameter(varName);
                    if (s2 != null) {
                        return s2;
                    }
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            if ((pg = context.getPage()) != null && (metadata2 = pg.getAttribute(varName)) != null) {
                return metadata2.toString();
            }
            WikiPage rpg = context.getRealPage();
            if (rpg != null && (metadata = rpg.getAttribute(varName)) != null) {
                return metadata.toString();
            }
            if (varName.startsWith("jspwiki.") && (s = (props = context.getEngine().getWikiProperties()).getProperty(varName)) != null) {
                return s;
            }
            if (varName.equals(VAR_ERROR) || varName.equals(VAR_MSG)) {
                return "";
            }
            throw new NoSuchVariableException("No variable " + varName + " defined.");
        }
        catch (Exception e) {
            log.info((Object)"Interesting exception: cannot fetch variable value", (Throwable)e);
            return "";
        }
    }

    private static class SystemVariables {
        private WikiContext m_context;

        public SystemVariables(WikiContext context) {
            this.m_context = context;
        }

        public String getPagename() {
            return this.m_context.getPage().getName();
        }

        public String getApplicationname() {
            return this.m_context.getEngine().getApplicationName();
        }

        public String getJspwikiversion() {
            return Release.getVersionString();
        }

        public String getEncoding() {
            return this.m_context.getEngine().getContentEncoding();
        }

        public String getTotalpages() {
            return Integer.toString(this.m_context.getEngine().getPageCount());
        }

        public String getPageprovider() {
            return this.m_context.getEngine().getCurrentProvider();
        }

        public String getPageproviderdescription() {
            return this.m_context.getEngine().getCurrentProviderInfo();
        }

        public String getAttachmentprovider() {
            WikiAttachmentProvider p = this.m_context.getEngine().getAttachmentManager().getCurrentProvider();
            return p != null ? p.getClass().getName() : "-";
        }

        public String getAttachmentproviderdescription() {
            WikiAttachmentProvider p = this.m_context.getEngine().getAttachmentManager().getCurrentProvider();
            return p != null ? p.getProviderInfo() : "-";
        }

        public String getInterwikilinks() {
            StringBuffer res = new StringBuffer();
            Iterator i = this.m_context.getEngine().getAllInterWikiLinks().iterator();
            while (i.hasNext()) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                String link = (String)i.next();
                res.append(link);
                res.append(" --> ");
                res.append(this.m_context.getEngine().getInterWikiURL(link));
            }
            return res.toString();
        }

        public String getInlinedimages() {
            StringBuffer res = new StringBuffer();
            Iterator i = this.m_context.getEngine().getAllInlinedImagePatterns().iterator();
            while (i.hasNext()) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                String ptrn = (String)i.next();
                res.append(ptrn);
            }
            return res.toString();
        }

        public String getPluginpath() {
            String s = this.m_context.getEngine().getPluginSearchPath();
            return s == null ? "-" : s;
        }

        public String getBaseurl() {
            return this.m_context.getEngine().getBaseURL();
        }

        public String getUptime() {
            Date now = new Date();
            long secondsRunning = (now.getTime() - this.m_context.getEngine().getStartTime().getTime()) / 1000L;
            long seconds = secondsRunning % 60L;
            long minutes = (secondsRunning /= 60L) % 60L;
            long hours = (secondsRunning /= 60L) % 24L;
            long days = secondsRunning /= 24L;
            return days + "d, " + hours + "h " + minutes + "m " + seconds + "s";
        }

        public String getLoginstatus() {
            WikiSession session = this.m_context.getWikiSession();
            return this.m_context.getBundle("CoreResources").getString("varmgr." + session.getStatus());
        }

        public String getUsername() {
            Principal wup = this.m_context.getCurrentUser();
            ResourceBundle rb = this.m_context.getBundle("CoreResources");
            return wup != null ? wup.getName() : rb.getString("varmgr.not.logged.in");
        }

        public String getRequestcontext() {
            return this.m_context.getRequestContext();
        }

        public String getPagefilters() {
            List filters = this.m_context.getEngine().getFilterManager().getFilterList();
            StringBuffer sb = new StringBuffer();
            for (PageFilter pf : filters) {
                String f = pf.getClass().getName();
                if (pf instanceof InternalModule) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(f);
            }
            return sb.toString();
        }
    }
}

