/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.WikiSession;
import com.ecyrd.jspwiki.auth.AuthenticationManager;
import com.ecyrd.jspwiki.auth.Authorizer;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.WikiSecurityException;
import com.ecyrd.jspwiki.auth.acl.Acl;
import com.ecyrd.jspwiki.auth.acl.AclEntry;
import com.ecyrd.jspwiki.auth.acl.UnresolvedPrincipal;
import com.ecyrd.jspwiki.auth.authorize.Role;
import com.ecyrd.jspwiki.auth.permissions.AllPermission;
import com.ecyrd.jspwiki.auth.permissions.PagePermission;
import com.ecyrd.jspwiki.auth.user.UserDatabase;
import com.ecyrd.jspwiki.auth.user.UserProfile;
import com.ecyrd.jspwiki.event.WikiEventListener;
import com.ecyrd.jspwiki.event.WikiEventManager;
import com.ecyrd.jspwiki.event.WikiSecurityEvent;
import com.ecyrd.jspwiki.util.ClassUtil;
import java.io.File;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.freshcookies.security.policy.LocalPolicy;
import org.freshcookies.security.policy.PolicyException;

public final class AuthorizationManager {
    private static final Logger log = Logger.getLogger(AuthorizationManager.class);
    public static final String DEFAULT_AUTHORIZER = "com.ecyrd.jspwiki.auth.authorize.WebContainerAuthorizer";
    protected static final String POLICY = "jspwiki.policy.file";
    protected static final String DEFAULT_POLICY = "jspwiki.policy";
    public static final String PROP_AUTHORIZER = "jspwiki.authorizer";
    private Authorizer m_authorizer = null;
    private Map<Principal, ProtectionDomain> m_cachedPds = new WeakHashMap<Principal, ProtectionDomain>();
    private WikiEngine m_engine = null;
    private LocalPolicy m_localPolicy = null;
    private boolean m_useJAAS = true;

    public final boolean checkPermission(WikiSession session, Permission permission) {
        Acl acl;
        if (!this.m_useJAAS) {
            return permission != null && !"login".equals(permission.getActions());
        }
        if (session == null || permission == null) {
            this.fireEvent(52, null, permission);
            return false;
        }
        Principal user = session.getLoginPrincipal();
        AllPermission allPermission = new AllPermission(this.m_engine.getApplicationName());
        boolean hasAllPermission = this.checkStaticPermission(session, allPermission);
        if (hasAllPermission) {
            this.fireEvent(51, user, permission);
            return true;
        }
        boolean hasPolicyPermission = this.checkStaticPermission(session, permission);
        if (!hasPolicyPermission) {
            this.fireEvent(52, user, permission);
            return false;
        }
        if (!(permission instanceof PagePermission)) {
            this.fireEvent(51, user, permission);
            return true;
        }
        String pageName = ((PagePermission)permission).getPage();
        WikiPage page = this.m_engine.getPage(pageName);
        Acl acl2 = acl = page == null ? null : this.m_engine.getAclManager().getPermissions(page);
        if (page == null || acl == null || acl.isEmpty()) {
            this.fireEvent(51, user, permission);
            return true;
        }
        Principal[] aclPrincipals = acl.findPrincipals(permission);
        log.debug((Object)"Checking ACL entries...");
        log.debug((Object)("Acl for this page is: " + acl));
        log.debug((Object)("Checking for principal: " + String.valueOf(aclPrincipals)));
        log.debug((Object)("Permission: " + permission));
        for (Principal aclPrincipal : aclPrincipals) {
            if (aclPrincipal instanceof UnresolvedPrincipal) {
                AclEntry aclEntry = acl.getEntry(aclPrincipal);
                aclPrincipal = this.resolvePrincipal(aclPrincipal.getName());
                if (aclEntry != null && !(aclPrincipal instanceof UnresolvedPrincipal)) {
                    aclEntry.setPrincipal(aclPrincipal);
                }
            }
            if (!this.hasRoleOrPrincipal(session, aclPrincipal)) continue;
            this.fireEvent(51, user, permission);
            return true;
        }
        this.fireEvent(52, user, permission);
        return false;
    }

    public final boolean isUserInRole(WikiSession session, Principal principal) {
        if (session == null || principal == null || AuthenticationManager.isUserPrincipal(principal)) {
            return false;
        }
        if (principal instanceof Role && Role.isBuiltInRole((Role)principal)) {
            return session.hasPrincipal(principal);
        }
        if (session.isAuthenticated() && AuthenticationManager.isRolePrincipal(principal)) {
            return session.hasPrincipal(principal);
        }
        return false;
    }

    public final Authorizer getAuthorizer() throws WikiSecurityException {
        if (this.m_authorizer != null) {
            return this.m_authorizer;
        }
        throw new WikiSecurityException("Authorizer did not initialize properly. Check the logs.");
    }

    protected boolean hasRoleOrPrincipal(WikiSession session, Principal principal) {
        if (session == null || principal == null) {
            return false;
        }
        if (AuthenticationManager.isRolePrincipal(principal)) {
            return this.isUserInRole(session, principal);
        }
        if (session.isAuthenticated() && AuthenticationManager.isUserPrincipal(principal)) {
            Principal[] userPrincipals;
            String principalName = principal.getName();
            for (Principal userPrincipal : userPrincipals = session.getPrincipals()) {
                if (!userPrincipal.getName().equals(principalName)) continue;
                return true;
            }
        }
        return false;
    }

    public final void initialize(WikiEngine engine, Properties properties) throws WikiException {
        this.m_engine = engine;
        this.m_useJAAS = "jaas".equals(properties.getProperty("jspwiki.security", "jaas"));
        if (!this.m_useJAAS) {
            return;
        }
        this.m_authorizer = this.getAuthorizerImplementation(properties);
        this.m_authorizer.initialize(engine, properties);
        try {
            String policyFileName = properties.getProperty(POLICY, DEFAULT_POLICY);
            URL policyURL = AuthenticationManager.findConfigFile(engine, policyFileName);
            if (policyURL == null) {
                StringBuffer sb = new StringBuffer("JSPWiki was unable to initialize the ");
                sb.append("default security policy (WEB-INF/jspwiki.policy) file. ");
                sb.append("Please ensure that the jspwiki.policy file exists in the default location. ");
                sb.append("This file should exist regardless of the existance of a global policy file. ");
                sb.append("The global policy file is identified by the java.security.policy variable. ");
                WikiSecurityException wse = new WikiSecurityException(sb.toString());
                log.fatal((Object)sb.toString(), (Throwable)wse);
                throw wse;
            }
            File policyFile = new File(policyURL.getPath());
            this.m_localPolicy = new LocalPolicy(policyFile, engine.getContentEncoding());
            this.m_localPolicy.refresh();
            log.info((Object)("Initialized default security policy: " + policyFile.getAbsolutePath()));
        }
        catch (PolicyException e) {
            log.error((Object)("Could not initialize local security policy: " + e.getMessage()));
            throw new WikiException(e.getMessage());
        }
    }

    protected boolean isJAASAuthorized() {
        return this.m_useJAAS;
    }

    private final Authorizer getAuthorizerImplementation(Properties props) throws WikiException {
        String authClassName = props.getProperty(PROP_AUTHORIZER, DEFAULT_AUTHORIZER);
        return (Authorizer)this.locateImplementation(authClassName);
    }

    private final Object locateImplementation(String clazz) throws WikiException {
        if (clazz != null) {
            try {
                Class authClass = ClassUtil.findClass("com.ecyrd.jspwiki.auth.authorize", clazz);
                Object impl = authClass.newInstance();
                return impl;
            }
            catch (ClassNotFoundException e) {
                log.fatal((Object)("Authorizer " + clazz + " cannot be found"), (Throwable)e);
                throw new WikiException("Authorizer " + clazz + " cannot be found");
            }
            catch (InstantiationException e) {
                log.fatal((Object)("Authorizer " + clazz + " cannot be created"), (Throwable)e);
                throw new WikiException("Authorizer " + clazz + " cannot be created");
            }
            catch (IllegalAccessException e) {
                log.fatal((Object)"You are not allowed to access this authorizer class", (Throwable)e);
                throw new WikiException("You are not allowed to access this authorizer class");
            }
        }
        throw new NoRequiredPropertyException("Unable to find a jspwiki.authorizer entry in the properties.", PROP_AUTHORIZER);
    }

    protected boolean allowedByLocalPolicy(Principal[] principals, Permission permission) {
        for (Principal principal : principals) {
            ProtectionDomain pd = this.m_cachedPds.get(principal);
            if (pd == null) {
                ClassLoader cl = this.getClass().getClassLoader();
                CodeSource cs = new CodeSource(null, (Certificate[])null);
                pd = new ProtectionDomain(cs, null, cl, new Principal[]{principal});
                this.m_cachedPds.put(principal, pd);
            }
            if (!this.m_localPolicy.implies(pd, permission)) continue;
            return true;
        }
        return false;
    }

    protected final boolean checkStaticPermission(final WikiSession session, final Permission permission) {
        if (!this.m_useJAAS) {
            return true;
        }
        Boolean allowed = (Boolean)WikiSession.doPrivileged(session, new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    AccessController.checkPermission(permission);
                    return Boolean.TRUE;
                }
                catch (AccessControlException accessControlException) {
                    if (AuthorizationManager.this.allowedByLocalPolicy(session.getRoles(), permission) || AuthorizationManager.this.allowedByLocalPolicy(session.getPrincipals(), permission)) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            }
        });
        return allowed;
    }

    public final Principal resolvePrincipal(String name) {
        if (!this.m_useJAAS) {
            return new UnresolvedPrincipal(name);
        }
        Role role = new Role(name);
        if (Role.isBuiltInRole(role)) {
            return role;
        }
        Principal principal = this.m_authorizer.findRole(name);
        if (principal != null) {
            return principal;
        }
        principal = this.m_engine.getGroupManager().findRole(name);
        if (principal != null) {
            return principal;
        }
        Principal[] principals = null;
        UserProfile profile = null;
        UserDatabase db = this.m_engine.getUserManager().getUserDatabase();
        try {
            profile = db.find(name);
            principals = db.getPrincipals(profile.getLoginName());
            for (int i = 0; i < principals.length; ++i) {
                principal = principals[i];
                if (!principal.getName().equals(name)) continue;
                return principal;
            }
        }
        catch (NoSuchPrincipalException e) {
            // empty catch block
        }
        return new UnresolvedPrincipal(name);
    }

    public final synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener(this, listener);
    }

    public final synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener(this, listener);
    }

    protected final void fireEvent(int type, Principal user, Object permission) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiSecurityEvent(this, type, user, permission));
        }
    }
}

