/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.tags;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.tags.WikiTagBase;
import java.io.IOException;

public class PageSizeTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;

    public final int doWikiStartTag() throws IOException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        WikiPage page = this.m_wikiContext.getPage();
        try {
            if (page != null) {
                long size = page.getSize();
                if (size == -1L && engine.pageExists(page)) {
                    size = engine.getPureText(page.getName(), page.getVersion()).length();
                    page.setSize(size);
                }
                this.pageContext.getOut().write(Long.toString(size));
            }
        }
        catch (ProviderException e) {
            log.warn((Object)"Providers did not work: ", (Throwable)e);
            this.pageContext.getOut().write("Error determining page size: " + e.getMessage());
        }
        return 0;
    }
}

