/*
 * Decompiled with CFR 0.152.
 */
package org.makumba;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.commons.LongData;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.db.makumba.sql.Database;

public class Text {
    InputStream source;
    int len;
    LongData ld;
    public static int FILE_LIMIT;

    public Text(InputStream is, int length) {
        this.source = is;
        this.len = length;
    }

    public Text(InputStream is) {
        try {
            this.ld = new LongData();
            this.ld.appendFrom(is);
            this.source = this.ld.getInputStream();
            this.len = this.ld.getLength();
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public Text(String s) {
        this(s.getBytes());
    }

    public Text(byte[] b) {
        this(b, 0, b.length);
    }

    public Text(byte[] b, int start, int length) {
        this.len = length;
        try {
            this.ld = new LongData();
            this.ld.appendFrom(new ByteArrayInputStream(b, start, length));
            this.source = this.ld.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public InputStream toBinaryStream() {
        if (this.source == null) {
            throw new MakumbaError("texts indicated by stream can only be consumed once");
        }
        if (this.ld != null) {
            try {
                return this.ld.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        InputStream s = this.source;
        this.source = null;
        return s;
    }

    public int length() {
        return this.len;
    }

    public static Text getText(Object value) {
        if (value instanceof Text) {
            return (Text)value;
        }
        if (value instanceof InputStream) {
            return new Text((InputStream)value);
        }
        if (value instanceof String) {
            return new Text((String)value);
        }
        if (value instanceof byte[]) {
            return new Text((byte[])value);
        }
        throw new InvalidValueException("unsupported type to make text of " + value.getClass());
    }

    public String toString() {
        ByteArrayOutputStream bo = new ByteArrayOutputStream(this.len < FILE_LIMIT ? this.len : FILE_LIMIT);
        try {
            this.writeTo(bo);
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
        try {
            if (Database.supportsUTF8()) {
                return new String(bo.toByteArray(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new String(bo.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toShortString(int length) {
        String string;
        if (length > this.len) {
            length = this.len;
        }
        if (length > FILE_LIMIT) {
            length = FILE_LIMIT;
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream(length + 20);
        InputStream is = this.toBinaryStream();
        byte[] b = new byte[length];
        try {
            int n = is.read(b, 0, b.length);
            if (n != -1) {
                bo.write(b, 0, n);
            }
            bo.write("... (length: ".getBytes());
            bo.write(new Integer(this.len).toString().getBytes());
            bo.write(")".getBytes());
            string = bo.toString();
        }
        catch (Throwable throwable) {
            try {
                bo.close();
                is.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeWrappedException(ioe);
            }
        }
        bo.close();
        is.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream o) throws IOException {
        byte[] b = new byte[this.len < FILE_LIMIT ? this.len : FILE_LIMIT];
        InputStream is = this.toBinaryStream();
        try {
            int n;
            while ((n = is.read(b, 0, b.length)) != -1) {
                o.write(b, 0, n);
            }
        }
        finally {
            o.close();
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compare(InputStream is) throws IOException {
        InputStream is1 = this.toBinaryStream();
        try {
            int n;
            int i = 0;
            while ((n = is.read()) != -1) {
                int m = is1.read();
                if (n != m) {
                    Logger.getLogger("org.makumba.debug.abstr").severe(m + " " + n + " " + i);
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            boolean bl = is1.read() == -1;
            return bl;
        }
        finally {
            is.close();
            is1.close();
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (this.length() != ((Text)other).length()) {
            return false;
        }
        try {
            return this.compare(((Text)other).toBinaryStream());
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getString() {
        return this.toString();
    }

    static {
        String s = null;
        try {
            s = System.getProperty("makumba.long-content");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        FILE_LIMIT = s != null ? Integer.parseInt(s.trim()) : 32768;
    }
}

