/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.Pointer;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryProvider;
import org.makumba.providers.TransactionProvider;

public class AutoCompleteServlet
extends HttpServlet {
    public static final String resourceDirectory = "makumbaResources";
    private static final long serialVersionUID = 1L;
    public static final String RESOURCE_PATH_JAVASCRIPT = "javaScript/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        PrintWriter writer = resp.getWriter();
        String value = req.getParameter("value");
        String typeName = req.getParameter("type");
        String fieldName = req.getParameter("field");
        String fieldType = req.getParameter("fieldType");
        String queryLang = req.getParameter("queryLang");
        if (StringUtils.isBlank((String)typeName) || StringUtils.isBlank((String)fieldName)) {
            writer.println("{error: \"All 'type' and 'field' parameters need to be not-empty!\"}");
            return;
        }
        QueryProvider qp = null;
        try {
            DataDefinition dd;
            qp = QueryProvider.makeQueryRunner(TransactionProvider.getInstance().getDefaultDataSourceName(), queryLang);
            try {
                dd = DataDefinitionProvider.getInstance().getDataDefinition(typeName);
                if (dd == null) {
                    writer.println("{error: \"No such table!\"}");
                    return;
                }
            }
            catch (Throwable e) {
                writer.println("{error: \"No such table!\"}");
                return;
            }
            FieldDefinition fd = dd.getFieldDefinition(fieldName);
            if (fd == null) {
                writer.println("{error: \"No such field!\"}");
                return;
            }
            if (fieldType.equals("char")) {
                String query = "select p." + fieldName + " as possibility from " + typeName + " p where p." + fieldName + " like '" + value + "%' group by p." + fieldName;
                Vector<Object> v = new Vector();
                v = qp.execute(query, null, 0, -1);
                if (v.size() > 0) {
                    String result = "<ul>";
                    for (Dictionary dictionary : v) {
                        String possibility = (String)dictionary.get("possibility");
                        result = result + "<li>" + possibility + "</li>";
                    }
                    result = result + "</ul>";
                    writer.print(result);
                } else {
                    writer.print("<ul></ul>");
                }
            } else if (fieldType.equals("ptr")) {
                HashMap<String, String> m = new HashMap<String, String>();
                String titleField = dd.getFieldDefinition(fieldName).getTitleField();
                String titleExpr = "choice." + titleField;
                String choiceType = dd.getFieldDefinition(fieldName).getPointedType().getName();
                m.put("oql", "SELECT choice as choice, " + titleExpr + " as title FROM " + choiceType + " choice " + "WHERE " + titleExpr + " like '%" + value + "%' " + "ORDER BY title");
                FieldDefinition fieldDefinition = dd.getFieldDefinition(fieldName).getPointedType().getFieldOrPointedFieldDefinition(titleField);
                if (fieldDefinition != null && fieldDefinition.getType().equals("ptr")) {
                    titleExpr = titleExpr + ".id";
                }
                m.put("hql", "SELECT choice.id as choice, " + titleExpr + " as title FROM " + choiceType + " choice " + "WHERE " + titleExpr + " like '%" + value + "%' " + "ORDER BY " + titleExpr);
                Vector<Object> v = new Vector();
                v = qp.execute((String)m.get(queryLang), null, 0, -1);
                if (v.size() > 0) {
                    String result = "<ul>";
                    for (Dictionary dictionary : v) {
                        result = result + "<li id=\"" + ((Pointer)dictionary.get("choice")).toExternalForm() + "\">" + (String)dictionary.get("title") + "</li>";
                    }
                    result = result + "</ul>";
                    writer.print(result);
                } else {
                    writer.print("<ul></ul>");
                }
            }
        }
        finally {
            if (qp != null) {
                qp.close();
            }
        }
        writer.flush();
        writer.close();
    }
}

