/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.makumba.MakumbaError;
import org.makumba.UnauthorizedException;
import org.makumba.commons.ControllerHandler;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.ServletObjects;
import org.makumba.devel.ErrorFormatter;

public class ErrorControllerHandler
extends ControllerHandler {
    public static final String ORIGINAL_REQUEST = "org.makumba.originalRequest";

    public boolean beforeFilter(ServletRequest request, ServletResponse response, FilterConfig conf, ServletObjects httpServletObjects) {
        return !this.wasException((HttpServletRequest)request);
    }

    public boolean onError(ServletRequest request, ServletResponse response, Throwable e, FilterConfig conf) {
        this.treatException(e, (HttpServletRequest)request, (HttpServletResponse)response, conf);
        return false;
    }

    public void treatException(Throwable t, HttpServletRequest req, HttpServletResponse resp, FilterConfig conf) {
        resp.setContentType("text/html");
        if (t instanceof RuntimeWrappedException) {
            t = ((RuntimeWrappedException)t).getCause();
        }
        req.setAttribute("javax.servlet.jsp.jspException", (Object)t);
        if (!(req.getAttribute("org.makumba.exceptionTreated") != null || t instanceof UnauthorizedException && ErrorControllerHandler.login(req, resp))) {
            try {
                String errorPage = ErrorControllerHandler.getPage(req, req.getServletPath(), "error.jsp");
                if (errorPage != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter wr = new PrintWriter(sw);
                    ErrorFormatter ef = new ErrorFormatter(req, req.getSession().getServletContext(), wr, false);
                    req.setAttribute("mak_error_title", (Object)ef.getTitle());
                    req.setAttribute("mak_error_description", (Object)sw.toString());
                    req.setAttribute("mak_error_realpath", (Object)new File(req.getSession().getServletContext().getRealPath("/")).getCanonicalPath());
                    req.getRequestDispatcher(errorPage).forward((ServletRequest)req, (ServletResponse)resp);
                } else {
                    resp.setContentType("text/html");
                    new ErrorFormatter(req, conf.getServletContext(), resp.getWriter(), true);
                    resp.getWriter().flush();
                }
            }
            catch (ServletException se) {
                se.printStackTrace();
                throw new MakumbaError(se);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new MakumbaError(ioe);
            }
            catch (IllegalStateException ise) {
                Logger.getLogger("org.makumba.controller").severe("Page execution breaks on page '" + req.getServletPath() + "' but the error page can't be displayed due to too small buffer size.\n" + "==> Try increasing the page buffer size by manually increasing the buffer to 16kb (or more) using <%@ page buffer=\"16kb\"%> in the .jsp page\n" + "The makumba error message would have been:\n" + new ErrorFormatter().getErrorMessage(req));
            }
        }
        this.setWasException(req);
        req.setAttribute("org.makumba.exceptionTreated", (Object)"yes");
    }

    public static String getLoginPage(HttpServletRequest req, String servletPath) {
        return ErrorControllerHandler.getPage(req, servletPath, "login.jsp");
    }

    public static String getPage(HttpServletRequest req, String servletPath, String pageName) {
        String root = req.getSession().getServletContext().getRealPath("/");
        String virtualRoot = "/";
        String page = null;
        StringTokenizer st = new StringTokenizer(servletPath, "/");
        while (st.hasMoreElements()) {
            if (new File(root + pageName).exists()) {
                page = virtualRoot + pageName;
            }
            String s = st.nextToken() + "/";
            root = root + s;
            virtualRoot = virtualRoot + s;
        }
        if (new File(root + pageName).exists()) {
            page = virtualRoot + pageName;
        }
        return page;
    }

    protected static boolean login(HttpServletRequest req, HttpServletResponse resp) {
        String login = ErrorControllerHandler.getLoginPage(req, req.getServletPath());
        if (login == null) {
            return false;
        }
        while (req instanceof HttpServletRequestWrapper) {
            req = (HttpServletRequest)((HttpServletRequestWrapper)req).getRequest();
        }
        req.setAttribute(ORIGINAL_REQUEST, (Object)req);
        try {
            req.getRequestDispatcher(login).forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (Throwable q) {
            q.printStackTrace();
            return false;
        }
        return true;
    }

    public void setWasException(HttpServletRequest req) {
        req.setAttribute("org.makumba.wasException", (Object)"yes");
    }

    public boolean wasException(HttpServletRequest req) {
        return "yes".equals(req.getAttribute("org.makumba.wasException"));
    }
}

