/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import antlr.CommonAST;
import antlr.collections.AST;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.makumba.DataDefinition;
import org.makumba.ValidationRule;
import org.makumba.providers.datadefinition.mdd.FieldNode;
import org.makumba.providers.datadefinition.mdd.FunctionNode;
import org.makumba.providers.datadefinition.mdd.TitleFieldNode;
import org.makumba.providers.datadefinition.mdd.ValidationRuleNode;

public class MDDNode
extends CommonAST {
    private static final long serialVersionUID = -2197404256348086058L;
    static final String createName = "TS_create";
    static final String modifyName = "TS_modify";
    protected String name = "";
    protected String ptrSubfield = "";
    protected String indexName = "";
    protected TitleFieldNode titleField = new TitleFieldNode();
    protected URL origin;
    protected String parent;
    protected String fieldNameInParent = "";
    protected boolean isFileSubfield = false;
    protected LinkedHashMap<String, FieldNode> fields = new LinkedHashMap();
    protected LinkedHashMap<String, ValidationRule> validationRules = new LinkedHashMap();
    protected LinkedHashMap<Object, DataDefinition.MultipleUniqueKeyDefinition> multiFieldUniqueList = new LinkedHashMap();
    protected LinkedHashMap<String, DataDefinition.QueryFragmentFunction> functions = new LinkedHashMap();

    public MDDNode(String name, URL origin) {
        this.setName(name);
        this.origin = origin;
    }

    public MDDNode(MDDNode parent, String subFieldName) {
        this.setName(parent.getName());
        this.ptrSubfield = "->" + subFieldName;
        this.origin = parent.origin;
        this.parent = parent.getName();
        this.fieldNameInParent = subFieldName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name + this.ptrSubfield;
    }

    protected void setTitleField(TitleFieldNode title) {
        this.titleField = title;
        this.titleField.mdd = this;
    }

    public void addField(FieldNode fi) {
        this.fields.put(fi.name, fi);
    }

    public void removeField(String name) {
        if (this.fields.get(name) != null) {
            this.fields.remove(name);
        }
    }

    public void addValidationRule(ValidationRuleNode vn) {
        this.validationRules.put(vn.getRuleName(), vn);
    }

    public void addMultiUniqueKey(DataDefinition.MultipleUniqueKeyDefinition definition) {
        this.multiFieldUniqueList.put(definition.getFields(), definition);
    }

    public void addFunction(FunctionNode funct, AST parsedFunction) {
        DataDefinition.QueryFragmentFunction function;
        funct.function = function = new DataDefinition.QueryFragmentFunction(funct.name, funct.sessionVariableName, funct.queryFragment, funct.parameters, funct.errorMessage, parsedFunction);
        this.functions.put(function.getName(), function);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Type name: " + this.getName() + "\n");
        sb.append("Type origin: " + this.origin + "\n");
        if (this.parent != null) {
            sb.append("Type parent: " + this.parent + "\n");
        }
        if (this.titleField != null) {
            sb.append("Title field: " + this.titleField.getText());
        }
        sb.append("\nFields:\n");
        Iterator<String> i = this.fields.keySet().iterator();
        while (i.hasNext()) {
            sb.append(this.fields.get(i.next()).toString() + "\n");
        }
        sb.append("\nValidation rules:\n");
        i = this.validationRules.keySet().iterator();
        while (i.hasNext()) {
            sb.append(this.validationRules.get(i.next()).toString() + "\n");
        }
        return sb.toString();
    }
}

