/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd.validation;

import antlr.collections.AST;
import java.util.Date;
import java.util.LinkedHashMap;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.NullObject;
import org.makumba.Transaction;
import org.makumba.providers.datadefinition.mdd.FieldNode;
import org.makumba.providers.datadefinition.mdd.FieldType;
import org.makumba.providers.datadefinition.mdd.MDDNode;
import org.makumba.providers.datadefinition.mdd.ValidationRuleNode;
import org.makumba.providers.datadefinition.mdd.ValidationType;

public class ComparisonValidationRule
extends ValidationRuleNode {
    private static final long serialVersionUID = -3236085075060228473L;

    public ComparisonValidationRule(MDDNode mdd, AST originAST, ValidationType type, FieldNode parentField) {
        super(mdd, originAST, type, parentField);
    }

    public String getRuleName() {
        return "compare() { " + this.comparisonExpression.toString() + " } : " + this.message + " (line " + this.getLine() + ")";
    }

    public boolean validate(Object value, Transaction t) throws InvalidValueException {
        LinkedHashMap values = null;
        if (!(value instanceof LinkedHashMap)) {
            throw new MakumbaError("can't validate multi-field validation rule without right argument type, dude!");
        }
        values = (LinkedHashMap)value;
        Object left = null;
        Object right = null;
        int compare = -1;
        if (values.containsKey(this.comparisonExpression.getLhs())) {
            left = values.get(this.comparisonExpression.getLhs());
            if (this.comparisonExpression.getLhs_type() == 44) {
                left = ((String)left).toUpperCase();
            } else if (this.comparisonExpression.getLhs_type() == 45) {
                left = ((String)left).toLowerCase();
            }
        }
        if (values.containsKey(this.comparisonExpression.getRhs())) {
            right = values.get(this.comparisonExpression.getRhs());
            if (this.comparisonExpression.getRhs_type() == 44) {
                right = ((String)right).toUpperCase();
            } else if (this.comparisonExpression.getRhs_type() == 45) {
                right = ((String)right).toLowerCase();
            }
        }
        if (this.comparisonExpression.getComparisonType() == null) {
            throw new MakumbaError("Comparison type of comparison validation rule '" + this.getRuleName() + "' not set.");
        }
        switch (this.comparisonExpression.getComparisonType()) {
            case DATE: {
                if (left == null) {
                    left = this.comparisonExpression.getLhs_date();
                }
                if (left instanceof NullObject) {
                    left = FieldType.DATE.getEmptyValue();
                }
                if (right == null) {
                    right = this.comparisonExpression.getRhs_date();
                }
                if (right instanceof NullObject) {
                    right = FieldType.DATE.getEmptyValue();
                }
                compare = ((Date)left).compareTo((Date)right);
                break;
            }
            case NUMBER: {
                if (left == null) {
                    left = this.comparisonExpression.getLhs();
                }
                if (left instanceof NullObject) {
                    left = FieldType.INT.getEmptyValue();
                }
                if (right == null) {
                    right = this.comparisonExpression.getRhs();
                }
                if (right instanceof NullObject) {
                    right = FieldType.INT.getEmptyValue();
                }
                compare = Double.compare(((Number)left).doubleValue(), ((Number)right).doubleValue());
                break;
            }
            case STRING: {
                if (((String)left).length() > 0 && ((String)right).length() > 0) {
                    compare = ((String)left).compareTo((String)right);
                    break;
                }
                return true;
            }
        }
        int compareOperator = this.comparisonExpression.getOperatorType();
        if (compareOperator == 11) {
            return this.throwException(compare < 0);
        }
        if (compareOperator == 15) {
            return this.throwException(compare < 0 || compare == 0);
        }
        if (compareOperator == 10) {
            return this.throwException(compare == 0);
        }
        if (compareOperator == 12) {
            return this.throwException(compare > 0);
        }
        if (compareOperator == 16) {
            return this.throwException(compare > 0 || compare == 0);
        }
        if (compareOperator == 14) {
            return this.throwException(compare != 0);
        }
        return false;
    }

    protected boolean throwException(boolean b) throws InvalidValueException {
        if (!b) {
            throw new InvalidValueException((String)this.arguments.get(0), this.getErrorMessage());
        }
        return b;
    }
}

