/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.makumba.commons.MakumbaTLDGenerator;

public class TaglibDocGenerator {
    private File outputDir;
    private HashMap<String, Element> processedElements = new HashMap();
    private static final String[][] genericAttributes = new String[][]{{"Form-specific HTML tag attribute", "The content is copied to the resulting <form...> tag. Careful with (escaping) quotes."}, {"Generic HTML tag attribute", "The content is copied to the resulting html tag. Careful with (escaping) quotes."}, {"Input-specific HTML tag attribute", "The content is copied to the resulting <input...> tag. Careful with (escaping) quotes."}};

    public static void main(String[] args) {
        String inputXMLPath = args[0];
        String outputPath = args[1];
        TaglibDocGenerator tdg = new TaglibDocGenerator(inputXMLPath, outputPath);
    }

    public TaglibDocGenerator(String inputXMLPath, String outputPath) {
        File xml = new File(inputXMLPath);
        if (!xml.exists()) {
            throw new RuntimeException("Could not find input file " + inputXMLPath);
        }
        this.outputDir = new File(outputPath);
        if (!this.outputDir.isDirectory() || !this.outputDir.exists()) {
            throw new RuntimeException("Output path " + outputPath + " does not exist or is not a directory");
        }
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(xml);
        }
        catch (DocumentException e) {
            throw new RuntimeException("Could not read TLD XML file", e);
        }
        this.generateTaglibDocumentation(document);
    }

    private void generateTaglibDocumentation(Document document) {
        Element root = document.getRootElement();
        ArrayList<String> tagNames = new ArrayList<String>();
        ArrayList<String> functionNames = new ArrayList<String>();
        Iterator i = root.elementIterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (e.getName().equals("tag") && !e.elementText("name").equals("rickroll")) {
                tagNames.add(e.elementText("name"));
            }
            if (e.getName().equals("function")) {
                functionNames.add(e.elementText("name"));
            }
            try {
                if (!e.getName().equals("tag") || e.elementText("name").equals("rickroll")) continue;
                this.generateTagFile(e, true);
                this.processedElements.put(e.elementText("name"), e);
            }
            catch (FileNotFoundException io) {
                throw new RuntimeException("Cannot find generated file", io);
            }
            catch (IOException io2) {
                throw new RuntimeException("Cannot create generated file", io2);
            }
        }
        Collections.sort(tagNames);
        Collections.sort(functionNames);
        File taglibIndexFile = new File(this.outputDir.getAbsolutePath() + File.separator + "TagIndex.txt");
        try {
            if (!taglibIndexFile.exists()) {
                taglibIndexFile.createNewFile();
            }
            PrintStream s = new PrintStream(new FileOutputStream(taglibIndexFile));
            s.println("!!!makumba tag library");
            s.println();
            for (String el : tagNames) {
                String tagName = this.processedElements.get(el).elementText("name");
                s.println("* [mak:" + tagName + "|" + this.getWikiTagName(tagName) + "]");
            }
            for (String f : functionNames) {
                s.println("* [mak:" + f + "()|" + this.getWikiTagName(f) + "]");
            }
            s.println();
            s.println("%%(display:none;)[Category Documentation]%%");
        }
        catch (IOException io) {
            throw new RuntimeException("Cannot create index file", io);
        }
    }

    private void generateTagFile(Element element, boolean isTag) throws IOException {
        String elementName = element.elementText("name");
        String generatedFileName = this.getWikiTagName(elementName);
        File generatedFile = new File(this.outputDir.getAbsoluteFile() + File.separator + generatedFileName + ".txt");
        if (!generatedFile.exists()) {
            generatedFile.createNewFile();
        }
        if (System.getProperty("os.name").startsWith("Mac OS X")) {
            System.setProperty("line.separator", "\r\n");
        }
        FileOutputStream fos = new FileOutputStream(generatedFile);
        BufferedWriter s = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
        if (isTag) {
            s.append("!!!Taglib documentation for tag mak:" + elementName);
            s.newLine();
        } else {
            s.append("!!!Taglib documentation for EL function mak:" + elementName);
            s.newLine();
        }
        s.newLine();
        this.generateDescription(element, s);
        s.newLine();
        this.generateAttributes(element, s);
        s.newLine();
        this.generateSeeAlso(element, s);
        s.newLine();
        this.generateExamples(element, s);
        s.newLine();
        s.append("%%(display:none;)[Category Documentation]%%");
        s.flush();
        s.close();
        fos.close();
    }

    private String getWikiTagName(String elementName) {
        return elementName.substring(0, 1).toUpperCase() + elementName.substring(1, elementName.length()) + "Tag";
    }

    private void generateExamples(Element element, BufferedWriter s) throws IOException {
        s.append("!!Examples");
        s.newLine();
        s.newLine();
        Node examples = this.checkNodeExists(element, "example");
        StringTokenizer tk = new StringTokenizer(examples.getText(), ",");
        if (tk.countTokens() == 0) {
            s.append("%%(color:red) No example page provided for this tag!!%%");
            s.newLine();
        }
        while (tk.hasMoreElements()) {
            s.append(this.getPageInsert(tk.nextToken()));
            s.newLine();
            s.newLine();
        }
    }

    private void generateSeeAlso(Element element, BufferedWriter s) throws IOException {
        Node seeAlso = this.checkNodeExists(element, "see");
        StringTokenizer tk = new StringTokenizer(seeAlso.getText(), ",");
        if (tk.countTokens() > 0) {
            s.append("!!See also");
            s.newLine();
            s.newLine();
        }
        while (tk.hasMoreElements()) {
            String reference = tk.nextToken().trim();
            Object referredElement = element.getDocument().getRootElement().selectObject("//taglib//tag['@name=" + reference + "']");
            if (referredElement == null) {
                throw new RuntimeException("Error: see also reference " + reference + " in tag definition " + element.elementText("name") + " does not exist.");
            }
            String referenceWikiName = reference.substring(0, 1).toUpperCase() + reference.substring(1, reference.length()) + "Tag";
            s.append("[mak:" + reference + "|" + referenceWikiName + "]");
            if (!tk.hasMoreTokens()) continue;
            s.append(", ");
        }
        if (tk.countTokens() > 0) {
            s.newLine();
        }
    }

    private void generateAttributes(Element element, BufferedWriter s) throws IOException {
        s.append("!!Attributes");
        s.newLine();
        List attributes = element.elements("attribute");
        if (attributes.size() == 0) {
            s.append("This tag has no attributes");
            s.newLine();
        } else {
            s.newLine();
            s.append("%%(display:none) makumba hackers: DO NOT CHANGE THESE ATTRIBUTES HERE since your changes will be lost! You have to edit the taglib-documented.xml file and re-generate the taglib doc! %%");
            s.newLine();
            s.newLine();
            s.append("[{Table");
            s.newLine();
            s.newLine();
            s.append("||Name||Required||Request-time||Description||Comments ");
            s.newLine();
            s.newLine();
            GenericAttributeTuple genericAttributeTuple = new GenericAttributeTuple();
            for (Element a : attributes) {
                if (a.attribute("name") != null && a.attribute("specifiedIn") != null) {
                    Element includedAttribute = MakumbaTLDGenerator.getReferencedAttributes(this.processedElements, "Error processing attribute " + a.attributeValue("name") + " of tag " + element.elementText("name") + ": ", element, element.elementText("name"), a);
                    this.generateAttributeRow(includedAttribute, s, genericAttributeTuple);
                    continue;
                }
                this.generateAttributeRow(a, s, genericAttributeTuple);
            }
            if (genericAttributeTuple.getGenericAttributeName() != null) {
                genericAttributeTuple.print(s);
                genericAttributeTuple.reset();
            }
            s.newLine();
            s.append("}]");
            s.newLine();
        }
    }

    private void generateAttributeRow(Element attribute, BufferedWriter s, GenericAttributeTuple genericAttributeTuple) throws IOException {
        String name = attribute.elementText("name");
        String required = attribute.elementText("required");
        String runtimeExpr = attribute.elementText("rtexprvalue");
        String description = this.getOrInsertElement(attribute, "description");
        String comments = this.getOrInsertElement(attribute, "comments");
        String deprecated = attribute.elementText("deprecated");
        boolean isDeprecated = deprecated != null && deprecated.equals("true");
        String deprecatedStyle = isDeprecated ? "(deprecated) " : "";
        boolean isGenericAttribute = false;
        for (String[] generic : genericAttributes) {
            if (!description.equals(generic[0]) || !comments.equals(generic[1])) continue;
            isGenericAttribute = true;
            if (genericAttributeTuple.getGenericAttributeName() == null) {
                genericAttributeTuple.setFirstGenericAttribute(name, required, runtimeExpr, description + " (generic)", comments + " (generic)");
                genericAttributeTuple.setGenericAttributeName(generic[0]);
                continue;
            }
            if (genericAttributeTuple.getGenericAttributeName().equals(generic[0])) {
                genericAttributeTuple.addAttribute(name, required, runtimeExpr);
                continue;
            }
            genericAttributeTuple.print(s);
            genericAttributeTuple.reset();
            genericAttributeTuple.setFirstGenericAttribute(name, required, runtimeExpr, description + " (generic)", comments + " (generic)");
        }
        if (!isGenericAttribute && genericAttributeTuple.getGenericAttributeName() != null) {
            genericAttributeTuple.print(s);
            genericAttributeTuple.reset();
        } else if (!isGenericAttribute) {
            if (isDeprecated) {
                s.append("|" + deprecatedStyle + name + " (deprecated) ");
            } else {
                s.append("|" + deprecatedStyle + name + " ");
            }
            s.newLine();
            s.append("|" + deprecatedStyle + required + " ");
            s.newLine();
            s.append("|" + deprecatedStyle + runtimeExpr + " ");
            s.newLine();
            s.append("|" + deprecatedStyle + description + " ");
            s.newLine();
            s.append("|" + deprecatedStyle + comments + " ");
            s.newLine();
            s.newLine();
        }
    }

    private void generateDescription(Element element, BufferedWriter s) throws IOException {
        s.append("!!Description");
        s.newLine();
        s.newLine();
        s.append(this.getOrInsertElement(element, "description"));
        s.newLine();
    }

    private String getOrInsertElement(Element element, String elementName) {
        Element e = element.element(elementName);
        Element elementPage = element.element(elementName + "Page");
        if (elementPage != null && elementPage.hasContent()) {
            return this.getPageInsert(elementPage.getText());
        }
        if (e != null && e.hasContent()) {
            return e.getTextTrim();
        }
        if (e != null && !e.hasContent()) {
            return "%%(color:red) DOCUMENT ME PLEASE! %%";
        }
        if (e == null && elementPage == null) {
            throw new RuntimeException("No " + elementName + " for element " + element.elementText("name"));
        }
        return null;
    }

    private Node checkNodeExists(Element element, String nodeName) {
        Element n = element.element(nodeName);
        if (n == null) {
            throw new RuntimeException("No <" + nodeName + "> element found in taglib-documented.xml for element " + element.elementText("name"));
        }
        return n;
    }

    private String getPageInsert(String pageName) {
        return "[{InsertPage page=" + pageName + "}]";
    }

    class GenericAttributeTuple {
        private String[] firstGenericAttribute;
        private String genericAttributeName;
        private List<String[]> attributes = new ArrayList<String[]>();

        GenericAttributeTuple() {
        }

        public void addAttribute(String name, String required, String runtimeExpr) {
            String[] att = new String[]{name, required, runtimeExpr};
            this.attributes.add(att);
        }

        public void print(BufferedWriter s) throws IOException {
            for (String str : this.firstGenericAttribute) {
                s.append("|" + str + " ");
                s.newLine();
            }
            s.newLine();
            for (String[] att : this.attributes) {
                s.append("|" + att[0] + " ");
                s.newLine();
                s.append("|" + att[1] + " ");
                s.newLine();
                s.append("|" + att[2] + " ");
                s.newLine();
                s.append("|^ ");
                s.newLine();
                s.append("|^ ");
                s.newLine();
                s.newLine();
            }
        }

        public void reset() {
            this.firstGenericAttribute = null;
            this.genericAttributeName = null;
            this.attributes = new ArrayList<String[]>();
        }

        public void setFirstGenericAttribute(String name, String required, String runtimeExpr, String description, String comments) {
            this.firstGenericAttribute = new String[5];
            this.firstGenericAttribute[0] = name;
            this.firstGenericAttribute[1] = required;
            this.firstGenericAttribute[2] = runtimeExpr;
            this.firstGenericAttribute[3] = description;
            this.firstGenericAttribute[4] = comments;
        }

        public String getGenericAttributeName() {
            return this.genericAttributeName;
        }

        public void setGenericAttributeName(String genericAttributeName) {
            this.genericAttributeName = genericAttributeName;
        }
    }
}

