/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel.relations;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.makumba.MakumbaError;
import org.makumba.Pointer;
import org.makumba.Transaction;
import org.makumba.commons.FileUtils;
import org.makumba.commons.NamedResources;
import org.makumba.commons.ReadableFormatter;
import org.makumba.devel.relations.FileRelations;
import org.makumba.devel.relations.JSPRelationMiner;
import org.makumba.devel.relations.JavaRelationMiner;
import org.makumba.devel.relations.MDDRelationMiner;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.datadefinition.makumba.RecordInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationCrawler {
    protected static boolean subProcess = false;
    private String webappRoot;
    private String targetDatabase;
    private Pointer targetDatabasePointer;
    private boolean forceDatabase;
    private int JSPCrawlCount = 0;
    private JSPRelationMiner JSPRelationMiner;
    private MDDRelationMiner MDDRelationMiner;
    private JavaRelationMiner JavaRelationMiner;
    private Hashtable<String, Throwable> JSPAnalysisErrors = new Hashtable();
    private Vector<String> JavaAnalysisErrors = new Vector();
    private Map<String, Map<String, Vector<Dictionary<String, Object>>>> detectedRelations = new HashMap<String, Map<String, Vector<Dictionary<String, Object>>>>();
    private String URLprefix;
    private String URLroot;
    private boolean relationTypeDetail = false;
    private TransactionProvider tp = TransactionProvider.getInstance();
    private static final String DATABASE_NAME_KEY = "org.makumba.devel.relations.databaseName";
    private static Map<String, RelationCrawler> relationCrawlers = new HashMap<String, RelationCrawler>();

    public static RelationCrawler getRelationCrawler(String webappRoot, String targetDatabase, boolean forcetarget, String URLprefix, String URLroot, boolean relationTypeDetail) {
        RelationCrawler instance = relationCrawlers.get(webappRoot + targetDatabase + forcetarget + URLprefix + URLroot);
        if (instance == null) {
            if (URLprefix == null || URLprefix.trim().length() == 0) {
                URLprefix = "file://";
            }
            instance = new RelationCrawler(webappRoot, targetDatabase, forcetarget, URLprefix, URLroot, relationTypeDetail);
            relationCrawlers.put(webappRoot + targetDatabase + forcetarget + URLprefix + URLroot, instance);
        }
        return instance;
    }

    public static String getDefaultTargetDatabase() {
        return System.getProperty(DATABASE_NAME_KEY) == null ? TransactionProvider.getInstance().getDefaultDataSourceName() : System.getProperty(DATABASE_NAME_KEY);
    }

    private RelationCrawler(String webappRoot, String targetDatabase, boolean forcetarget, String URLprefix, String URLroot, boolean relationTypeDetail) {
        this.webappRoot = webappRoot;
        this.targetDatabase = targetDatabase;
        this.forceDatabase = forcetarget;
        this.URLprefix = URLprefix;
        this.URLroot = URLroot;
        this.relationTypeDetail = relationTypeDetail;
        this.JSPRelationMiner = new JSPRelationMiner(this);
        this.MDDRelationMiner = new MDDRelationMiner(this);
        this.JavaRelationMiner = new JavaRelationMiner(this);
    }

    private Map<String, Map<String, Vector<Dictionary<String, Object>>>> getDetectedRelations() {
        return this.detectedRelations;
    }

    public String getTargetDatabaseName() {
        this.determineRelationsDatabase(this.tp, this.forceDatabase, false);
        return this.targetDatabase;
    }

    protected String getWebappRoot() {
        return this.webappRoot;
    }

    public Hashtable<String, Throwable> getJSPAnalysisErrors() {
        return this.JSPAnalysisErrors;
    }

    public int getJSPCrawlCount() {
        return this.JSPCrawlCount;
    }

    public Vector<String> getJavaAnalysisErrors() {
        return this.JavaAnalysisErrors;
    }

    protected void addJSPAnalysisError(String s, Throwable t) {
        this.JSPAnalysisErrors.put(s, t);
    }

    protected void addJavaAnalysisError(String s) {
        this.JavaAnalysisErrors.add(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJSPAnalysisError(String fileName, Hashtable<String, Throwable> analysisErrors, int JSPCrawlCount) {
        File f = new File(fileName);
        PrintWriter pw = null;
        try {
            f.createNewFile();
            pw = new PrintWriter(new FileOutputStream(f));
            pw.println("Date of crawling: " + new Date());
            pw.println("Total number of page crawled: " + JSPCrawlCount);
            pw.println("Total number of JSP page analysis errors: " + analysisErrors.size());
            pw.println("\nError summary\n");
            int n = 0;
            for (String file : analysisErrors.keySet()) {
                pw.println(n + ".\t" + file);
                pw.println("\t" + analysisErrors.get(file).getMessage() + "\n");
                ++n;
            }
            pw.println("\nError detail\n");
            n = 0;
            for (String file : analysisErrors.keySet()) {
                pw.println(n + ".\t" + file + "\n\n");
                analysisErrors.get(file).printStackTrace(pw);
                pw.println("******************************************************************************\n");
                ++n;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            pw.flush();
            pw.close();
        }
    }

    public static void main(String[] args) {
        Options options = new Options();
        Option webappRootOption = new Option("w", "root", true, "the root of the makumba webapp to crawl");
        Option targetDb = new Option("d", "database", true, "the name of the target database where the relations should be stored");
        targetDb.setRequired(true);
        Option forceDb = new Option("f", "forceDb", false, "indicates whether the target database should be forced: if set to true, even if relations were previously written to another database, this will force writing them to the indicated database");
        Option urlPrefix = new Option("p", "urlPrefix", true, "the prefix given to the file URL, e.g. \"file://\"");
        Option urlRoot = new Option("u", "urlRoot", true, "the root of the URL, e.g. the name of the crawled webapp");
        Option skipPathsOption = new Option("s", "skipPaths", true, "a list of paths to be skipped during the crawling, separated by a comma");
        skipPathsOption.setValueSeparator(',');
        Option typeDetail = new Option("t", "relationTypeDetail", false, "whether or not to save the detailed type of the relation, if set to false, 'dependsOn' is used");
        options.addOption(webappRootOption);
        options.addOption(targetDb);
        options.addOption(forceDb);
        options.addOption(urlPrefix);
        options.addOption(urlRoot);
        options.addOption(skipPathsOption);
        options.addOption(typeDetail);
        HelpFormatter formatter = new HelpFormatter();
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException p) {
            System.out.println("Error while executing the relation crawler: " + p.getMessage());
            System.out.println();
            formatter.printHelp("java " + RelationCrawler.class.getName() + " [OPTION]... [FILE]...", options);
            System.exit(-1);
        }
        String webappRoot = line.getOptionValue("w", ".");
        String targetDatabase = line.getOptionValue("d");
        boolean forceDatabase = Boolean.parseBoolean(line.getOptionValue("f", "false"));
        String URLprefix = line.getOptionValue("p", "");
        String URLroot = line.getOptionValue("u", "");
        Object[] skipPaths = line.getOptionValues("s");
        if (skipPaths == null) {
            skipPaths = new String[]{};
        }
        boolean relationTypeDetail = Boolean.parseBoolean(line.getOptionValue("t", "false"));
        Object[] files = line.getArgs();
        System.out.println("Starting relation crawler, config:");
        System.out.println("\twebappRoot: " + webappRoot);
        System.out.println("\ttargetDatabase: " + targetDatabase);
        System.out.println("\tforceDatabase: " + forceDatabase);
        System.out.println("\tURLprefix: " + URLprefix);
        System.out.println("\tURLroot: " + URLroot);
        System.out.println("\tSkip: " + Arrays.toString(skipPaths));
        System.out.println("\trelationTypeDetail: " + relationTypeDetail);
        System.out.println("\tFiles: " + Arrays.toString(files));
        System.out.println("\t(from : " + Arrays.toString(args) + ")");
        Date beginDate = new Date();
        System.out.println("\nCrawling starts at " + beginDate + "\n");
        if (files == null || files.length == 0) {
            System.out.println("\nNo paths indicated, crawling all files in webapp\n");
            ArrayList<String> allFilesInDirectory = FileUtils.getAllFilesInDirectory(webappRoot, (String[])skipPaths, new MakumbaRelatedFileFilter());
            Collections.sort(allFilesInDirectory);
            files = allFilesInDirectory.toArray(new String[allFilesInDirectory.size()]);
        }
        RelationCrawler rc = RelationCrawler.getRelationCrawler(webappRoot, targetDatabase, forceDatabase, URLprefix == null ? "" : URLprefix, URLroot == null ? "" : URLroot, relationTypeDetail);
        RecordInfo.setWebappRoot(webappRoot);
        for (int i = 0; i < files.length; ++i) {
            rc.crawl((String)files[i]);
        }
        RecordInfo.setWebappRoot(null);
        NamedResources.cleanStaticCache(RecordInfo.infos);
        System.out.println("\n\nCrawling finished, took: " + ReadableFormatter.readableAge(System.currentTimeMillis() - beginDate.getTime()));
        RelationCrawler.writeJSPAnalysisError("analysis-errors.txt", rc.JSPAnalysisErrors, rc.JSPCrawlCount);
        rc.writeRelationsToDb(false);
        System.out.println("\n\nWriting finished, total time: " + ReadableFormatter.readableAge(System.currentTimeMillis() - beginDate.getTime()));
    }

    public void crawl(String path) {
        if (path.endsWith(".jsp")) {
            this.JSPRelationMiner.crawl(path);
            ++this.JSPCrawlCount;
        } else if (path.endsWith(".mdd")) {
            this.MDDRelationMiner.crawl(path);
        } else if (path.endsWith(".java")) {
            this.JavaRelationMiner.crawl(path);
        }
    }

    protected void addRelation(String fromFile, String toFile, String type, Dictionary<String, Object> relationData) {
        if (!fromFile.equals(toFile)) {
            Map<String, Vector<Dictionary<String, Object>>> dic = this.detectedRelations.get(toFile);
            if (dic != null) {
                Vector<Dictionary<String, Object>> v = dic.get(fromFile);
                if (v == null) {
                    v = new Vector();
                }
                v.add(relationData);
                dic.put(fromFile, v);
            } else {
                dic = new Hashtable<String, Vector<Dictionary<String, Object>>>();
                Vector<Dictionary<String, Object>> v = new Vector<Dictionary<String, Object>>();
                v.add(relationData);
                dic.put(fromFile, v);
                this.detectedRelations.put(toFile, dic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRelationsToDb(boolean updateExistingRelations) {
        Map<String, Map<String, Vector<Dictionary<String, Object>>>> relations = this.getDetectedRelations();
        Pointer webappPointer = this.determineRelationsDatabase(this.tp, this.forceDatabase, true);
        for (String typeAndtoFile : relations.keySet()) {
            String toFile = typeAndtoFile.substring(typeAndtoFile.indexOf("#") + 1);
            String type = this.relationTypeDetail ? typeAndtoFile.substring(0, typeAndtoFile.indexOf("#")) : "dependsOn";
            Map<String, Vector<Dictionary<String, Object>>> map = relations.get(toFile);
            for (String fromFile : map.keySet()) {
                Vector<Dictionary<String, Object>> origins = map.get(fromFile);
                Hashtable<String, Object> relationInfo = new Hashtable<String, Object>();
                ((Dictionary)relationInfo).put("type", type);
                ((Dictionary)relationInfo).put("fromFile", fromFile);
                String fromURL = this.URLprefix + (this.URLroot.startsWith("/") ? this.URLroot.substring(1) : this.URLroot) + (this.URLroot.endsWith("/") || fromFile.startsWith("/") ? "" : "/") + fromFile;
                String toURL = this.URLprefix + (this.URLroot.startsWith("/") ? this.URLroot.substring(1) : this.URLroot) + (this.URLroot.endsWith("/") || toFile.startsWith("/") ? "" : "/") + toFile;
                Logger.getLogger("org.makumba.devel.relations").info("Writing relation " + fromURL + " -(" + type + ")-> " + toURL);
                Transaction tr2 = null;
                try {
                    tr2 = this.tp.getConnectionTo(this.targetDatabase);
                    if (updateExistingRelations) {
                        String oqlQuery = "SELECT relation AS relation FROM org.makumba.devel.relations.Relation relation WHERE relation.toFile = $1 AND relation.fromFile = $2 and relation.webapp.webappRoot = $3";
                        String hqlQuery = "SELECT relation.id AS relation FROM org.makumba.devel.relations.Relation relation JOIN relation.webapp webapp WHERE relation.toFile = ? AND relation.fromFile = ? AND webapp.webappRoot = ?";
                        Object[] args = new Object[]{toFile, fromFile, this.webappRoot};
                        Vector<Dictionary<String, Object>> previousRelation = tr2.executeQuery(this.tp.getQueryLanguage().equals("oql") ? oqlQuery : hqlQuery, args);
                        if (previousRelation.size() > 0) {
                            Pointer previousRelationPtr = (Pointer)previousRelation.get(0).get("relation");
                            this.deleteRelation(tr2, previousRelationPtr);
                        }
                    }
                    ((Dictionary)relationInfo).put("toFile", toFile);
                    ((Dictionary)relationInfo).put("fromURL", fromURL);
                    ((Dictionary)relationInfo).put("toURL", toURL);
                    ((Dictionary)relationInfo).put("webapp", webappPointer);
                    Vector<Pointer> originSet = new Vector<Pointer>();
                    for (Dictionary<String, Object> origin : origins) {
                        originSet.add(tr2.insert("org.makumba.devel.relations.RelationOrigin", origin));
                    }
                    ((Dictionary)relationInfo).put("origin", originSet);
                    tr2.insert("org.makumba.devel.relations.Relation", relationInfo);
                }
                finally {
                    if (tr2 == null) continue;
                    tr2.close();
                }
            }
        }
        relations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExistingRelations(Pointer webappPointer) {
        Transaction tr = null;
        try {
            tr = this.tp.getConnectionTo(this.targetDatabase);
            String oqlWhere1 = "o in (select r.origin from org.makumba.devel.relations.Relation r where r.webapp = $1)";
            String hqlWhere1 = "o in (select r.origin from org.makumba.devel.relations.Relation r where r.webapp.id = ?)";
            String oqlWhere2 = "relation.webapp = $1";
            String hqlWhere2 = "relation.webapp.id = ?";
            tr.delete("org.makumba.devel.relations.Relation relation", this.tp.getQueryLanguage().equals("oql") ? oqlWhere2 : hqlWhere2, new Object[]{webappPointer});
            tr.delete("org.makumba.devel.relations.RelationOrigin o", this.tp.getQueryLanguage().equals("oql") ? oqlWhere1 : hqlWhere1, new Object[]{webappPointer});
            tr.commit();
        }
        finally {
            if (tr != null) {
                tr.close();
            }
        }
    }

    private void deleteRelation(Transaction tr2, Pointer previousRelationPtr) {
        String oqlQuery1 = "SELECT origin AS origin FROM org.makumba.devel.relations.Relation relation, relation.origin origin WHERE relation = $1";
        String hqlQuery1 = "SELECT origin.id AS origin FROM org.makumba.devel.relations.Relation relation JOIN relation.origin origin WHERE relation.id = ?";
        Vector<Dictionary<String, Object>> previousRelationOrigin = tr2.executeQuery(this.tp.getQueryLanguage().equals("oql") ? oqlQuery1 : hqlQuery1, new Object[]{previousRelationPtr});
        tr2.delete(previousRelationPtr);
        for (Dictionary<String, Object> dictionary : previousRelationOrigin) {
            tr2.delete((Pointer)dictionary.get("origin"));
        }
    }

    public boolean wasCrawled() {
        return this.determineRelationsDatabase(this.tp, false, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pointer determineRelationsDatabase(TransactionProvider tp, boolean forceDestination, boolean createDefaultRecord) {
        block9: {
            if (this.targetDatabasePointer != null) {
                return this.targetDatabasePointer;
            }
            Transaction tr = null;
            try {
                tr = tp.getConnectionTo(tp.getDefaultDataSourceName());
                Vector<Dictionary<String, Object>> databaseLocation = this.queryTargetDatabasePointer(tp, tr);
                if (databaseLocation.size() > 1) {
                    throw new RuntimeException("Too many possible locations for the relations database of webapp " + this.webappRoot);
                }
                if (databaseLocation.size() == 1) {
                    if (forceDestination) {
                        Hashtable<String, Object> data = new Hashtable<String, Object>();
                        ((Dictionary)data).put("relationDatabase", this.targetDatabase);
                        Pointer oldPointer = this.targetDatabasePointer = (Pointer)databaseLocation.get(0).get("webappPointer");
                        tr.update(oldPointer, data);
                    } else {
                        this.targetDatabase = (String)databaseLocation.get(0).get("relationDatabase");
                        this.targetDatabasePointer = (Pointer)databaseLocation.get(0).get("webappPointer");
                    }
                    break block9;
                }
                if (databaseLocation.size() == 0 && createDefaultRecord) {
                    Hashtable<String, Object> data = new Hashtable<String, Object>();
                    ((Dictionary)data).put("webappRoot", this.webappRoot);
                    ((Dictionary)data).put("relationDatabase", this.targetDatabase);
                    this.targetDatabasePointer = tr.insert("org.makumba.devel.relations.WebappDatabase", data);
                    break block9;
                }
                Pointer pointer = null;
                return pointer;
            }
            finally {
                tr.close();
            }
        }
        return this.targetDatabasePointer;
    }

    private Vector<Dictionary<String, Object>> queryTargetDatabasePointer(TransactionProvider tp, Transaction tr) {
        String oqlQuery = "SELECT wdb AS webappPointer, wdb.relationDatabase AS relationDatabase from org.makumba.devel.relations.WebappDatabase wdb WHERE wdb.webappRoot = $1";
        String hqlQuery = "SELECT wdb.id AS webappPointer, wdb.relationDatabase AS relationDatabase from org.makumba.devel.relations.WebappDatabase wdb WHERE wdb.webappRoot = ?";
        Vector<Dictionary<String, Object>> databaseLocation = tr.executeQuery(tp.getQueryLanguage().equals("oql") ? oqlQuery : hqlQuery, new String[]{this.webappRoot});
        return databaseLocation;
    }

    public void deleteFileRelations(String relativePath) {
        String relationQueryOQL = "SELECT r AS rel FROM org.makumba.devel.relations.Relation r WHERE r.fromFile = $1";
        String relationQueryHQL = "SELECT r.id AS rel FROM org.makumba.devel.relations.Relation r WHERE r.fromFile = ?";
        Transaction t = this.tp.getConnectionTo(this.getTargetDatabaseName());
        Vector<Dictionary<String, Object>> res = t.executeQuery(this.tp.getQueryLanguage().equals("oql") ? relationQueryOQL : relationQueryHQL, new Object[]{relativePath});
        for (Dictionary<String, Object> dictionary : res) {
            this.deleteRelation(t, (Pointer)dictionary.get("rel"));
        }
        t.close();
    }

    public FileRelations getFileDependencies(String relativePath) {
        String relationQueryOQL = "SELECT r.toFile AS file, r AS relation FROM org.makumba.devel.relations.Relation r WHERE r.fromFile = $1";
        String relationQueryHQL = "SELECT r.toFile AS file, r.id AS relation FROM org.makumba.devel.relations.Relation r WHERE r.fromFile = ?";
        return this.getFileRelations(relativePath, this.tp.getQueryLanguage().equals("oql") ? relationQueryOQL : relationQueryHQL);
    }

    public FileRelations getFileDependents(String relativePath) {
        String relationQueryOQL = "SELECT r.fromFile AS file, r AS relation FROM org.makumba.devel.relations.Relation r WHERE r.toFile = $1";
        String relationQueryHQL = "SELECT r.fromFile AS file, r.id AS relation FROM org.makumba.devel.relations.Relation r WHERE r.toFile = ?";
        return this.getFileRelations(relativePath, this.tp.getQueryLanguage().equals("oql") ? relationQueryOQL : relationQueryHQL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileRelations getFileRelations(String relativePath, String relationQuery) throws MakumbaError {
        FileRelations result = null;
        if (!new File(this.webappRoot + File.separator + relativePath).exists()) {
            throw new MakumbaError("File " + relativePath + " does not exist in webapp " + this.webappRoot);
        }
        TransactionProvider tp = TransactionProvider.getInstance();
        Transaction t = null;
        try {
            String relationDatabase = this.getTargetDatabaseName();
            if (relationDatabase == null) {
                FileRelations fileRelations = new FileRelations(relativePath);
                return fileRelations;
            }
            t = tp.getConnectionTo(relationDatabase);
            Vector<Dictionary<String, Object>> dependencies = t.executeQuery(relationQuery, new Object[]{relativePath});
            result = this.buildFileRelations(relativePath, dependencies, t);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        return result;
    }

    private FileRelations buildFileRelations(String path, Vector<Dictionary<String, Object>> relations, Transaction t) {
        FileRelations fr = new FileRelations(path);
        for (Dictionary<String, Object> dictionary : relations) {
            String file = (String)dictionary.get("file");
            Pointer relation = (Pointer)dictionary.get("relation");
            String queryOQL = "SELECT ro.startcol AS startcol, ro.endcol AS endcol, ro.startline AS startline, ro.endline AS endline, ro.tagname AS tagname, ro.expr AS expr, ro.field AS field, ro.reason AS reason FROM org.makumba.devel.relations.Relation r, r.origin ro WHERE r = $1 order by ro.startline, ro.startcol";
            String queryHQL = "SELECT ro.startcol AS startcol, ro.endcol AS endcol, ro.startline AS startline, ro.endline AS endline, ro.tagname AS tagname, ro.expr AS expr, ro.field AS field, ro.reason AS reason FROM org.makumba.devel.relations.Relation r, r.origin ro WHERE r.id = ? order by ro.startline, ro.startcol";
            Vector<Dictionary<String, Object>> relationOrigin = t.executeQuery(this.tp.getQueryLanguage().equals("oql") ? queryOQL : queryHQL, new Object[]{relation});
            Vector<FileRelations.RelationOrigin> relationOriginVector = new Vector<FileRelations.RelationOrigin>();
            for (Dictionary<String, Object> dictionary2 : relationOrigin) {
                Object startcol = dictionary2.get("startcol");
                Object endcol = dictionary2.get("endcol");
                Object startline = dictionary2.get("startline");
                Object endline = dictionary2.get("endline");
                Object tagname = dictionary2.get("tagname");
                Object expr = dictionary2.get("expr");
                Object field = dictionary2.get("field");
                Object reason = dictionary2.get("reason");
                FileRelations fileRelations = fr;
                fileRelations.getClass();
                FileRelations.RelationOrigin ro = fileRelations.new FileRelations.RelationOrigin(startcol == null ? -1 : (Integer)startcol, endcol == null ? -1 : (Integer)endcol, startline == null ? -1 : (Integer)startline, endline == null ? -1 : (Integer)endline, tagname == null ? null : (String)tagname, expr == null ? null : (String)expr, field == null ? null : (String)field, reason == null ? null : (String)reason);
                relationOriginVector.add(ro);
            }
            if (file.endsWith(".mdd")) {
                fr.getMddRelations().put(file, relationOriginVector);
                continue;
            }
            if (file.endsWith(".jsp")) {
                fr.getJspRelations().put(file, relationOriginVector);
                continue;
            }
            if (!file.endsWith(".java")) continue;
            fr.getJavaRelations().put(file, relationOriginVector);
        }
        return fr;
    }

    public static final class MakumbaRelatedFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            return pathname.getAbsolutePath().endsWith(".jsp") || pathname.getAbsolutePath().endsWith(".java") || pathname.getAbsolutePath().endsWith(".mdd") || pathname.getAbsolutePath().endsWith(".idd") || pathname.isDirectory();
        }
    }
}

