/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.mdd;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.commons.ClassResource;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.commons.SingletonReleaser;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.datadefinition.mdd.DataDefinitionImpl;
import org.makumba.providers.datadefinition.mdd.FieldDefinitionImpl;
import org.makumba.providers.datadefinition.mdd.MDDFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDDProvider
extends DataDefinitionProvider {
    private static String webappRoot;
    public static int infos;

    @Override
    public DataDefinition getDataDefinition(String typeName) {
        return MDDProvider.getMDD(typeName.replaceAll("__", "->"));
    }

    @Override
    public DataDefinition getVirtualDataDefinition(String name) {
        return new DataDefinitionImpl(name.replaceAll("__", "->"));
    }

    @Override
    public FieldDefinition makeFieldDefinition(String name, String definition) {
        String def = name.replaceAll("__", "->") + "=" + definition.replaceAll("__", "->");
        return MDDFactory.getInstance().getVirtualDataDefinition(name.replaceAll("__", "->"), def).getFieldDefinition(name.replaceAll("__", "->"));
    }

    @Override
    public FieldDefinition makeFieldOfType(String name, String type) {
        if (type.startsWith("ptr ")) {
            return this.makeFieldDefinition(name, type);
        }
        return new FieldDefinitionImpl(name.replaceAll("__", "->"), type.replaceAll("__", "->"));
    }

    @Override
    public FieldDefinition makeFieldOfType(String name, String type, String description) {
        return new FieldDefinitionImpl(name.replaceAll("__", "->"), type.replaceAll("__", "->"), description);
    }

    @Override
    public FieldDefinition makeFieldWithName(String name, FieldDefinition type) {
        return new FieldDefinitionImpl(name.replaceAll("__", "->"), type);
    }

    @Override
    public FieldDefinition makeFieldWithName(String name, FieldDefinition type, String description) {
        return new FieldDefinitionImpl(name.replaceAll("__", "->"), type, description);
    }

    @Override
    public Vector<String> getDataDefinitionsInDefaultLocations() {
        return this.getDataDefinitionsInDefaultLocations(null);
    }

    public static DataDefinition getMDD(String name) {
        int n = name.indexOf("->");
        if (n == -1) {
            try {
                return MDDProvider.getSimpleMDD(name);
            }
            catch (DataDefinitionNotFoundError e) {
                n = name.lastIndexOf(".");
                if (n == -1) {
                    throw e;
                }
                try {
                    return MDDProvider.getMDD(name.substring(0, n) + "->" + name.substring(n + 1));
                }
                catch (DataDefinitionParseError f) {
                    throw e;
                }
            }
        }
        DataDefinition dd = MDDProvider.getMDD(name.substring(0, n));
        while ((n = (name = name.substring(n + 2)).indexOf("->")) != -1) {
            dd = dd.getFieldDefinition(name.substring(0, n)).getSubtable();
        }
        FieldDefinition subfieldCheck = dd.getFieldDefinition(name);
        if (subfieldCheck == null) {
            throw new DataDefinitionParseError("subfield not found: " + name + " in " + dd.getName());
        }
        dd = subfieldCheck.getSubtable();
        return dd;
    }

    public static synchronized DataDefinition getSimpleMDD(String path) {
        boolean dot = false;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '.') {
                if (dot) {
                    throw new DataDefinitionParseError("two consecutive dots not allowed in type name");
                }
                dot = true;
            } else {
                dot = false;
            }
            if (path.charAt(i) == '/' || path.charAt(i) == '.' || (i != 0 || Character.isJavaIdentifierStart(path.charAt(i))) && (i <= 0 || Character.isJavaIdentifierPart(path.charAt(i)))) continue;
            throw new DataDefinitionParseError("Invalid character \"" + path.charAt(i) + "\" in type name \"" + path + "\"");
        }
        if (path.indexOf(47) != -1 && (path = path.replace('/', '.')).charAt(0) == '.') {
            path = path.substring(1);
        }
        DataDefinition dd = null;
        try {
            dd = (DataDefinition)NamedResources.getStaticCache(infos).getResource(path);
        }
        catch (RuntimeWrappedException e) {
            if (e.getCause() instanceof DataDefinitionParseError) {
                throw (DataDefinitionParseError)e.getCause();
            }
            if (e.getCause() instanceof DataDefinitionNotFoundError) {
                throw (DataDefinitionNotFoundError)e.getCause();
            }
            if (e.getCause() instanceof MakumbaError) {
                throw (MakumbaError)e.getCause();
            }
            throw e;
        }
        if (path.indexOf("./") == -1) {
            ((DataDefinitionImpl)dd).name = path;
        } else {
            Logger.getLogger("org.makumba.debug.abstr").severe("shit happens: " + path);
        }
        return dd;
    }

    public static URL findDataDefinition(String s, String ext) {
        URL u = MDDProvider.findDataDefinitionOrDirectory(s, ext);
        if (u != null && (s.endsWith("/") || MDDProvider.getResource(s + '/') != null)) {
            return null;
        }
        return u;
    }

    static URL getResource(String s) {
        return ClassResource.get(s);
    }

    private static URL findDataDefinitionOrDirectory(String s, String ext) {
        URL u = null;
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        if (s.endsWith(".") || s.endsWith("//")) {
            return null;
        }
        if (webappRoot != null) {
            File f = new File(webappRoot);
            if (!f.exists() || f.exists() && !f.isDirectory()) {
                throw new MakumbaError("webappRoot " + webappRoot + " does not appear to be a valid directory");
            }
            String mddPath = webappRoot + "/WEB-INF/classes/dataDefinitions/" + s.replace('.', '/') + "." + ext;
            File mdd = new File(mddPath.replaceAll("/", File.separator));
            if (mdd.exists()) {
                try {
                    u = new URL("file://" + mdd.getAbsolutePath());
                }
                catch (MalformedURLException e) {
                    throw new MakumbaError("internal error while trying to retrieve URL for MDD " + mdd.getAbsolutePath());
                }
            }
        }
        if (u == null && (u = MDDProvider.getResource("dataDefinitions/" + s.replace('.', '/') + "." + ext)) == null) {
            u = MDDProvider.getResource(s.replace('.', '/') + "." + ext);
        }
        return u;
    }

    public static DataDefinitionProvider getInstance() {
        return SingletonHolder.singleton;
    }

    private MDDProvider() {
    }

    static {
        infos = NamedResources.makeStaticCache("MDDs parsed", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            protected Object getHashObject(Object name) {
                URL u = MDDProvider.findDataDefinition((String)name, "mdd");
                if (u == null) {
                    throw new DataDefinitionNotFoundError((String)name);
                }
                return u;
            }

            protected Object makeResource(Object name, Object hashName) {
                String nm = (String)name;
                if (nm.indexOf(47) != -1) {
                    nm = nm.replace('/', '.').substring(1);
                }
                return MDDFactory.getInstance().getDataDefinition(nm);
            }

            protected void configureResource(Object name, Object hashName, Object resource) throws Throwable {
                ((DataDefinitionImpl)resource).build();
            }
        });
    }

    private static class SingletonHolder
    implements org.makumba.commons.SingletonHolder {
        private static DataDefinitionProvider singleton = new MDDProvider();

        public void release() {
            singleton = null;
        }

        public SingletonHolder() {
            SingletonReleaser.register(this);
        }
    }
}

