/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.makumba.FieldDefinition;
import org.makumba.OQLParseError;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.datadefinition.mdd.MakumbaDumpASTVisitor;
import org.makumba.providers.query.mql.ASTUtil;
import org.makumba.providers.query.mql.FunctionCall;
import org.makumba.providers.query.mql.HqlASTFactory;
import org.makumba.providers.query.mql.HqlParser;
import org.makumba.providers.query.mql.MqlNode;
import org.makumba.providers.query.mql.MqlQueryAnalysis;
import org.makumba.providers.query.mql.MqlQueryAnalysisProvider;
import org.makumba.providers.query.mql.MqlSqlWalker;
import org.makumba.providers.query.mql.MqlTreePrinter;
import org.makumba.providers.query.mql.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionInliner {
    private String query;
    private MqlTreePrinter printer;
    private HqlASTFactory fact = new HqlASTFactory();
    private List<String> parameterOrder = new ArrayList<String>();
    private MakumbaDumpASTVisitor v = new MakumbaDumpASTVisitor(false);
    private int labelCounter = 0;
    private Vector<String> generatedLabels = new Vector();
    private int parameterNumber = 0;

    public FunctionInliner(String query, QueryAnalysisProvider qp) {
        this.query = query;
        this.printer = new MqlTreePrinter(qp);
    }

    public static String inlineQuery(String query, QueryAnalysisProvider qp) {
        FunctionInliner inliner = new FunctionInliner(query, qp);
        return inliner.inline(query, qp);
    }

    private String inline(String query, QueryAnalysisProvider qp) {
        String originalQuery = query;
        if (qp instanceof MqlQueryAnalysisProvider) {
            if (query.startsWith("###")) {
                query = query.substring(query.indexOf(35, 3) + 3);
            }
            if ((query = MqlQueryAnalysis.preProcess(query)).toLowerCase().indexOf("from") == -1) {
                query = query + " FROM org.makumba.db.makumba.Catalog c";
            }
        }
        HqlParser parser = null;
        try {
            parser = HqlParser.getInstance(query);
            parser.statement();
        }
        catch (Throwable t) {
            this.doThrow(t, parser != null ? parser.getAST() : null, query);
        }
        this.doThrow(parser.error, parser.getAST(), query);
        AST ast = parser.getAST();
        if (qp instanceof MqlQueryAnalysisProvider) {
            MqlQueryAnalysisProvider.transformOQLParameters(ast, this.parameterOrder);
            MqlQueryAnalysisProvider.transformOQL(ast);
        }
        boolean inlined = false;
        try {
            inlined = this.inline(ast, true);
        }
        catch (Throwable t) {
            this.doThrow(t, ast, query);
        }
        if (!inlined) {
            return originalQuery;
        }
        String res = this.printer.printTree(ast);
        return res;
    }

    protected void doThrow(Throwable t, AST debugTree, String query) {
        RecognitionException re;
        if (t == null) {
            return;
        }
        if (t instanceof RuntimeException) {
            t.printStackTrace();
            throw (RuntimeException)t;
        }
        String errorLocation = "";
        String errorLocationNumber = "";
        if (t instanceof RecognitionException && (re = (RecognitionException)t).getColumn() > 0) {
            errorLocationNumber = " column " + re.getColumn() + " of ";
            StringBuffer sb = new StringBuffer();
            sb.append("\r\n");
            for (int i = 0; i < re.getColumn(); ++i) {
                sb.append(' ');
            }
            sb.append('^');
            errorLocation = sb.toString();
        }
        throw new OQLParseError("\r\nin " + errorLocationNumber + " query (during inlining of functions):\r\n" + query + errorLocation + errorLocation + errorLocation, t);
    }

    private boolean inline(AST ast, boolean root) throws Throwable {
        boolean inlined = false;
        ArrayList<MethodCall> methodCalls = this.findMethodCalls(ast, ast, null, null, null, false, new ArrayList<MethodCall>());
        if (methodCalls.size() == 0) {
            return false;
        }
        MqlSqlWalker mqlAnalyzer = new MqlSqlWalker(this.printer.printTree(ast), null, true, true, true);
        try {
            mqlAnalyzer.statement(ast);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("in AST");
            this.v.visit(ast);
        }
        if (mqlAnalyzer.error != null) {
            mqlAnalyzer.error.printStackTrace();
            throw new Throwable(mqlAnalyzer.error);
        }
        if (mqlAnalyzer.orderedFunctionCalls.isEmpty()) {
            return false;
        }
        LinkedHashMap<String, FunctionCall> orderedFunctionCalls = new LinkedHashMap<String, FunctionCall>();
        ArrayList<FunctionCall> f = new ArrayList<FunctionCall>();
        for (String key : mqlAnalyzer.orderedFunctionCalls.keySet()) {
            FunctionCall c = mqlAnalyzer.orderedFunctionCalls.get(key);
            if (c.isFunctionArgument()) {
                f.add(c);
                mqlAnalyzer.orderedFunctionCalls.remove(c);
                continue;
            }
            orderedFunctionCalls.put(key, c);
            if (f.isEmpty()) continue;
            for (int i = f.size() - 1; i >= 0; --i) {
                orderedFunctionCalls.put(((FunctionCall)f.get(i)).getKey(), (FunctionCall)f.get(i));
            }
        }
        mqlAnalyzer.orderedFunctionCalls = orderedFunctionCalls;
        int index = 0;
        for (FunctionCall c : mqlAnalyzer.orderedFunctionCalls.values()) {
            if (c.isFunctionArgument() || c.isMQLFunction()) {
                ++index;
                continue;
            }
            inlined = true;
            if (c.isActorFunction()) {
                this.processActorFunction(c, ast, methodCalls.get(index));
            } else {
                AST queryFragmentTree = this.fact.dupTree(c.getFunction().getParsedQueryFragment());
                ArrayList<String> parameterOrder = new ArrayList<String>();
                MqlQueryAnalysisProvider.transformOQLParameters(queryFragmentTree, parameterOrder);
                MqlQueryAnalysisProvider.transformOQL(queryFragmentTree);
                this.replaceArgsAndThis(queryFragmentTree, queryFragmentTree, c, null, null, mqlAnalyzer, false, null, null);
                this.inline(queryFragmentTree, false);
                this.replaceMethodCall(methodCalls.get(index), this.fact.dupTree(queryFragmentTree), methodCalls, c);
            }
            ++index;
        }
        Hashtable<String, String> usedLabels = new Hashtable<String, String>();
        this.collectUsedLabels(ast, usedLabels);
        AST parent = null;
        for (AST originalRange = this.findFrom(ast).getFirstChild(); originalRange != null; originalRange = originalRange.getNextSibling()) {
            String path = this.getPath(originalRange.getFirstChild().getNextSibling());
            if (!usedLabels.containsKey(path)) {
                if (parent == null) continue;
                parent.setNextSibling(originalRange.getNextSibling());
                continue;
            }
            parent = originalRange;
        }
        return inlined;
    }

    private void replaceArgsAndThis(AST tree, AST root, FunctionCall c, FunctionCall parentCall, AST parent, MqlSqlWalker mqlAnalyzer, boolean firstChild, String lastAlias, AST currentFrom) throws Throwable {
        int providedArgs;
        int expectedArgs;
        if (tree == null) {
            return;
        }
        if (tree == root && (expectedArgs = c.getFunction().getParameters().getFieldNames().size()) != (providedArgs = c.getOrderedArguments().size())) {
            throw new OQLParseError("Function '" + c.getFunction().toString() + "' is expecting " + expectedArgs + " arguments, but " + providedArgs + " were provided");
        }
        if (lastAlias == null) {
            AST range = this.findFrom((AST)tree).getFirstChild();
            Object l = range.getFirstChild();
            Object a = l.getNextSibling();
            if (a != null && a.getText().equals("makumbaGeneratedAlias")) {
                String path = c.getPath();
                if (path.indexOf(".") > -1) {
                    l = ASTUtil.makeNode(120, c.getParentType().getName());
                    a = ASTUtil.makeNode(69, path.substring(0, path.indexOf(".")));
                    range.setFirstChild(l);
                    l.setNextSibling(a);
                    if (lastAlias == null) {
                        lastAlias = this.expandRangeElement(c.getPath(), (AST)a, range);
                    }
                    path = path.substring(0, path.indexOf("."));
                } else {
                    lastAlias = c.getPath();
                    a.setText(c.getPath());
                }
            } else {
                lastAlias = a.getText();
            }
        }
        switch (tree.getType()) {
            case 22: {
                currentFrom = tree;
                break;
            }
            case 120: {
                boolean isParameter;
                FieldDefinition argument = c.getFunction().getParameters().getFieldDefinition(tree.getText());
                if (tree.getText().equals("this")) {
                    if (c.getPath().indexOf(".") > -1 && lastAlias != null) {
                        tree.setText(lastAlias);
                        break;
                    }
                    tree.setText(c.getPath());
                    break;
                }
                if (argument == null) break;
                int argumentIndex = c.getFunction().getParameters().getFieldNames().indexOf(tree.getText());
                MqlNode arg = c.getOrderedArguments().get(argumentIndex);
                boolean bl = isParameter = arg.getType() == 142 || arg.getType() == 117;
                if (arg.getText().startsWith("methodCallPlaceholder_")) {
                    this.replaceFunctionArgument(root, c, parent, mqlAnalyzer, firstChild, currentFrom, argument, arg);
                    break;
                }
                Node n = null;
                if (isParameter) {
                    n = ASTUtil.makeNode(116, ":");
                    Node paramChild = ASTUtil.makeNode(120, arg.getOriginalText());
                    n.setFirstChild((AST)paramChild);
                    n.setNextSibling(tree.getNextSibling());
                    n.setCol(tree.getColumn());
                    n.setLine(tree.getLine());
                } else if (!isParameter) {
                    MqlNode type = arg;
                    this.checkArgumentType(argument, type, false);
                    n = ASTUtil.makeNode(arg.getType(), arg.getText());
                    n.setFirstChild(arg.getFirstChild());
                    n.setNextSibling(tree.getNextSibling());
                    n.setCol(tree.getColumn());
                    n.setLine(tree.getLine());
                }
                tree = n;
                if (parent == null) break;
                if (firstChild) {
                    parent.setFirstChild((AST)n);
                    break;
                }
                parent.setNextSibling((AST)n);
            }
        }
        this.replaceArgsAndThis(tree.getFirstChild(), root, c, parentCall, (AST)tree, mqlAnalyzer, true, lastAlias, currentFrom);
        this.replaceArgsAndThis(tree.getNextSibling(), root, c, parentCall, (AST)tree, mqlAnalyzer, false, lastAlias, currentFrom);
    }

    private void replaceFunctionArgument(AST root, FunctionCall c, AST parent, MqlSqlWalker mqlAnalyzer, boolean firstChild, AST currentFrom, FieldDefinition argument, MqlNode arg) throws Throwable {
        String key = arg.getText().substring("methodCallPlaceholder_".length());
        FunctionCall cArg = mqlAnalyzer.orderedFunctionCalls.get(key);
        AST inlinedFunction = this.inlineArgument(cArg, mqlAnalyzer, c);
        AST inlinedFunctionType = this.fact.dupTree(inlinedFunction);
        AST select = this.findSelect(inlinedFunctionType);
        AST content = select.getFirstChild();
        AST last = null;
        String projectionLabel = "_mak_expr_";
        if (content.getType() != 7) {
            Node as = ASTUtil.makeNode(7, "as");
            as.setFirstChild(content);
            Node expr = ASTUtil.makeNode(120, projectionLabel);
            last = ASTUtil.getLastChild(select);
            last.setNextSibling((AST)expr);
            select.setFirstChild((AST)as);
        } else {
            last = ASTUtil.getLastChild(content);
            projectionLabel = last.getText();
        }
        MqlSqlWalker analyzer = new MqlSqlWalker(this.query, null, true, true, true);
        analyzer.statement(inlinedFunctionType);
        if (mqlAnalyzer.error != null) {
            throw new Throwable(mqlAnalyzer.error);
        }
        MqlNode t = analyzer.rootContext.projectionLabelSearch.get(projectionLabel);
        this.checkArgumentType(argument, t, true);
        AST where = this.findWhere(root);
        MethodCall mc = new MethodCall(firstChild, root, parent, currentFrom, where);
        this.replaceMethodCall(mc, inlinedFunction, null, null);
    }

    private void checkArgumentType(FieldDefinition argument, MqlNode type, boolean functionCall) throws OQLParseError {
        if (type.getType() == 116) {
            return;
        }
        if (!argument.isAssignableFrom(type.getMakType())) {
            StringBuffer sb = new StringBuffer();
            sb.append("\r\n");
            for (int i = 0; i < type.getColumn(); ++i) {
                sb.append(' ');
            }
            sb.append('^');
            String errorLocation = sb.toString();
            String error = "Invalid argument type: expecting " + argument.getType();
            error = functionCall ? error + ", but argument is of type " + type.getMakType().getType() : error + ", argument '" + type.getText() + "' is of type " + type.getMakType().getType();
            throw new OQLParseError(error + "\r\nin query:\r\n" + this.query + errorLocation + errorLocation + errorLocation);
        }
    }

    private String expandRangeElement(String path, AST tree, AST range) {
        String lastLabel = "";
        StringTokenizer tk = new StringTokenizer(path, ".");
        while (tk.hasMoreElements()) {
            String a = tk.nextToken();
            String b = tk.nextToken();
            String label = this.createLabel();
            Node r = ASTUtil.makeNode(84, "RANGE");
            Node dot = ASTUtil.makeNode(15, ".");
            Node aNode = ASTUtil.makeNode(120, a);
            Node bNode = ASTUtil.makeNode(120, b);
            Node labelNode = ASTUtil.makeNode(69, label);
            r.setFirstChild((AST)dot);
            dot.setFirstChild((AST)aNode);
            aNode.setNextSibling((AST)bNode);
            dot.setNextSibling((AST)labelNode);
            range.setNextSibling((AST)r);
            lastLabel = label;
        }
        return lastLabel;
    }

    private AST inlineArgument(FunctionCall functionCall, MqlSqlWalker mqlAnalyzer, FunctionCall parentCall) throws Throwable {
        AST i = this.fact.dupTree(functionCall.getFunction().getParsedQueryFragment());
        this.replaceArgsAndThis(i, i, functionCall, parentCall, null, null, false, null, null);
        return i;
    }

    private void processActorFunction(FunctionCall c, AST queryFragmentTree, MethodCall methodCall) {
        if (methodCall.getParent().getType() == 15 && methodCall.isFirstChild()) {
            String type = this.getActorType(c);
            Node a = ASTUtil.makeNode(83, "query");
            a.setFirstChild((AST)ASTUtil.makeNode(86, "SELECT_FROM"));
            a.getFirstChild().setFirstChild((AST)ASTUtil.makeNode(22, "FROM"));
            a.getFirstChild().getFirstChild().setFirstChild((AST)ASTUtil.makeNode(84, "RANGE"));
            a.getFirstChild().getFirstChild().getFirstChild().setFirstChild((AST)ASTUtil.makeNode(120, type));
            String alias = this.createLabel();
            a.getFirstChild().getFirstChild().getFirstChild().getFirstChild().setNextSibling((AST)ASTUtil.makeNode(69, alias));
            a.getFirstChild().getFirstChild().setNextSibling((AST)ASTUtil.makeNode(45, "SELECT"));
            a.getFirstChild().getFirstChild().getNextSibling().setFirstChild((AST)ASTUtil.makeNode(120, alias));
            a.getFirstChild().setNextSibling((AST)ASTUtil.makeNode(53, "WHERE"));
            a.getFirstChild().getNextSibling().setFirstChild((AST)ASTUtil.makeNode(97, "="));
            a.getFirstChild().getNextSibling().getFirstChild().setFirstChild((AST)ASTUtil.makeNode(120, alias));
            a.getFirstChild().getNextSibling().getFirstChild().getFirstChild().setNextSibling((AST)ASTUtil.makeNode(116, ":"));
            a.getFirstChild().getNextSibling().getFirstChild().getFirstChild().getNextSibling().setFirstChild((AST)ASTUtil.makeNode(120, "actor_" + type.replaceAll("\\.", "_") + "###" + this.parameterNumber()));
            this.replaceMethodCall(methodCall, (AST)a, null, null);
        } else {
            this.v.visit(methodCall.getRoot());
            String type = this.getActorType(c);
            Node actorParamNode = ASTUtil.makeNode(116, ":");
            Node actorParamChild = ASTUtil.makeNode(120, "actor_" + type.replaceAll("\\.", "_") + "###" + this.parameterNumber());
            actorParamNode.setFirstChild((AST)actorParamChild);
            methodCall.replace((AST)actorParamNode);
        }
    }

    private String getActorType(FunctionCall c) {
        String type = "";
        type = c.getOrderedArguments().size() == 0 ? c.getParentType().getName() : c.getOrderedArguments().firstElement().getText();
        return type;
    }

    private void replaceMethodCall(MethodCall methodCall, AST inlinedFunction, List<MethodCall> methodCalls, FunctionCall functionCall) {
        AST select = this.findSelectContent(inlinedFunction);
        if (select.getType() != 83) {
            AST additionalWhere;
            AST additionalFrom = this.findFrom(inlinedFunction);
            if (additionalFrom != null) {
                if (functionCall != null && functionCall.getPath() != null) {
                    String label = functionCall.getPath().substring(0, functionCall.getPath().indexOf(".") > 0 ? functionCall.getPath().indexOf(".") : functionCall.getPath().length());
                    if (methodCall.getWhere() != null) {
                        boolean hasConstraint = false;
                        this.findIdentifier(methodCall.getWhere(), label, hasConstraint);
                        if (hasConstraint) {
                            this.join(methodCall.getFrom(), this.fact.dupTree(additionalFrom), inlinedFunction, null);
                        }
                    } else {
                        this.join(methodCall.getFrom(), this.fact.dupTree(additionalFrom), inlinedFunction, label);
                    }
                } else {
                    this.join(methodCall.getFrom(), this.fact.dupTree(additionalFrom), inlinedFunction, null);
                }
            }
            if ((additionalWhere = this.findWhere(inlinedFunction)) != null) {
                additionalWhere.setNextSibling(null);
                if (methodCall.getWhere() != null) {
                    Node and = ASTUtil.makeNode(6, "and");
                    and.setFirstChild(methodCall.getWhere().getFirstChild());
                    and.getFirstChild().setNextSibling(additionalWhere.getFirstChild());
                    methodCall.getWhere().setFirstChild((AST)and);
                } else {
                    ASTUtil.getLastChild(methodCall.getRoot()).setNextSibling(additionalWhere);
                }
            }
        }
        if (methodCalls != null) {
            for (MethodCall m : methodCalls) {
                AST currentCall = methodCall.isFirstChild() ? methodCall.getParent().getFirstChild() : methodCall.getParent().getNextSibling();
                if (!m.getParent().equals(currentCall)) continue;
                m.parent = select;
            }
        }
        methodCall.replace(select);
    }

    private void join(AST from, AST additionalFrom, AST tree, String labelToReuse) {
        Hashtable<String, AST> existingLabels = this.getLabels(from);
        Hashtable<String, AST> newLabels = this.getLabels(additionalFrom);
        Hashtable<String, String> collisions = new Hashtable<String, String>();
        for (String l : newLabels.keySet()) {
            if (existingLabels.containsKey(l) && !l.equals(labelToReuse)) {
                String r = this.createLabel();
                collisions.put(l, r);
                newLabels.get(l).getFirstChild().getNextSibling().setText(r);
            } else if (existingLabels.containsKey(l) && l.equals(labelToReuse)) {
                AST additionalRange;
                AST parent = additionalRange = additionalFrom.getFirstChild();
                while (!additionalRange.getFirstChild().getNextSibling().getText().equals(newLabels.get(l).getFirstChild().getNextSibling().getText())) {
                    parent = additionalRange = additionalRange.getNextSibling();
                }
                if (additionalRange.getNextSibling() != null && additionalRange != parent) {
                    parent.setNextSibling(additionalRange.getNextSibling());
                } else if (additionalRange.getNextSibling() != null && additionalRange == parent) {
                    additionalFrom.setFirstChild(additionalRange.getNextSibling());
                } else {
                    additionalFrom.setFirstChild(null);
                }
            }
            for (String c : collisions.keySet()) {
                AST type = newLabels.get(l).getFirstChild();
                String path = this.getPath(type);
                if (!path.startsWith(c + ".")) continue;
                String t = path;
                t = t.substring(c.length());
                t = collisions.get(c) + t;
                newLabels.get(l).setFirstChild(this.constructPath(t));
                newLabels.get(l).getFirstChild().setNextSibling(type.getNextSibling());
            }
        }
        this.replaceLabels(tree, collisions);
        AST endFrom = ASTUtil.getLastChild(from);
        if (additionalFrom.getFirstChild() != null) {
            endFrom.setNextSibling(additionalFrom.getFirstChild());
        }
    }

    private void replaceLabels(AST ast, Hashtable<String, String> collisions) {
        if (ast == null) {
            return;
        }
        if (ast.getType() == 22) {
            this.replaceLabels(ast.getNextSibling(), collisions);
        }
        if (ast.getType() == 120) {
            for (String c : collisions.keySet()) {
                String path = this.getPath(ast);
                if (!path.startsWith(c + ".") && !path.equals(c)) continue;
                String t = ast.getText();
                t = t.substring(c.length());
                t = collisions.get(c) + t;
                ast = this.constructPath(t);
            }
        }
        this.replaceLabels(ast.getFirstChild(), collisions);
        this.replaceLabels(ast.getNextSibling(), collisions);
    }

    private void collectUsedLabels(AST ast, Hashtable<String, String> usedLabels) {
        if (ast == null) {
            return;
        }
        if (ast.getType() == 22) {
            this.collectUsedLabels(ast.getNextSibling(), usedLabels);
        }
        if (ast.getType() == 120) {
            usedLabels.put(ast.getText(), "");
        }
        this.collectUsedLabels(ast.getFirstChild(), usedLabels);
        this.collectUsedLabels(ast.getNextSibling(), usedLabels);
    }

    private Hashtable<String, AST> getLabels(AST from) {
        Hashtable<String, AST> labels = new Hashtable<String, AST>();
        for (AST range = from.getFirstChild(); range != null; range = range.getNextSibling()) {
            String b = range.getFirstChild().getNextSibling().getText();
            labels.put(b, range);
        }
        return labels;
    }

    private void findIdentifier(AST tree, String identifier, boolean found) {
        if (tree == null) {
            return;
        }
        if (tree.getType() == 120 && tree.getText().equals(identifier)) {
            found = true;
            return;
        }
        this.findIdentifier(tree.getFirstChild(), identifier, found);
        this.findIdentifier(tree.getNextSibling(), identifier, found);
    }

    private AST findSelectContent(AST tree) {
        AST c = this.findSelect(tree);
        c = c.getFirstChild().getType() == 7 ? c.getFirstChild().getFirstChild() : c.getFirstChild();
        c.setNextSibling(null);
        return c;
    }

    private AST findSelect(AST tree) {
        AST select_from = ASTUtil.findTypeInChildren(tree, 86);
        return ASTUtil.findTypeInChildren(select_from, 45);
    }

    private AST findFrom(AST tree) {
        AST select_from = ASTUtil.findTypeInChildren(tree, 86);
        if (select_from == null && tree.getType() == 86) {
            select_from = tree;
        } else if (select_from == null) {
            return null;
        }
        AST from = select_from.getFirstChild();
        return from;
    }

    private AST findWhere(AST tree) {
        return ASTUtil.findTypeInChildren(tree, 53);
    }

    private ArrayList<MethodCall> findMethodCalls(AST tree, AST root, AST parent, AST currentFrom, AST currentWhere, boolean firstChild, ArrayList<MethodCall> result) {
        if (tree == null) {
            return null;
        }
        if (parent == null) {
            currentWhere = this.findWhere(tree);
            currentFrom = this.findFrom(tree);
        }
        if (tree.getType() == 22) {
            currentFrom = tree;
        }
        if (tree.getType() == 78) {
            result.add(new MethodCall(firstChild, root, parent, currentFrom, currentWhere));
        }
        parent = tree;
        this.findMethodCalls(tree.getFirstChild(), root, parent, currentFrom, currentWhere, true, result);
        this.findMethodCalls(tree.getNextSibling(), root, parent, currentFrom, currentWhere, false, result);
        return result;
    }

    private String getPath(AST t) {
        if (t.getType() == 15) {
            return this.constructPath(t);
        }
        return t.getText();
    }

    private String constructPath(AST type) {
        String a_text = "";
        String b_text = "";
        AST a = type.getFirstChild();
        AST b = a.getNextSibling();
        a_text = a.getType() == 15 ? this.constructPath(a) : a.getText();
        b_text = b.getType() == 15 ? this.constructPath(b) : b.getText();
        return a_text + "." + b_text;
    }

    private AST constructPath(String path) {
        if (path.indexOf(".") > -1) {
            String a = path.substring(0, path.indexOf("."));
            AST d = ASTUtil.create(this.fact, 15, ".");
            AST i = ASTUtil.create(this.fact, 120, a);
            d.setFirstChild(i);
            i.setNextSibling(this.constructPath(path.substring(path.indexOf(".") + 1)));
            return d;
        }
        return ASTUtil.create(this.fact, 120, path);
    }

    public String createLabel() {
        String l = "_x_gen_" + this.labelCounter++;
        this.generatedLabels.add(l);
        return l;
    }

    private int parameterNumber() {
        return this.parameterNumber++;
    }

    class MethodCall {
        private boolean firstChild;
        private AST root;
        private AST parent;
        private AST from;
        private AST where;

        public AST getRoot() {
            return this.root;
        }

        public AST getFrom() {
            return this.from;
        }

        public AST getWhere() {
            return this.where;
        }

        public AST getParent() {
            return this.parent;
        }

        public boolean isFirstChild() {
            return this.firstChild;
        }

        public MethodCall(boolean firstChild, AST root, AST parent, AST from, AST where) {
            this.firstChild = firstChild;
            this.parent = parent;
            this.from = from;
            this.where = where;
            this.root = root;
        }

        public void replace(AST node) {
            if (this.firstChild) {
                node.setNextSibling(this.parent.getFirstChild().getNextSibling());
                this.parent.setFirstChild(node);
            } else {
                node.setNextSibling(this.parent.getNextSibling().getNextSibling());
                this.parent.setNextSibling(node);
            }
        }

        public String toString() {
            return "MethodCall [firstChild=" + this.firstChild + ", root=" + this.root + ", from=" + this.from + ", where=" + this.where + ", parent=" + this.parent + "]";
        }
    }
}

