/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.WriterFactory;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.ClassUseMapper;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.doclets.internal.toolkit.util.MessageRetriever;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import net.sourceforge.xhtmldoclet.writers.WriterFactoryImpl;

public class Config
extends Configuration {
    private static final Config INSTANCE = new Config();
    private static final String PROPERTIES_LOCATION = "net.sourceforge.xhtmldoclet.resources.doclet";
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public String ext = ".html";
    public String header = "";
    public String packagesheader = "";
    public String footer = "";
    public String doctitle = "";
    public String windowtitle = "";
    public String bottom = "";
    public String helpfile = "";
    public String stylesheetfile = "";
    public boolean nohelp = false;
    private boolean noindex = false;
    public boolean plainindex = false;
    public boolean splitindex = false;
    public boolean createindex = true;
    public boolean use = false;
    public boolean createtree = true;
    public boolean nodeprecatedlist = false;
    private boolean nonavbar = false;
    private boolean nooverview = false;
    private boolean overview = false;
    public boolean createoverview = false;
    public int constantListMaxPackageComponents = 2;
    public final MessageRetriever standardmessage;
    public IndexBuilder indexBuilder;
    public String topFile = "";
    public String rootIndexPage = "";
    public ClassDoc currentClass = null;
    public PackageDoc currentPkg = null;
    public ClassTree classTree = null;
    public List classList = null;
    public ClassUseMapper classUseMapper;
    private ResourceBundle messageRB;
    private final List<String> optionsLength1 = new ArrayList<String>(Arrays.asList("-help", "-nodeprecatedlist", "-noindex", "-notree", "-nohelp", "-splitindex", "-serialwarn", "-use", "-nonavbar", "-nooverview"));
    private final List<String> optionsLength2 = new ArrayList<String>(Arrays.asList("-footer", "-header", "-packagesheader", "-doctitle", "-windowtitle", "-bottom", "-helpfile", "-stylesheetfile", "-charset", "-overview"));

    protected Config() {
        this.standardmessage = new MessageRetriever((Configuration)this, PROPERTIES_LOCATION);
        try {
            this.messageRB = ResourceBundle.getBundle(PROPERTIES_LOCATION);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource (net.sourceforge.xhtmldoclet.resources.doclet) for javadoc doclets is missing.");
        }
    }

    public static Config getInstance() {
        return INSTANCE;
    }

    public String getDocletSpecificBuildDate() {
        return this.readFromResourceFile("build_date.txt").trim();
    }

    public String getDocletSpecificRevision() {
        String revision = this.readFromResourceFile("revision.txt").trim();
        if (revision.contains(":")) {
            return revision.substring(revision.indexOf(":") + 1);
        }
        return revision;
    }

    private String readFromResourceFile(String filename) {
        StringBuffer buffer = new StringBuffer();
        try {
            InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("resources/" + filename));
            while (reader.ready()) {
                buffer.append((char)reader.read());
            }
        }
        catch (IOException exc) {
            return null;
        }
        return buffer.toString();
    }

    public void setSpecificDocletOptions(String[][] options) {
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-footer")) {
                this.footer = os[1];
                continue;
            }
            if (opt.equals("-header")) {
                this.header = os[1];
                continue;
            }
            if (opt.equals("-packagesheader")) {
                this.packagesheader = os[1];
                continue;
            }
            if (opt.equals("-doctitle")) {
                this.doctitle = os[1];
                continue;
            }
            if (opt.equals("-windowtitle")) {
                this.windowtitle = os[1];
                continue;
            }
            if (opt.equals("-bottom")) {
                this.bottom = os[1];
                continue;
            }
            if (opt.equals("-helpfile")) {
                this.helpfile = os[1];
                continue;
            }
            if (opt.equals("-stylesheetfile")) {
                this.stylesheetfile = os[1];
                continue;
            }
            if (opt.equals("-charset")) {
                this.charset = os[1];
                continue;
            }
            if (opt.equals("-nohelp")) {
                this.nohelp = true;
                continue;
            }
            if (opt.equals("-splitindex")) {
                this.splitindex = true;
                continue;
            }
            if (opt.equals("-noindex")) {
                this.createindex = false;
                continue;
            }
            if (opt.equals("-use")) {
                this.use = true;
                continue;
            }
            if (opt.equals("-notree")) {
                this.createtree = false;
                continue;
            }
            if (opt.equals("-nodeprecatedlist")) {
                this.nodeprecatedlist = true;
                continue;
            }
            if (opt.equals("-nosince")) {
                this.nosince = true;
                continue;
            }
            if (opt.equals("-nooverview")) {
                this.nooverview = true;
                continue;
            }
            if (!opt.equals("-overview")) continue;
            this.overview = true;
        }
        if (this.root.specifiedClasses().length > 0) {
            HashMap<String, PackageDoc> map = new HashMap<String, PackageDoc>();
            ClassDoc[] classes = this.root.classes();
            for (int i = 0; i < classes.length; ++i) {
                PackageDoc pd = classes[i].containingPackage();
                if (map.containsKey(pd.name())) continue;
                map.put(pd.name(), pd);
            }
        }
        this.setCreateOverview();
        this.setTopFile(this.root);
    }

    public int optionLength(String option) {
        int optionLength = super.optionLength(option);
        if (option.equals("-help")) {
            System.out.println(this.getText("doclet.usage"));
        }
        if (optionLength > 0) {
            return optionLength;
        }
        optionLength = this.optionsLength2.contains(option = option.toLowerCase()) ? 2 : (this.optionsLength1.contains(option) ? 1 : 0);
        return optionLength;
    }

    public boolean validOptions(String[][] options, DocErrorReporter reporter) {
        boolean helpfile = false;
        if (!this.generalValidOptions(options, reporter)) {
            return false;
        }
        for (int oi = 0; oi < options.length; ++oi) {
            String[] os = options[oi];
            String opt = os[0].toLowerCase();
            if (opt.equals("-nohelp")) {
                if (helpfile) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-nohelp", "-helpfile"));
                    return false;
                }
                this.nohelp = true;
                continue;
            }
            if (opt.equals("-helpfile")) {
                if (this.nohelp) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-helpfile", "-nohelp"));
                    return false;
                }
                if (helpfile) {
                    reporter.printError(this.getText("doclet.Option_reuse", "-helpfile"));
                    return false;
                }
                File help = new File(os[1]);
                if (!help.exists()) {
                    reporter.printError(this.getText("doclet.File_not_found", os[1]));
                    return false;
                }
                helpfile = true;
                continue;
            }
            if (opt.equals("-overview")) {
                if (this.nooverview) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-overview", "-nooverview"));
                    return false;
                }
                if (this.overview) {
                    reporter.printError(this.getText("doclet.Option_reuse", "-overview"));
                    return false;
                }
                this.overview = true;
                continue;
            }
            if (opt.equals("-nooverview")) {
                if (this.overview) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-nooverview", "-overview"));
                    return false;
                }
                this.nooverview = true;
                continue;
            }
            if (opt.equals("-plainindex")) {
                if (this.noindex) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-plainindex", "-noindex"));
                    return false;
                }
                this.plainindex = true;
                continue;
            }
            if (opt.equals("-splitindex")) {
                if (this.noindex) {
                    reporter.printError(this.getText("doclet.Option_conflict", "-splitindex", "-noindex"));
                    return false;
                }
                this.splitindex = true;
                continue;
            }
            if (!opt.equals("-noindex")) continue;
            if (this.splitindex) {
                reporter.printError(this.getText("doclet.Option_conflict", "-noindex", "-splitindex"));
                return false;
            }
            if (this.plainindex) {
                reporter.printError(this.getText("doclet.Option_conflict", "-noindex", "-plainindex"));
                return false;
            }
            this.noindex = true;
        }
        return true;
    }

    public MessageRetriever getDocletSpecificMsg() {
        return this.standardmessage;
    }

    protected void setTopFile(RootDoc root) {
        if (!this.checkForDeprecation(root)) {
            return;
        }
        this.classList = Arrays.asList(root.classes());
        if (this.createoverview) {
            this.topFile = "overview-summary.html";
        } else if (this.packages.length == 1 && this.packages[0].name().equals("")) {
            if (root.classes().length > 0) {
                Object[] classarr = root.classes();
                Arrays.sort(classarr);
                ClassDoc cd = this.getValidClass((ClassDoc[])classarr);
                this.topFile = DirectoryManager.getPathToClass((ClassDoc)cd);
            }
        } else {
            this.topFile = DirectoryManager.getPathToPackage((PackageDoc)this.packages[0], (String)"package-summary.html");
        }
    }

    protected ClassDoc getValidClass(ClassDoc[] classArray) {
        ClassDoc firstValidClass = null;
        if (!this.nodeprecated) {
            firstValidClass = classArray[0];
        } else {
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i].tags("deprecated").length != 0) continue;
                firstValidClass = classArray[i];
                break;
            }
        }
        return firstValidClass;
    }

    protected boolean checkForDeprecation(RootDoc root) {
        ClassDoc[] classarr = root.classes();
        for (int i = 0; i < classarr.length; ++i) {
            if (!this.isGeneratedDoc((Doc)classarr[i])) continue;
            return true;
        }
        return false;
    }

    protected void setCreateOverview() {
        if ((this.overview || this.packages.length > 1) && !this.nooverview) {
            this.createoverview = true;
        }
    }

    public WriterFactory getWriterFactory() {
        return WriterFactoryImpl.getInstance();
    }

    public Comparator getMemberComparator() {
        return null;
    }

    public String propertyText(String key, Object ... values) {
        if (key == null) {
            return null;
        }
        return MessageFormat.format(this.messageRB.getString(key), values);
    }

    public JarFile enclosingJarFile() {
        try {
            String thisClass = "/" + ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".class";
            URL jarUrl = ((Object)((Object)this)).getClass().getResource(thisClass);
            String stringForm = jarUrl.toString();
            int endIdx = stringForm.indexOf("!/");
            if (endIdx == -1) {
                throw new FileNotFoundException("Could not locate enclosing jar: !/ not found in URL");
            }
            String fileNamePart = stringForm.substring("jar:file:".length(), endIdx);
            String unescaped = URLDecoder.decode(fileNamePart, System.getProperty("file.encoding"));
            File file = new File(unescaped);
            if (!file.exists()) {
                throw new FileNotFoundException("Could not locate enclosing jar: " + file + " not found");
            }
            return new JarFile(file);
        }
        catch (FileNotFoundException exc) {
            System.out.println(exc.getMessage());
        }
        catch (IOException exc) {
            System.out.println(exc.getMessage());
        }
        return null;
    }
}

