/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.PackageDoc;
import java.io.IOException;
import java.util.Arrays;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.Doclet;

public final class AllPackages
extends AbstractPageWriter {
    private PackageDoc[] packages;

    public static void generateAllPackages() {
        String filename = "overview-frame" + AllPackages.CONF.ext;
        try {
            new AllPackages(filename);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private AllPackages(String filename) throws IOException {
        super(filename);
        this.pageType = "ALL_PACKAGES";
        this.packages = AllPackages.CONF.packages;
        this.windowTitle = CONF.propertyText("OverviewTitle", new Object[0]);
        String[] metakeywords = new String[]{this.windowTitle};
        if (AllPackages.CONF.doctitle.length() > 0) {
            metakeywords[0] = metakeywords[0] + ", " + AllPackages.CONF.doctitle;
        }
        this.printXhtmlHeader(metakeywords, false, null);
        this.println(this.open("h3") + this.linkToLabelHrefTarget(CONF.propertyText("AllPackages", new Object[0]), "overview-summary" + AllPackages.CONF.ext, "classFrame") + this.close("h3"));
        this.println(this.openDivWithClass("packages"));
        if (this.packages.length > 0) {
            Arrays.sort(this.packages);
            for (PackageDoc pkg : this.packages) {
                if (pkg == null) continue;
                String href = (pkg.name().length() > 0 ? this.pathToPackageFile(pkg, "") : "") + "package-summary" + AllPackages.CONF.ext;
                String label = pkg.name().length() > 0 ? pkg.name() : "&lt;unnamed package&gt;";
                this.println(this.linkToLabelHrefTarget(label, href, "classFrame") + this.empty("br"));
            }
        }
        this.println(this.close("div") + this.getComment("packages"));
        this.printXhtmlFooter();
        this.close();
    }
}

