/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.util.ClassUseMapper;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.AbstractXhtmlWriter;
import net.sourceforge.xhtmldoclet.Doclet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUse
extends AbstractPageWriter {
    private ClassDoc theClass;
    private ClassDoc prev;
    private ClassDoc next;
    private SortedSet<PackageDoc> pkgSet;
    private Set<PackageDoc> pkgsWithPackageAnnotations = null;
    private final Map<String, List<ProgramElementDoc>> pkgsWithClassAnnotations;
    private final Map<String, List<ProgramElementDoc>> pkgsWithClassTypeParameters;
    private final Map<String, List<ProgramElementDoc>> pkgsWithSubclasses;
    private final Map<String, List<ProgramElementDoc>> pkgsWithSubinterfaces;
    private final Map<String, List<ProgramElementDoc>> pkgsWithImplementingClasses;
    private final Map<String, List<ProgramElementDoc>> pkgsWithField;
    private final Map<String, List<ProgramElementDoc>> pkgsWithFieldAnnotations;
    private final Map<String, List<ProgramElementDoc>> pkgsWithFieldTypeParameters;
    private final Map<String, List<ProgramElementDoc>> pkgsWithConstructorAnnotations;
    private final Map<String, List<ProgramElementDoc>> pkgsWithConstructorParameterAnnotations;
    private final Map<String, List<ProgramElementDoc>> pkgsWithConstructorThrows;
    private final Map<String, List<ProgramElementDoc>> pkgsWithConstructorArgs;
    private final Map<String, List<ProgramElementDoc>> pkgsWithConstructorArgsTypeParameters;
    private final Map<String, List<ProgramElementDoc>> pkgsWithMethodAnnotations;
    private final Map<String, List<ProgramElementDoc>> pkgsWithMethodParameterAnnotations;
    private final Map<String, List<ProgramElementDoc>> pkgsWithMethodTypeParameters;
    private final Map<String, List<ProgramElementDoc>> pkgsWithMethodThrows;
    private final Map<String, List<ProgramElementDoc>> pkgsWithMethodArgs;
    private final Map<String, List<ProgramElementDoc>> pkgsWithMethodArgsTypeParameters;
    private final Map<String, List<ProgramElementDoc>> pkgsWithMethodReturn;
    private final Map<String, List<ProgramElementDoc>> pkgsWithMethodReturnTypeParameters;
    private ClassUseMapper mapper;

    public static void generateClassUse(ClassDoc classDoc, ClassDoc prevClass, ClassDoc nextClass) {
        String filename = classDoc.name() + ClassUse.CONF.ext;
        String path = DirectoryManager.getDirectoryPath((PackageDoc)classDoc.containingPackage()) + "class-use/";
        try {
            new ClassUse(filename, path, classDoc, prevClass, nextClass);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private ClassUse(String filename, String pathToFile, ClassDoc theClass, ClassDoc prevClass, ClassDoc nextClass) throws IOException {
        super(filename, pathToFile);
        this.mapper = ClassUse.CONF.classUseMapper;
        this.pageType = "CLASS_USE";
        ClassUse.CONF.currentPkg = theClass.containingPackage();
        this.theClass = theClass;
        this.prev = prevClass;
        this.next = nextClass;
        this.pkgSet = new TreeSet<PackageDoc>();
        this.pkgsWithClassTypeParameters = this.extractClassUse(this.mapper.classToClassTypeParam);
        this.pkgsWithClassAnnotations = this.extractClassUse(this.mapper.classToClassAnnotations);
        this.pkgsWithMethodTypeParameters = this.extractClassUse(this.mapper.classToExecMemberDocTypeParam);
        this.pkgsWithMethodArgsTypeParameters = this.extractClassUse(this.mapper.classToExecMemberDocArgTypeParam);
        this.pkgsWithFieldTypeParameters = this.extractClassUse(this.mapper.classToFieldDocTypeParam);
        this.pkgsWithFieldAnnotations = this.extractClassUse(this.mapper.annotationToFieldDoc);
        this.pkgsWithMethodReturnTypeParameters = this.extractClassUse(this.mapper.classToExecMemberDocReturnTypeParam);
        this.pkgsWithMethodAnnotations = this.extractClassUse(this.mapper.classToExecMemberDocAnnotations);
        this.pkgsWithMethodParameterAnnotations = this.extractClassUse(this.mapper.classToExecMemberDocParamAnnotation);
        this.pkgsWithSubclasses = this.extractClassUse(this.mapper.classToSubclass);
        this.pkgsWithSubinterfaces = this.extractClassUse(this.mapper.classToSubinterface);
        this.pkgsWithImplementingClasses = this.extractClassUse(this.mapper.classToImplementingClass);
        this.pkgsWithField = this.extractClassUse(this.mapper.classToField);
        this.pkgsWithMethodReturn = this.extractClassUse(this.mapper.classToMethodReturn);
        this.pkgsWithMethodArgs = this.extractClassUse(this.mapper.classToMethodArgs);
        this.pkgsWithMethodThrows = this.extractClassUse(this.mapper.classToMethodThrows);
        this.pkgsWithConstructorAnnotations = this.extractClassUse(this.mapper.classToConstructorAnnotations);
        this.pkgsWithConstructorParameterAnnotations = this.extractClassUse(this.mapper.classToConstructorParamAnnotation);
        this.pkgsWithConstructorArgs = this.extractClassUse(this.mapper.classToConstructorArgs);
        this.pkgsWithConstructorArgsTypeParameters = this.extractClassUse(this.mapper.classToConstructorDocArgTypeParam);
        this.pkgsWithConstructorThrows = this.extractClassUse(this.mapper.classToConstructorThrows);
        this.windowTitle = theClass.name();
        this.printXhtmlHeader();
        this.printEntityCaptionPackage((Doc)theClass, CONF.propertyText("use.Usage_of_0", this.classFlavor(theClass, true)), theClass.containingPackage().name());
        if (this.pkgSet.size() <= 0) {
            this.println(this.open("p") + CONF.propertyText("use.No_usage_of_0", theClass.qualifiedName() + this.close("p")));
        } else {
            if (ClassUse.CONF.packages.length > 1) {
                this.println(this.openDivWithID("Summaries"));
                this.generatePackageList();
                this.generatePackageAnnotationList();
                this.println(this.close("div") + this.getComment("Summaries"));
            }
            this.println(this.openDivWithID("Details"));
            this.generateClassList();
            this.println(this.close("div") + this.getComment("Details"));
        }
        this.printXhtmlFooter();
        this.close();
    }

    private void generatePackageList() {
        this.println(this.open("h2") + CONF.propertyText("use.Packages_that_use_0", (AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("a").add("href", "../" + this.theClass.name() + ClassUse.CONF.ext).getOpenTextClose(this.theClass.qualifiedName())) + this.close("h2"));
        this.println(this.open("table"));
        for (PackageDoc pkg : this.pkgSet) {
            String pkgName = pkg.name();
            this.println(this.open("tr"));
            this.println(this.open("td") + (AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("a").add("href", "#" + pkgName).getOpenTextClose(pkgName) + this.close("td"));
            this.println(this.open("td") + this.getCommentSummary((Doc)pkg) + this.close("td"));
            this.println(this.close("tr"));
        }
        this.println(this.close("table"));
    }

    private void generatePackageAnnotationList() {
        if (!this.theClass.isAnnotationType() || this.pkgsWithPackageAnnotations == null || this.pkgsWithPackageAnnotations.size() == 0) {
            return;
        }
        this.println(this.open("h2") + CONF.propertyText("use.PackageAnnotation", this.theClass.qualifiedName()) + this.close("h2"));
        for (PackageDoc pkg : this.pkgsWithPackageAnnotations) {
            System.out.println("****");
            this.println(pkg.name() + "<br />");
        }
    }

    private void generateClassList() {
        for (PackageDoc pkg : this.pkgSet) {
            this.println(this.open("h2 id=\"" + pkg.name() + "\"") + CONF.propertyText("use.Uses_in_0", this.linkToLabelHref(pkg.name(), "../" + this.hrefToDoc((Doc)pkg) + "package-summary" + ClassUse.CONF.ext)) + this.close("h2"));
            this.generateClassUse(pkg);
        }
    }

    private Map<String, List<ProgramElementDoc>> extractClassUse(Map usageMap) {
        List list = (List)usageMap.get(this.theClass.qualifiedName());
        if (list != null) {
            HashMap<String, List<ProgramElementDoc>> usingPackageMap = new HashMap<String, List<ProgramElementDoc>>();
            Collections.sort(list);
            for (ProgramElementDoc doc : list) {
                PackageDoc pkg = doc.containingPackage();
                this.pkgSet.add(pkg);
                ArrayList<ProgramElementDoc> inPkg = (ArrayList<ProgramElementDoc>)usingPackageMap.get(pkg.name());
                if (inPkg == null) {
                    inPkg = new ArrayList<ProgramElementDoc>();
                    usingPackageMap.put(pkg.name(), inPkg);
                }
                inPkg.add(doc);
            }
            return usingPackageMap;
        }
        return new HashMap<String, List<ProgramElementDoc>>();
    }

    private void generateClassUse(PackageDoc pkg) {
        String usingPackage = pkg.name();
        this.println("[class annotations]" + this.empty("br"));
        this.println("[class type parameter]" + this.empty("br"));
        this.println("[subclass]" + this.empty("br"));
        this.println("[subinterface]" + this.empty("br"));
        this.println("[implementing class]" + this.empty("br"));
        this.println("[fields]" + this.empty("br"));
        this.println("[field annotations]" + this.empty("br"));
        this.println("[field type parameter]" + this.empty("br"));
        this.println("[constructor annotations]" + this.empty("br"));
        this.println("[constructor parameter annotations]" + this.empty("br"));
        this.println("[constructor throws]" + this.empty("br"));
        this.println("[constructor args]" + this.empty("br"));
        this.println("[constructor args type parameters]" + this.empty("br"));
        this.println("[method annotations]" + this.empty("br"));
        this.println("[method parameter annotations]" + this.empty("br"));
        this.println("[method type parameter]" + this.empty("br"));
        this.println("[method throws]" + this.empty("br"));
        this.println("[method args]" + this.empty("br"));
        this.println("[method args type parameters]" + this.empty("br"));
        this.println("[method return]" + this.empty("br"));
        this.println("[method return type parameter]" + this.empty("br"));
    }

    @Override
    protected void navLinkPackage() {
        this.println(this.listItem(this.linkToLabelHrefTitle(PACKAGE, ".." + SLASH + "package-summary" + ClassUse.CONF.ext, CONF.propertyText("navtitle.Package", this.theClass.containingPackage().name()))));
    }

    @Override
    protected void navLinkClass() {
        this.println(this.listItem(this.linkToLabelHrefTitle(CLASS, ".." + SLASH + this.filename, CONF.propertyText("navtitle.Class", this.theClass.name()))));
    }

    @Override
    protected void navLinkUse() {
        this.println(this.listItemCurrent(USE));
    }

    @Override
    protected void navLinkTree() {
        this.println(this.listItem(this.linkToLabelHrefTitle(TREE, ".." + SLASH + "package-tree" + ClassUse.CONF.ext, CONF.propertyText("navtitle.Tree.package", this.theClass.containingPackage().name()))));
    }

    @Override
    protected void navPreviousNext() {
        this.println(this.openULWithID("PreviousNext"));
        this.println(this.listItem(this.linkToLabelHref(PREV_CLASS, this.hrefToDoc((Doc)this.prev))) + this.listItemLast(this.linkToLabelHref(NEXT_CLASS, this.hrefToDoc((Doc)this.next))));
        this.println(this.close("ul"));
    }
}

