/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.writers;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.util.ClassUseMapper;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.xhtmldoclet.Config;
import net.sourceforge.xhtmldoclet.Doclet;
import net.sourceforge.xhtmldoclet.writers.SubWriterHolderWriter;

public class PackageUseWriter
extends SubWriterHolderWriter {
    final PackageDoc pkgdoc;
    final SortedMap usingPackageToUsedClasses = new TreeMap();

    public PackageUseWriter(Config configuration, ClassUseMapper mapper, String filename, PackageDoc pkgdoc) throws IOException {
        super(configuration, DirectoryManager.getDirectoryPath((PackageDoc)pkgdoc), filename, DirectoryManager.getRelativePath((String)pkgdoc.name()));
        this.pkgdoc = pkgdoc;
        ClassDoc[] content = pkgdoc.allClasses();
        for (int i = 0; i < content.length; ++i) {
            ClassDoc usedClass = content[i];
            Set usingClasses = (Set)mapper.classToClass.get(usedClass.qualifiedName());
            if (usingClasses == null) continue;
            for (ClassDoc usingClass : usingClasses) {
                PackageDoc usingPackage = usingClass.containingPackage();
                TreeSet<ClassDoc> usedClasses = (TreeSet<ClassDoc>)this.usingPackageToUsedClasses.get(usingPackage.name());
                if (usedClasses == null) {
                    usedClasses = new TreeSet<ClassDoc>();
                    this.usingPackageToUsedClasses.put(Util.getPackageName((PackageDoc)usingPackage), usedClasses);
                }
                usedClasses.add(usedClass);
            }
        }
    }

    public static void generate(Config configuration, ClassUseMapper mapper, PackageDoc pkgdoc) {
        String filename = "package-use.html";
        try {
            PackageUseWriter pkgusegen = new PackageUseWriter(configuration, mapper, filename, pkgdoc);
            pkgusegen.generatePackageUseFile();
            pkgusegen.close();
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    protected void generatePackageUseFile() {
        this.printPackageUseHeader();
        if (this.usingPackageToUsedClasses.isEmpty()) {
            this.printText("doclet.ClassUse_No.usage.of.0", this.pkgdoc.name());
            this.p();
        } else {
            this.generatePackageUse();
        }
        this.printPackageUseFooter();
    }

    protected void generatePackageUse() {
        if (this.configuration.packages.length > 1) {
            this.generatePackageList();
        }
        this.generateClassList();
    }

    protected void generatePackageList() {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.printText("doclet.ClassUse_Packages.that.use.0", this.getPackageLink(this.pkgdoc, Util.getPackageName((PackageDoc)this.pkgdoc), false));
        this.tableHeaderEnd();
        Iterator it = this.usingPackageToUsedClasses.keySet().iterator();
        while (it.hasNext()) {
            PackageDoc pkg = this.configuration.root.packageNamed((String)it.next());
            this.generatePackageUse(pkg);
        }
        this.tableEnd();
        this.space();
        this.p();
    }

    protected void generateClassList() {
        for (String packageName : this.usingPackageToUsedClasses.keySet()) {
            PackageDoc usingPackage = this.configuration.root.packageNamed(packageName);
            if (usingPackage != null) {
                this.anchor(usingPackage.name());
            }
            this.tableIndexSummary();
            this.tableHeaderStart("#CCCCFF");
            this.printText("doclet.ClassUse_Classes.in.0.used.by.1", this.getPackageLink(this.pkgdoc, Util.getPackageName((PackageDoc)this.pkgdoc), false), this.getPackageLink(usingPackage, Util.getPackageName((PackageDoc)usingPackage), false));
            this.tableHeaderEnd();
            Iterator itc = ((Collection)this.usingPackageToUsedClasses.get(packageName)).iterator();
            while (itc.hasNext()) {
                this.printClassRow((ClassDoc)itc.next(), packageName);
            }
            this.tableEnd();
            this.space();
            this.p();
        }
    }

    protected void printClassRow(ClassDoc usedClass, String packageName) {
        String path = this.pathString(usedClass, "class-use/" + usedClass.name() + ".html");
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        this.bold();
        this.printHyperLink(path, packageName, usedClass.name(), true);
        this.boldEnd();
        this.println();
        this.br();
        this.printNbsps();
        this.printIndexComment((Doc)usedClass);
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void generatePackageUse(PackageDoc pkg) {
        if (pkg == null) {
            return;
        }
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        this.printHyperLink("", pkg.name(), Util.getPackageName((PackageDoc)pkg), true);
        this.summaryRowEnd();
        this.summaryRow(0);
        this.printSummaryComment((Doc)pkg);
        this.space();
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void printPackageUseHeader() {
        String packageLabel = this.configuration.getText("doclet.Package");
        String name = this.pkgdoc.name();
        this.printHtmlHeader(this.configuration.getText("doclet.Window_ClassUse_Header", packageLabel, name), null, true);
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2();
        this.boldText("doclet.ClassUse_Title", packageLabel, name);
        this.h2End();
        this.centerEnd();
    }

    protected void printPackageUseFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.configuration.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkClassUse() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.navClassUse");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }
}

