/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.server;

import java.lang.reflect.Constructor;
import org.apache.cactus.internal.AbstractCactusTestCase;
import org.apache.cactus.internal.EJBTestResult;
import org.apache.cactus.internal.server.EJBImplicitObjects;
import org.apache.cactus.internal.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractEJBTestCaller {
    private static final Log LOGGER;
    protected EJBImplicitObjects objects;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.cactus.internal.server.AbstractWebTestCaller");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = LogFactory.getLog((Class)clazz);
    }

    public AbstractEJBTestCaller(EJBImplicitObjects theObjects) {
        this.objects = theObjects;
    }

    protected abstract void setTestCaseFields(AbstractCactusTestCase var1) throws Exception;

    public void doTest() throws Exception {
        EJBTestResult result = null;
        try {
            AbstractCactusTestCase testInstance = this.getTestClassInstance(this.getTestClassName(), this.getTestMethodName());
            LOGGER.debug((Object)("CLASS NAME " + this.getTestClassName()));
            LOGGER.debug((Object)("METHOD NAME " + this.getTestMethodName()));
            this.setTestCaseFields(testInstance);
            testInstance.runBareServer();
            result = new EJBTestResult();
        }
        catch (Throwable e) {
            result = new EJBTestResult(e);
        }
        LOGGER.info((Object)"***********************************************");
        LOGGER.info((Object)("Test result : [" + result + "]"));
        LOGGER.info((Object)"***********************************************");
    }

    protected String getTestClassName() {
        return this.objects.getEJBRequest().getClassName("Cactus_TestClass");
    }

    protected String getTestMethodName() throws Exception {
        return this.objects.getEJBRequest().getMethodName("Cactus_TestMethod");
    }

    protected AbstractCactusTestCase getTestClassInstance(String theClassName, String theTestCaseName) throws Exception {
        Class testClass = this.getTestClassClass(theClassName);
        AbstractCactusTestCase testInstance = null;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor constructor = testClass.getConstructor(classArray);
            testInstance = (AbstractCactusTestCase)((Object)constructor.newInstance(theTestCaseName));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return testInstance;
    }

    protected Class getTestClassClass(String theClassName) throws Exception {
        Class testClass = null;
        try {
            testClass = ClassLoaderUtils.loadClass(theClassName, this.getClass());
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return testClass;
    }
}

