/**
 * 
 */
package org.mortbay.cometd;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Queue;

import javax.servlet.http.HttpServletResponse;

import org.mortbay.util.ajax.JSON;

public class JSONTransport extends AbstractTransport
{
    private int _responses=0;
    private PrintWriter _out;
    protected String _contentType;
    protected String _start;
    protected String _end;
    private boolean _commented;
    

    /* ------------------------------------------------------------ */
    public JSONTransport()
    {
        setJSONCommented(false);
    }
    
    /* ------------------------------------------------------------ */
    public JSONTransport(boolean commented)
    {
        setJSONCommented(commented);
    }

    /* ------------------------------------------------------------ */
    /**
     * @return the commented
     */
    public boolean isJSONCommented()
    {
        return _commented;
    }

    /* ------------------------------------------------------------ */
    /**
     * @param commented the commented to set
     */
    public void setJSONCommented(boolean commented)
    {
        _commented=commented;
        if (commented)
        {
            _contentType="text/json-comment-filtered; charset=utf-8";
            _start="/*[";
            _end="]*/\r\n";
        }
        else
        {
            _contentType="text/json charset=utf-8";
            _start="[";
            _end="]\r\n";
        }
    }
    
    /* ------------------------------------------------------------ */
    public void send(Map<String, Object> reply) throws IOException
    {
        if (reply!=null)
        {
            if (_responses==0)
            {
                HttpServletResponse response=getResponse();
                response.setContentType(_contentType);
                _out=response.getWriter();
                _out.write(_start);
            }
            else
                _out.write(',');
            
            String r=JSON.toString(reply);
            _responses++;
            _out.write(r);
        }
    }
    
    public void complete() throws IOException
    {
        HttpServletResponse response=getResponse();
        response.setStatus(200);
        
        if (_responses==0)
            response.setContentLength(0);
        else
            _out.write(_end);
    }

    public boolean keepAlive() throws IOException
    {
        return false;
    }
}