// ========================================================================
// Copyright 2006 Mort Bay Consulting Pty. Ltd.
// ------------------------------------------------------------------------
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at 
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ========================================================================

package org.mortbay.cometd.continuation;

import org.mortbay.cometd.Bayeux;
import org.mortbay.cometd.Client;
import org.mortbay.util.ajax.Continuation;

/* ------------------------------------------------------------ */
/**
 * Extension of {@link Client} that uses {@link Continuation}s to
 * resume clients waiting for messages.
 * 
 * @author gregw
 *
 */
class ContinuationClient extends Client
{
    ContinuationClient(Bayeux bayeux, String idPrefix)
    {
        super(bayeux,idPrefix);
    }

    private transient Continuation _continuation;

    void setContinuation(Continuation continuation)
    {
        synchronized (this)
        {
            if (_continuation!=null && _continuation.isPending())
                _continuation.resume();
            _continuation=continuation;
        }
    }

    public void resume()
    {
        synchronized (this)
        {
            if (_continuation!=null)
                   _continuation.resume();
            _continuation=null;
        }
    }

    /* ------------------------------------------------------------ */
    /* (non-Javadoc)
     * @see org.mortbay.cometd.Client#access()
     */
    protected void access()
    {
        super.access();
    }

    /* ------------------------------------------------------------ */
    /* (non-Javadoc)
     * @see org.mortbay.cometd.Client#responded()
     */
    protected int responded()
    {
        return super.responded();
    }

    /* ------------------------------------------------------------ */
    /* (non-Javadoc)
     * @see org.mortbay.cometd.Client#responsePending()
     */
    protected int responsePending()
    {
        return super.responsePending();
    }
    
    

}