/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.controller;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.makumba.CompositeValidationException;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.commons.ControllerHandler;
import org.makumba.commons.ServletObjects;
import org.makumba.commons.json.JSONArray;
import org.makumba.commons.json.JSONException;
import org.makumba.commons.json.JSONObject;

public class AJAXDataControllerHandler
extends ControllerHandler {
    final Logger logger = Logger.getLogger("org.makumba.controller");

    public boolean beforeFilter(ServletRequest request, ServletResponse response, FilterConfig conf, ServletObjects httpServletObjects) throws Exception {
        return true;
    }

    public void afterFilter(ServletRequest request, ServletResponse response, FilterConfig conf) {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.handleEvent(req, resp);
        this.handleFormPostback(req, resp);
    }

    private void handleEvent(HttpServletRequest req, HttpServletResponse response) {
        String event = req.getParameter("__mak_event__");
        if (event != null) {
            response.reset();
            response.setContentType("application/json");
            HashMap data = new HashMap();
            Enumeration keys = req.getAttributeNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith("__mak_event__###" + event)) continue;
                data.putAll((Map)req.getAttribute(key));
            }
            try {
                response.getWriter().append(new JSONObject(data).toString());
                response.getWriter().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleFormPostback(HttpServletRequest req, HttpServletResponse response) {
        String partialPostback = (String)req.getAttribute("__makumba__formPartialPostbackEvent__");
        if (partialPostback != null) {
            this.logger.fine("partial form postback");
            CompositeValidationException v = (CompositeValidationException)req.getAttribute("__makumba__formValidationErrors__");
            String message = (String)req.getAttribute("makumba.response");
            String formattedMessage = (String)req.getAttribute("makumba.responseFormatted");
            String formName = (String)req.getAttribute("__makumba__formId__");
            try {
                if (v != null) {
                    JSONObject o = new JSONObject();
                    JSONObject fieldErrors = new JSONObject();
                    Enumeration params = req.getParameterNames();
                    while (params.hasMoreElements()) {
                        String param = (String)params.nextElement();
                        if (v.getExceptions(param) == null) continue;
                        Collection<InvalidValueException> paramFieldErrors = v.getExceptions(param);
                        JSONArray errors = new JSONArray();
                        fieldErrors.put(param + formName, errors);
                        for (InvalidValueException ive : paramFieldErrors) {
                            errors.put(ive.getShortMessage());
                        }
                    }
                    o.put("fieldErrors", fieldErrors);
                    o.put("message", formattedMessage);
                    response.reset();
                    response.setContentType("application/json");
                    this.logger.fine("writing error information: " + o.toString());
                    response.getWriter().print(o.toString());
                    response.getWriter().flush();
                } else {
                    JSONObject o = new JSONObject();
                    o.put("event", partialPostback);
                    response.reset();
                    response.setContentType("application/json");
                    response.getWriter().print(o.toString());
                    this.logger.fine("writing event: " + o.toString());
                    response.getWriter().flush();
                }
            }
            catch (JSONException je) {
                throw new MakumbaError(je);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

