/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.makumba.db.makumba.sql.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDatabase
extends Database {
    public static final String regExpForeignKeyError = ".*\\(`(.*)`, CONSTRAINT `(.*)` FOREIGN KEY \\(`(.*)`\\) REFERENCES `(.*)` \\(`(.*)`\\)\\)";
    public static final Pattern patternForeignKeyError = Pattern.compile(".*\\(`(.*)`, CONSTRAINT `(.*)` FOREIGN KEY \\(`(.*)`\\) REFERENCES `(.*)` \\(`(.*)`\\)\\)");

    public MySqlDatabase(Properties p) {
        super(p);
    }

    @Override
    public String parseReadableForeignKeyErrorMessage(SQLException se) {
        String msg = se.getMessage();
        Matcher matcher = patternForeignKeyError.matcher(msg.trim());
        if (matcher.matches()) {
            try {
                String group = matcher.group(1);
                String referingTableName = MySqlDatabase.getMddName(group.substring(group.indexOf("/") + 1));
                String referedTableName = MySqlDatabase.getMddName(matcher.group(4));
                return "Trying to delete an entry from " + referedTableName + ", while an entry " + referingTableName + " still refers to it. Try to invert the order of deletion.";
            }
            catch (Exception e) {
                e.printStackTrace();
                return se.getMessage();
            }
        }
        return se.getMessage();
    }

    @Override
    public Map<String, String> getDuplicateFields(SQLException e) {
        HashMap<String, String> res = new HashMap<String, String>();
        String[] error = e.getMessage().split("'");
        String[] values = error[1].split("-");
        String[] fields = error[3].split("_");
        for (int i = 0; i < fields.length; ++i) {
            res.put(fields[i], values[i]);
        }
        return res;
    }

    public static String getMddName(String referingTableName) {
        return StringUtils.removeEnd((String)referingTableName, (String)"_").replaceAll("__", "->").replaceAll("_", ".");
    }
}

