/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.responder;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.makumba.LogicException;
import org.makumba.Pointer;
import org.makumba.commons.DbConnectionProvider;
import org.makumba.commons.attributes.RequestAttributes;
import org.makumba.controller.Logic;
import org.makumba.forms.responder.Responder;
import org.makumba.forms.tags.FormOperationType;

public abstract class ResponderOperation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ResponderOperation newOp = new ResponderOperation(){
        private static final long serialVersionUID = 1L;

        public FormOperationType getOperationType() {
            return FormOperationType.NEW;
        }

        public Object respondTo(HttpServletRequest req, Responder resp, String suffix, String parentSuffix) throws LogicException {
            String handlerName = resp.getHandler() != null ? resp.getHandler() : "on_new" + Logic.upperCase(resp.getNewType());
            String afterHandlerName = resp.getAfterHandler() != null ? resp.getAfterHandler() : "after_new" + Logic.upperCase(resp.getNewType());
            return Logic.doNew(resp.getController(), handlerName, afterHandlerName, resp.getNewType(), resp.getHttpData(req, suffix), new RequestAttributes(resp.getController(), req, resp.getDatabase()), resp.getDatabase(), this.getConnectionProvider(req, resp.getController()));
        }

        public String verify(Responder resp) {
            return null;
        }
    };
    public static final ResponderOperation editOp = new ResponderOperation(){
        private static final long serialVersionUID = 1L;

        public FormOperationType getOperationType() {
            return FormOperationType.EDIT;
        }

        public Object respondTo(HttpServletRequest req, Responder resp, String suffix, String parentSuffix) throws LogicException {
            String handlerName = resp.getHandler() != null ? resp.getHandler() : "on_edit" + Logic.upperCase(resp.getBasePointerType());
            String afterHandlerName = resp.getAfterHandler() != null ? resp.getAfterHandler() : "after_edit" + Logic.upperCase(resp.getBasePointerType());
            return Logic.doEdit(resp.getController(), handlerName, afterHandlerName, resp.getBasePointerType(), resp.getHttpBasePointer(req, suffix), resp.getHttpData(req, suffix), new RequestAttributes(resp.getController(), req, resp.getDatabase()), resp.getDatabase(), this.getConnectionProvider(req, resp.getController()));
        }

        public String verify(Responder resp) {
            return null;
        }
    };
    public static final ResponderOperation addToNewOp = new ResponderOperation(){
        private static final long serialVersionUID = 1L;

        public FormOperationType getOperationType() {
            return FormOperationType.ADD;
        }

        public Object respondTo(HttpServletRequest req, Responder resp, String suffix, String parentSuffix) throws LogicException {
            Object resultFromNew = req.getAttribute("org.makumba.controller.resultOf_" + parentSuffix);
            if (resultFromNew == Pointer.Null) {
                return Pointer.Null;
            }
            String handlerName = resp.getHandler() != null ? resp.getHandler() : "on_add" + Logic.upperCase(resp.getNewType() + "->" + resp.getAddField());
            String afterHandlerName = resp.getAfterHandler() != null ? resp.getAfterHandler() : "after_add" + Logic.upperCase(resp.getNewType() + "->" + resp.getAddField());
            return Logic.doAdd(resp.getController(), handlerName, afterHandlerName, resp.getNewType() + "->" + resp.getAddField(), (Pointer)resultFromNew, resp.getHttpData(req, suffix), new RequestAttributes(resp.getController(), req, resp.getDatabase()), resp.getDatabase(), this.getConnectionProvider(req, resp.getController()));
        }

        public String verify(Responder resp) {
            return null;
        }
    };
    public static final ResponderOperation addOp = new ResponderOperation(){
        private static final long serialVersionUID = 1L;

        public FormOperationType getOperationType() {
            return FormOperationType.ADD;
        }

        public Object respondTo(HttpServletRequest req, Responder resp, String suffix, String parentSuffix) throws LogicException {
            String handlerName = resp.getHandler() != null ? resp.getHandler() : "on_add" + Logic.upperCase(resp.getBasePointerType() + "->" + resp.getAddField());
            String afterHandlerName = resp.getAfterHandler() != null ? resp.getAfterHandler() : "after_add" + Logic.upperCase(resp.getBasePointerType() + "->" + resp.getAddField());
            return Logic.doAdd(resp.getController(), handlerName, afterHandlerName, resp.getBasePointerType() + "->" + resp.getAddField(), resp.getHttpBasePointer(req, suffix), resp.getHttpData(req, suffix), new RequestAttributes(resp.getController(), req, resp.getDatabase()), resp.getDatabase(), this.getConnectionProvider(req, resp.getController()));
        }

        public String verify(Responder resp) {
            return null;
        }
    };
    public static final ResponderOperation simepleOp = new ResponderOperation(){
        private static final long serialVersionUID = 1L;

        public FormOperationType getOperationType() {
            return FormOperationType.SIMPLE;
        }

        public Object respondTo(HttpServletRequest req, Responder resp, String suffix, String parentSuffix) throws LogicException {
            return Logic.doOp(resp.getController(), resp.getHandler(), resp.getHttpData(req, suffix), new RequestAttributes(resp.getController(), req, resp.getDatabase()), resp.getDatabase(), this.getConnectionProvider(req, resp.getController()));
        }

        public String verify(Responder resp) {
            return null;
        }
    };
    public static final ResponderOperation deleteLinkOp = new ResponderOperation(){
        private static final long serialVersionUID = 1L;

        public FormOperationType getOperationType() {
            return FormOperationType.DELETE;
        }

        public Object respondTo(HttpServletRequest req, Responder resp, String suffix, String parentSuffix) throws LogicException {
            return Logic.doDelete(resp.getController(), resp.getBasePointerType(), resp.getHttpBasePointer(req, suffix), new RequestAttributes(resp.getController(), req, resp.getDatabase()), resp.getDatabase(), this.getConnectionProvider(req, resp.getController()));
        }

        public String verify(Responder resp) {
            return null;
        }
    };
    public static final ResponderOperation deleteFormOp = new ResponderOperation(){
        private static final long serialVersionUID = 1L;

        public FormOperationType getOperationType() {
            return FormOperationType.DELETE;
        }

        public Object respondTo(HttpServletRequest req, Responder resp, String suffix, String parentSuffix) throws LogicException {
            return Logic.doDelete(resp.getController(), resp.getBasePointerType(), resp.getHttpBasePointer(req, suffix), new RequestAttributes(resp.getController(), req, resp.getDatabase()), resp.getDatabase(), this.getConnectionProvider(req, resp.getController()));
        }

        public String verify(Responder resp) {
            return null;
        }
    };

    public abstract FormOperationType getOperationType();

    public abstract Object respondTo(HttpServletRequest var1, Responder var2, String var3, String var4) throws LogicException;

    public abstract String verify(Responder var1);

    public DbConnectionProvider getConnectionProvider(HttpServletRequest req, Object controller) {
        return RequestAttributes.getConnectionProvider(req);
    }
}

