/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.tags;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import org.makumba.CompositeValidationException;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.LogicException;
import org.makumba.MakumbaSystem;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.StringUtils;
import org.makumba.commons.attributes.HttpParameters;
import org.makumba.commons.attributes.PageAttributes;
import org.makumba.commons.attributes.RequestAttributes;
import org.makumba.forms.html.ChoiceSet;
import org.makumba.forms.html.dateEditor;
import org.makumba.forms.tags.BasicValueTag;
import org.makumba.forms.tags.FormTagBase;
import org.makumba.forms.tags.SearchFieldTag;
import org.makumba.providers.Configuration;

public class InputTag
extends BasicValueTag
implements BodyTag {
    private static final long serialVersionUID = 1L;
    protected String name = null;
    protected String display = null;
    protected String nameVar = null;
    protected String calendarEditorLink = null;
    private String autoComplete = null;
    protected boolean calendarEditor = Configuration.getCalendarEditorDefault();
    protected String nullOption;
    BodyContent bodyContent = null;
    ChoiceSet choiceSet;
    boolean isChoser;

    public String toString() {
        return "INPUT name=" + this.name + " value=" + this.valueExprOriginal + " dataType=" + this.dataType + "\n";
    }

    public void setDataType(String dt) {
        this.dataType = dt.trim();
    }

    public void setField(String field) {
        this.setName(field);
    }

    public void setName(String field) {
        this.name = field.trim();
    }

    public void setDisplay(String d) {
        this.display = d;
    }

    public void setNameVar(String var) {
        this.nameVar = var;
    }

    public void setNullOption(String s) {
        this.nullOption = s;
    }

    public void setClearDefault(String d) {
        this.params.put("clearDefault", d);
    }

    public void setAccessKey(String s) {
        this.extraFormattingParams.put("accessKey", s);
    }

    public void setDisabled(String s) {
        this.extraFormattingParams.put("disabled", s);
    }

    public void setOnChange(String s) {
        this.extraFormattingParams.put("onChange", s);
    }

    public void setOnBlur(String s) {
        this.extraFormattingParams.put("onBlur", s);
    }

    public void setOnFocus(String s) {
        this.extraFormattingParams.put("onFocus", s);
    }

    public void setOnSelect(String s) {
        this.extraFormattingParams.put("onSelect", s);
    }

    public void setTabIndex(String s) {
        this.extraFormattingParams.put("tabIndex", s);
    }

    public void setTagKey(PageCache pageCache) {
        if (this.calendarEditorLink == null && this.pageContext != null) {
            this.calendarEditorLink = Configuration.getDefaultCalendarEditorLink(((HttpServletRequest)this.pageContext.getRequest()).getContextPath());
        }
        this.expr = this.valueExprOriginal;
        if (this.getForm() == null) {
            throw new ProgrammerError("input tag must be enclosed by a form tag");
        }
        if (this.expr == null) {
            this.expr = this.getForm().getDefaultExpr(this.name);
        }
        Object[] keyComponents = new Object[]{this.name, this.getForm().tagKey};
        this.tagKey = new MultipleKey(keyComponents);
    }

    FieldDefinition getTypeFromContext(PageCache pageCache) {
        return this.fdp.getInputTypeAtAnalysis(this, this.getForm().getDataTypeAtAnalysis(pageCache), this.name, pageCache);
    }

    public void doStartAnalyze(PageCache pageCache) {
        if (this.name == null) {
            throw new ProgrammerError("name attribute is required");
        }
        if (this.getForm() == null) {
            throw new ProgrammerError("input tag must be enclosed by a form tag!");
        }
        if (this.isValue()) {
            if (this.getForm().getNestedFormNames(pageCache).keySet().contains(this.expr)) {
                this.getForm().lazyEvaluatedInputs.put(this.expr, this.name);
                this.setDisplay("false");
            } else {
                this.fdp.onNonQueryStartAnalyze(this, this.isNull(), this.getForm().getTagKey(), pageCache, this.expr);
            }
        }
    }

    public void doEndAnalyze(PageCache pageCache) {
        boolean contextTypeIsDate;
        if (this.getForm().lazyEvaluatedInputs.containsKey(this.expr)) {
            TagData t = (TagData)pageCache.retrieve("org.makumba.tagData", this.getForm().getNestedFormNames(pageCache).get(this.expr));
            DataDefinition type = ((FormTagBase)((Object)t.tagObject)).type;
            pageCache.cache("org.makumba.inputtypes", this.tagKey, type.getFieldDefinition(type.getIndexPointerFieldName()));
            return;
        }
        if (this.nameVar != null) {
            this.setType(pageCache, this.nameVar, this.ddp.makeFieldOfType(this.nameVar, "char"));
        }
        FieldDefinition contextType = this.getTypeFromContext(pageCache);
        boolean dataTypeIsDate = this.dataType != null && this.ddp.makeFieldDefinition("dummyName", this.dataType) != null && this.ddp.makeFieldDefinition("dummyName", this.dataType).isDateType();
        boolean bl = contextTypeIsDate = contextType != null && contextType.isDateType();
        if ((dataTypeIsDate || contextTypeIsDate) && this.calendarEditor && !StringUtils.equals(this.params.get("type"), "hidden")) {
            pageCache.cacheSetValues("org.makumba.neededResources", MakumbaSystem.getCalendarProvider().getNeededJavaScriptFileNames());
        }
        if (StringUtils.equals(this.params.get("type"), "seteditor")) {
            pageCache.cacheSetValues("org.makumba.neededResources", new String[]{"makumbaSetChooser.js"});
            if (org.apache.commons.lang.StringUtils.isBlank((String)this.getForm().formName)) {
                throw new ProgrammerError("For using 'seteditor' input types, you have to give the encosing form a name, using name=\"  \"!");
            }
        }
        if (this.autoComplete != null && this.autoComplete.equals("true")) {
            pageCache.cacheSetValues("org.makumba.neededResources", new String[]{"prototype.js", "scriptaculous.js", "makumba-autocomplete.js"});
        }
        super.doEndAnalyze(pageCache);
    }

    public void initialiseState() {
        super.initialiseState();
        if ("file".equals(this.params.get("type"))) {
            this.getForm().setMultipart();
        }
    }

    public void setBodyContent(BodyContent bc) {
        this.bodyContent = bc;
        this.choiceSet = new ChoiceSet();
    }

    public void doInitBody() {
    }

    public int doAnalyzedStartTag(PageCache pageCache) {
        return 2;
    }

    public int doAnalyzedEndTag(PageCache pageCache) throws JspException, LogicException {
        this.params.put("org.makumba.forms.queryLanguage", MakumbaJspAnalyzer.getQueryLanguage(pageCache));
        FieldDefinition type = (FieldDefinition)pageCache.retrieve("org.makumba.inputtypes", this.tagKey);
        if (type.isBinaryType() || type.isFileType()) {
            this.getForm().setMultipart();
        }
        Object val = null;
        if (StringUtils.equals(this.pageContext.getRequest().getAttribute("__makumba__formReload__"), "true")) {
            String tagName = this.name + this.getForm().responder.getSuffix();
            HttpParameters parameters = RequestAttributes.getParameters((HttpServletRequest)this.pageContext.getRequest());
            if (type.isDateType()) {
                val = dateEditor.readFrom(tagName, parameters);
                if (val.equals(type.getDefaultValue()) && parameters.getParameter(tagName + "_null") != null) {
                    val = null;
                }
            } else {
                val = parameters.getParameter(tagName);
            }
            return this.computedValue(val, type);
        }
        if (this.isValue() && !this.getForm().getNestedFormNames(pageCache).containsKey(this.expr)) {
            val = this.fdp.getValue(this.getTagKey(), this.getPageContext(), pageCache);
        }
        if (this.isAttribute()) {
            val = PageAttributes.getAttributes(this.pageContext).getAttribute(this.expr.substring(1));
        }
        if (val != null) {
            val = type.checkValue(val);
        }
        String defaultExpr = (String)this.params.get("default");
        if (val == null && defaultExpr != null && defaultExpr.toString().trim().length() > 0) {
            if (this.isAttribute(defaultExpr)) {
                val = PageAttributes.getAttributes(this.pageContext).getAttribute(defaultExpr.substring(1));
            }
            if (this.isValue(defaultExpr)) {
                // empty if block
            }
            if (val != null) {
                val = type.checkValue(val);
            }
        }
        return this.computedValue(val, type);
    }

    void checkBodyContentForNonWhitespace() throws JspException {
        if (this.bodyContent != null && this.bodyContent.getString().trim().length() > 0) {
            this.choiceSet.add(null, this.bodyContent.getString().trim(), false, false);
            try {
                this.bodyContent.clear();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    int computedValue(Object val, FieldDefinition type) throws JspException, LogicException {
        this.checkBodyContentForNonWhitespace();
        if (this.choiceSet != null) {
            this.params.put("org.makumba.ChoiceSet", this.choiceSet);
        }
        if ("false".equals(this.display)) {
            this.params.put("org.makumba.noDisplay", "dummy");
        }
        if (this.nullOption != null) {
            FieldDefinition fd = this.getTypeFromContext(InputTag.getPageCache(this.pageContext, MakumbaJspAnalyzer.getInstance()));
            if (!(fd.isEnumType() || fd.isPointer() || this instanceof SearchFieldTag && org.apache.commons.lang.StringUtils.equals((String)((SearchFieldTag)this).forceInputStyle, (String)"single"))) {
                throw new ProgrammerError("Attribute 'nullOption' is only applicable for 'charEnum', 'intEnum' and 'ptr' types, but input '" + fd.getName() + "' is of type '" + fd.getType() + "'!");
            }
            this.params.put("nullOption", this.nullOption);
        }
        if (type.isDateType() && !StringUtils.equals(this.params.get("type"), "hidden")) {
            if (this.calendarEditor) {
                this.params.put("calendarEditor", String.valueOf(this.calendarEditor));
            }
            if (this.calendarEditorLink != null) {
                this.params.put("calendarEditorLink", this.calendarEditorLink);
            }
        }
        if (this.autoComplete != null) {
            this.params.put("autoComplete", this.autoComplete);
        }
        String formatted = this.getForm().responder.format(this.name, type, val, this.params, this.extraFormatting.toString(), this.getForm().getFormIdentifier());
        String fieldName = this.name + this.getForm().responder.getSuffix();
        if (this.nameVar != null) {
            this.getPageContext().setAttribute(this.nameVar, (Object)fieldName);
        }
        if (this.display == null || !this.display.equals("false")) {
            try {
                CompositeValidationException errors = (CompositeValidationException)this.pageContext.getRequest().getAttribute("__makumba__formValidationErrors__");
                Collection<InvalidValueException> exceptions = null;
                if (errors != null) {
                    exceptions = errors.getExceptions(fieldName);
                }
                if (StringUtils.equalsAny(this.getForm().annotation, "before", "both") && exceptions != null) {
                    for (InvalidValueException invalidValueException : exceptions) {
                        this.printAnnotation(fieldName, invalidValueException);
                        if (this.getForm().annotationSeparator == null) continue;
                        this.pageContext.getOut().print(this.getForm().annotationSeparator);
                    }
                }
                this.pageContext.getOut().print(formatted);
                if (StringUtils.equalsAny(this.getForm().annotation, "after", "both") && exceptions != null) {
                    for (InvalidValueException invalidValueException : exceptions) {
                        if (this.getForm().annotationSeparator != null) {
                            this.pageContext.getOut().print(this.getForm().annotationSeparator);
                        }
                        this.printAnnotation(fieldName, invalidValueException);
                    }
                }
            }
            catch (IOException e) {
                throw new JspException(e.toString());
            }
        }
        this.nameVar = null;
        this.expr = null;
        this.display = null;
        this.dataType = null;
        this.valueExprOriginal = null;
        this.name = null;
        return 6;
    }

    private void printAnnotation(String fieldName, InvalidValueException e) throws IOException {
        this.pageContext.getOut().print("<span class=\"LV_validation_message LV_invalid\">");
        this.pageContext.getOut().print(e.getShortMessage());
        this.pageContext.getOut().print("</span>");
    }

    public void setCalendarEditorLink(String calendarEditorLink) {
        this.calendarEditorLink = calendarEditorLink;
    }

    public void setAutoComplete(String autoComplete) {
        this.autoComplete = autoComplete;
    }

    public void setCalendarEditor(String calendarEditor) {
        this.calendarEditor = Boolean.parseBoolean(calendarEditor);
    }

    public void setStepSize(String s) {
        this.params.put("stepSize", s);
    }

    protected void doAnalyzedCleanup() {
        super.doAnalyzedCleanup();
        this.bodyContent = null;
        this.choiceSet = null;
        this.autoComplete = null;
        this.calendarEditorLink = null;
        this.display = null;
        this.nullOption = null;
        this.nameVar = null;
        this.name = null;
        this.calendarEditor = Configuration.getCalendarEditorDefault();
    }
}

