/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.pagination;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import org.makumba.LogicException;
import org.makumba.MakumbaError;
import org.makumba.ProgrammerError;
import org.makumba.analyser.AnalysableTag;
import org.makumba.analyser.PageCache;
import org.makumba.commons.ClassResource;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.StringUtils;
import org.makumba.commons.tags.GenericMakumbaTag;
import org.makumba.list.tags.QueryTag;
import org.makumba.providers.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginationTag
extends GenericMakumbaTag {
    private static final String ALL_ATTRIBUTES = "all of the attributes 'limit', 'offset' and 'totalCount'";
    private static final String FIRST = "&lt;&lt;";
    private static final String NEXT = "&gt;";
    private static final String LAST = "&gt;&gt;";
    private static final String LIMIT = "limit";
    private static final String PREVIOUS = "&lt;";
    private static Hashtable<String, String> navigationLinkStyle = new Hashtable(4);
    private static Hashtable<String, String> navigationNALinkStyle = new Hashtable(4);
    private static boolean navigationStylesInitialised = false;
    private static final String OFFSET = "offset";
    private static final long serialVersionUID = 1L;
    private static final String PROPERTIES_FILE_NAME = "paginationProperties.properties";
    private String forList;
    private String itemName;
    private String limit;
    private String offset;
    private String styleClass;
    private String paginationLinkTitle;
    private String totalCount;
    private String action;
    private String paginationLinkTitleText;
    private boolean showPageTitle = true;

    @Override
    public int doAnalyzedEndTag(PageCache pageCache) throws LogicException, JspException {
        return 6;
    }

    @Override
    public void doStartAnalyze(PageCache pageCache) {
        Logger.getLogger("org.makumba.list.pagination").fine("Start analysing pagination tag, attributes: offset: " + this.offset + ", limit: " + this.limit + ", totalCount: " + this.totalCount + ", action: " + this.action);
        String[] values = new String[]{this.limit, this.offset, this.totalCount};
        boolean allNotEmpty = StringUtils.allNotEmpty(values);
        boolean anyNotEmpty = StringUtils.anyNotEmpty(values);
        if (anyNotEmpty && allNotEmpty) {
            throw new ProgrammerError("You must provide values for either all of the attributes 'limit', 'offset' and 'totalCount', or for none.");
        }
        if (this.getParentListTag() == null && this.getReferredListTag(pageCache) == null && !allNotEmpty) {
            throw new ProgrammerError("'pagination' tag must be enclosed in a 'list' tag, or the list specified with the 'forList' attribute, or all of the attributes 'limit', 'offset' and 'totalCount' must be specified!");
        }
        super.doStartAnalyze(pageCache);
    }

    @Override
    public int doAnalyzedStartTag(PageCache pageCache) throws LogicException, JspException {
        if (!navigationStylesInitialised) {
            try {
                this.initLinkStyle();
            }
            catch (IOException e) {
                throw new MakumbaError("Error reading properties for pagination: " + e.getMessage());
            }
        }
        int offset = this.offset != null ? Integer.parseInt(this.offset) : this.getParentListTag().getOffsetInt();
        int limit = this.limit != null ? Integer.parseInt(this.limit) : this.getParentListTag().getLimitInt();
        int maxResults = this.totalCount != null ? Integer.parseInt(this.totalCount) : QueryTag.maxResults();
        int pages = (int)Math.ceil((double)maxResults / (double)limit);
        if (maxResults < limit) {
            pages = 0;
        }
        if (pages >= 1) {
            int currentIndex = (int)Math.ceil((double)offset / (double)limit);
            boolean hasPreviousPage = currentIndex > 0;
            boolean hasNextPage = currentIndex < pages - 1;
            StringBuffer sb = new StringBuffer();
            String baseUrl = this.action != null ? this.action : this.getBaseURL();
            int itemCountLower = offset + 1;
            int itemCountUpper = Math.min(maxResults, (currentIndex + 1) * limit);
            String actionAnchor = "";
            int actionHashPos = baseUrl.indexOf(35);
            if (actionHashPos > -1) {
                actionAnchor = baseUrl.substring(actionHashPos);
                baseUrl = baseUrl.substring(0, actionHashPos);
            }
            try {
                JspWriter out = this.pageContext.getOut();
                sb.append("<div class=\"" + this.styleClass + "\">\n");
                sb.append("  <div style=\"float: left; width: 50px\" >\n    ");
                if (hasPreviousPage) {
                    sb.append(this.getAnchor(baseUrl, actionAnchor, 0, limit, FIRST)).append("\n    ");
                    sb.append(this.getAnchor(baseUrl, actionAnchor, (currentIndex - 1) * limit, limit, PREVIOUS));
                } else {
                    sb.append(this.getLink(FIRST, navigationNALinkStyle)).append("\n    ");
                    sb.append(this.getLink(PREVIOUS, navigationNALinkStyle));
                }
                sb.append("\n  </div>\n");
                sb.append("  <div style=\"float: right; width: 50px\" align=\"right\">\n    ");
                if (hasNextPage) {
                    sb.append(this.getAnchor(baseUrl, actionAnchor, (currentIndex + 1) * limit, limit, NEXT)).append("\n    ");
                    sb.append(this.getAnchor(baseUrl, actionAnchor, (pages - 1) * limit, limit, LAST));
                } else {
                    sb.append(this.getLink(NEXT, navigationNALinkStyle)).append("\n    ");
                    sb.append(this.getLink(LAST, navigationNALinkStyle));
                }
                sb.append("  </div>\n");
                sb.append("  <div style=\"text-align: center; margin: 0 15px;\" align=\"center\">\n    ");
                if (this.showPageTitle) {
                    sb.append("Showing ").append(this.itemName).append(" ").append(itemCountLower).append(" to ").append(itemCountUpper).append("").append(" out of ").append(maxResults).append(" (Page ").append(currentIndex + 1).append(" out of ").append(pages).append(")\n");
                }
                sb.append("  </div>\n");
                sb.append("  <div style=\"clear: both; font-size: 1px;\">&nbsp;</div>\n");
                sb.append("</div>\n");
                out.println((Object)sb);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Logger.getLogger("org.makumba.list.pagination").fine("Pagination resulted in only one page, attributes are: offset: " + offset + ", limit: " + limit + ", maxResults: " + maxResults + ", pages: " + pages);
        }
        return 0;
    }

    private void initLinkStyle() throws IOException {
        String contextPath = ((HttpServletRequest)this.pageContext.getRequest()).getContextPath();
        navigationLinkStyle.put(FIRST, "<img border=\"0\" src=\"" + contextPath + Configuration.getMakumbaResourcesLocation() + "/image/resultset_first.gif\" alt=\"" + FIRST + "\">");
        navigationLinkStyle.put(NEXT, "<img border=\"0\" src=\"" + contextPath + Configuration.getMakumbaResourcesLocation() + "/image/resultset_next.gif\" alt=\"" + NEXT + "\">");
        navigationLinkStyle.put(LAST, "<img border=\"0\" src=\"" + contextPath + Configuration.getMakumbaResourcesLocation() + "/image/resultset_last.gif\" alt=\"" + LAST + "\">");
        navigationLinkStyle.put(PREVIOUS, "<img border=\"0\" src=\"" + contextPath + Configuration.getMakumbaResourcesLocation() + "/image/resultset_previous.gif\" alt=\"" + PREVIOUS + "\">");
        navigationNALinkStyle.put(FIRST, "<img border=\"0\" src=\"" + contextPath + Configuration.getMakumbaResourcesLocation() + "/image/resultset_first_na.gif\">");
        navigationNALinkStyle.put(NEXT, "<img border=\"0\" src=\"" + contextPath + Configuration.getMakumbaResourcesLocation() + "/image/resultset_next_na.gif\">");
        navigationNALinkStyle.put(LAST, "<img border=\"0\" src=\"" + contextPath + Configuration.getMakumbaResourcesLocation() + "/image/resultset_last_na.gif\">");
        navigationNALinkStyle.put(PREVIOUS, "<img border=\"0\" src=\"" + contextPath + Configuration.getMakumbaResourcesLocation() + "/image/resultset_previous_na.gif\">");
        Properties linkStyleProperties = new Properties();
        URL alternateLinkPropertiesURL = ClassResource.get(PROPERTIES_FILE_NAME);
        if (alternateLinkPropertiesURL != null) {
            Logger.getLogger("org.makumba.list.pagination").info("Loading alternative properties for pagination links from " + alternateLinkPropertiesURL.toExternalForm());
            linkStyleProperties.load(alternateLinkPropertiesURL.openConnection().getInputStream());
        }
        String[] s = new String[]{FIRST, NEXT, LAST, PREVIOUS};
        for (int i = 0; i < s.length; ++i) {
            navigationLinkStyle.put(s[i], linkStyleProperties.getProperty(s[i], navigationLinkStyle.get(s[i])));
            navigationNALinkStyle.put(s[i], linkStyleProperties.getProperty(s[i] + "_NA", navigationNALinkStyle.get(s[i])));
        }
        navigationStylesInitialised = true;
    }

    private String getAnchor(String baseUrl, String actionAnchor, int start, int range, String page) {
        if (baseUrl.endsWith("?") || baseUrl.endsWith("&")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        String sep = baseUrl.indexOf(63) >= 0 ? "&" : "?";
        StringBuffer link = new StringBuffer("<a href=\"").append(baseUrl).append(sep).append(OFFSET).append("=").append(start).append("&").append(LIMIT).append("=").append(range).append(actionAnchor).append("\"");
        if (org.apache.commons.lang.StringUtils.equals((String)this.paginationLinkTitle, (String)"true")) {
            link.append(" title=\"");
            if (page.equals(PREVIOUS)) {
                link.append("Previous " + this.paginationLinkTitleText);
            } else if (page.equals(NEXT)) {
                link.append("Next " + this.paginationLinkTitleText);
            } else if (page.equals(FIRST)) {
                link.append("First " + this.paginationLinkTitleText);
            } else if (page.equals(LAST)) {
                link.append("Last " + this.paginationLinkTitleText);
            } else {
                link.append("Go to " + this.paginationLinkTitleText + " " + page + "\">");
            }
            link.append("\"");
        }
        link.append(">").append(this.getLink(page, navigationLinkStyle)).append("</a>");
        return link.toString();
    }

    private String getLink(String page, Hashtable<String, String> images) {
        if (images.get(page) != null) {
            return images.get(page);
        }
        return page;
    }

    private String getBaseURL() {
        HttpServletRequest r = (HttpServletRequest)this.pageContext.getRequest();
        StringBuilder queryString = this.getQueryString(r.getParameterMap());
        StringBuilder url = new StringBuilder(r.getRequestURL().toString().substring(r.getRequestURL().toString().indexOf(r.getContextPath())));
        if (queryString.length() > 0) {
            url.append("?").append((CharSequence)queryString);
        }
        return url.toString();
    }

    private QueryTag getParentListTag() {
        return (QueryTag)PaginationTag.findAncestorWithClass((Tag)this, QueryTag.class);
    }

    public StringBuilder getQueryString(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object obj : map.keySet()) {
            if (StringUtils.equalsAny(obj, LIMIT, OFFSET)) continue;
            String[] strings = (String[])map.get(obj);
            for (int i = 0; i < strings.length; ++i) {
                if (!org.apache.commons.lang.StringUtils.isNotBlank((String)strings[i])) continue;
                sb.append(obj).append("=").append(strings[i]).append("&");
            }
        }
        return sb;
    }

    private AnalysableTag getReferredListTag(PageCache pageCache) {
        if (this.forList != null) {
            AnalysableTag tag = (AnalysableTag)((Object)pageCache.retrieve("org.makumba.tags", this.forList));
            if (tag == null) {
                throw new ProgrammerError("Could not find list with id '" + this.forList + "'");
            }
            return tag;
        }
        return null;
    }

    public void setForList(String forList) {
        this.forList = forList;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setLimit(String limit) throws JspException {
        this.onlyInt(LIMIT, limit);
        this.limit = limit;
    }

    public void setOffset(String offset) throws JspException {
        this.onlyInt(OFFSET, offset);
        this.offset = offset;
    }

    @Override
    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setShowPageTitle(String showPageTitle) {
        this.checkValidAttributeValues("showPageTitle", showPageTitle, ATTRIBUTE_VALUES_TRUE_FALSE);
        this.showPageTitle = org.apache.commons.lang.StringUtils.equals((String)showPageTitle, (String)"true");
    }

    public void setPaginationLinkTitle(String paginationLinkTitle) {
        this.checkValidAttributeValues("paginationLinkTitle", paginationLinkTitle, ATTRIBUTE_VALUES_TRUE_FALSE);
        this.paginationLinkTitle = paginationLinkTitle.trim();
    }

    public void setPaginationLinkTitleText(String paginationLinkTitleText) {
        this.paginationLinkTitleText = paginationLinkTitleText;
    }

    public void setTotalCount(String totalCount) throws JspException {
        this.onlyInt("totalCount", totalCount);
        this.totalCount = totalCount;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public void setTagKey(PageCache pageCache) {
        this.tagKey = new MultipleKey(new Object[]{this.action, this.getParentListTag().tagKey, this.itemName, this.limit, this.offset, this.paginationLinkTitle, this.paginationLinkTitleText});
    }

    @Override
    public void initialiseState() {
        super.initialiseState();
        this.itemName = "Items";
        this.styleClass = "makumbaPagination";
        this.paginationLinkTitle = "true";
        this.paginationLinkTitleText = "page";
    }

    @Override
    protected void doAnalyzedCleanup() {
        super.doAnalyzedCleanup();
        this.paginationLinkTitleText = null;
        this.paginationLinkTitle = null;
        this.offset = null;
        this.limit = null;
        this.itemName = null;
        this.forList = null;
        this.action = null;
    }
}

