/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.PERF_TP;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.Protocol;

public class SimplePerfTest {
    JChannel ch = null;
    PERF_TP tp = null;
    DataInputStream in = null;
    DataOutputStream out = null;
    private View view;

    public static void main(String[] args) {
        String props = null;
        int num_msgs = 1000;
        int size = 1000;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-num".equals(args[i])) {
                num_msgs = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-size".equals(args[i])) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            SimplePerfTest.help();
            return;
        }
        try {
            new SimplePerfTest().start(props, num_msgs, size);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void help() {
        System.out.println("PerfTpTest [-help] [-props <properties>] [-num <num msgs>] [-size <msg size (in bytes)]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(String props, int num_msgs, int size) throws Exception {
        byte[] buf = new byte[size];
        this.ch = new JChannel(props);
        this.ch.connect("demo");
        Address local_addr = this.ch.getLocalAddress();
        Vector<Address> members = new Vector<Address>();
        members.add(local_addr);
        this.view = new View(local_addr, 0L, members);
        this.ch.down(new Event(16));
        this.ch.down(new Event(6, this.view));
        this.tp = PERF_TP.getInstance();
        Vector protocols = this.ch.getProtocolStack().getProtocols();
        Protocol transport = (Protocol)protocols.lastElement();
        System.out.println("sending " + num_msgs + " up the stack");
        this.tp.setExpectedMessages(num_msgs);
        for (int i = 0; i < num_msgs; ++i) {
            Message msg = new Message(null, local_addr, buf);
            NakAckHeader hdr = new NakAckHeader(1, i);
            msg.putHeader("NAKACK", hdr);
            transport.up(new Event(1, msg));
            if (i % 10000 != 0) continue;
            System.out.println("passed up " + i + " messages");
        }
        PERF_TP i = this.tp;
        synchronized (i) {
            if (!this.tp.done()) {
                this.tp.wait();
            }
        }
        long total = this.tp.getTotalTime();
        double msgs_per_ms = (double)num_msgs / (double)total;
        double msgs_per_sec = msgs_per_ms * 1000.0;
        double time_per_msg = (double)total / (double)num_msgs;
        double usec_per_msg = time_per_msg * 1000.0;
        System.out.println("num_msgs = " + num_msgs + ", total_time = " + total + "ms");
        System.out.println("msgs/millisec = " + msgs_per_ms + ", msgs/sec = " + msgs_per_sec + "\ntime/msg = " + time_per_msg + " ms" + " (" + usec_per_msg + " usec/msg)");
        this.ch.close();
    }
}

