/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.asm;

import org.logicalcobwebs.asm.ByteVector;
import org.logicalcobwebs.asm.ClassWriter;

public class Attribute {
    public String type;
    public byte[] b;
    public int off;
    public int len;
    public Attribute next;

    public Attribute(String type, byte[] b, int off, int len) {
        this.type = type;
        this.b = b;
        this.off = off;
        this.len = len;
    }

    public Attribute(String type) {
        this(type, null, 0, 0);
    }

    final int getCount() {
        int count = 0;
        Attribute attr = this;
        while (attr != null) {
            ++count;
            attr = attr.next;
        }
        return count;
    }

    final int getSize(ClassWriter cw) {
        int size = 0;
        Attribute attr = this;
        while (attr != null) {
            cw.newUTF8(attr.type);
            size += cw.writeAttribute(attr).length + 6;
            attr = attr.next;
        }
        return size;
    }

    final void put(ClassWriter cw, ByteVector out) {
        Attribute attr = this;
        while (attr != null) {
            byte[] b = cw.writeAttribute(attr);
            out.put2(cw.newUTF8(attr.type)).put4(b.length);
            out.putByteArray(b, 0, b.length);
            attr = attr.next;
        }
    }
}

