/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AntDownloadMonitor;
import org.apache.maven.artifact.ant.Authentication;
import org.apache.maven.artifact.ant.LocalRepository;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.Proxy;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.ant.RepositoryPolicy;
import org.apache.maven.artifact.ant.shaded.IOUtil;
import org.apache.maven.artifact.ant.shaded.ReaderFactory;
import org.apache.maven.artifact.ant.shaded.StringUtils;
import org.apache.maven.artifact.ant.shaded.xml.XmlStreamReader;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.RuntimeInfo;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.apache.maven.usability.diagnostics.ErrorDiagnostics;
import org.apache.maven.wagon.Wagon;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractArtifactTask
extends Task {
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";
    private static ClassLoader plexusClassLoader;
    private File userSettingsFile;
    private File globalSettingsFile;
    private Settings settings;
    private ProfileManager profileManager;
    private PlexusContainer container;
    private Pom pom;
    private String pomRefId;
    private LocalRepository localRepository;

    protected ArtifactRepository createLocalArtifactRepository() {
        ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)this.lookup(ArtifactRepositoryLayout.ROLE, this.getLocalRepository().getLayout());
        return new DefaultArtifactRepository("local", "file://" + this.getLocalRepository().getPath(), repositoryLayout);
    }

    protected ArtifactRepositoryFactory getArtifactRepositoryFactory(RemoteRepository repository) {
        Proxy proxy;
        WagonManager manager = (WagonManager)this.lookup(WagonManager.ROLE);
        Authentication authentication = repository.getAuthentication();
        if (authentication != null) {
            manager.addAuthenticationInfo(repository.getId(), authentication.getUserName(), authentication.getPassword(), authentication.getPrivateKey(), authentication.getPassphrase());
        }
        if ((proxy = repository.getProxy()) != null) {
            manager.addProxy(proxy.getType(), proxy.getHost(), proxy.getPort(), proxy.getUserName(), proxy.getPassword(), proxy.getNonProxyHosts());
        }
        return (ArtifactRepositoryFactory)this.lookup(ArtifactRepositoryFactory.ROLE);
    }

    protected void releaseArtifactRepositoryFactory(ArtifactRepositoryFactory repositoryFactory) {
        try {
            this.getContainer().release(repositoryFactory);
        }
        catch (ComponentLifecycleException componentLifecycleException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArtifactRepository createRemoteArtifactRepository(RemoteRepository repository) {
        ArtifactRepository artifactRepository;
        ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)this.lookup(ArtifactRepositoryLayout.ROLE, repository.getLayout());
        ArtifactRepositoryFactory repositoryFactory = null;
        try {
            repositoryFactory = this.getArtifactRepositoryFactory(repository);
            ArtifactRepositoryPolicy snapshots = AbstractArtifactTask.buildArtifactRepositoryPolicy(repository.getSnapshots());
            ArtifactRepositoryPolicy releases = AbstractArtifactTask.buildArtifactRepositoryPolicy(repository.getReleases());
            artifactRepository = repositoryFactory.createArtifactRepository(repository.getId(), repository.getUrl(), repositoryLayout, snapshots, releases);
        }
        finally {
            this.releaseArtifactRepositoryFactory(repositoryFactory);
        }
        return artifactRepository;
    }

    private static ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }

    protected LocalRepository getDefaultLocalRepository() {
        Settings settings = this.getSettings();
        LocalRepository localRepository = new LocalRepository();
        localRepository.setId("local");
        localRepository.setPath(new File(settings.getLocalRepository()));
        return localRepository;
    }

    protected synchronized Settings getSettings() {
        if (this.settings == null) {
            this.initSettings();
        }
        return this.settings;
    }

    private File newFile(String parent, String subdir, String filename) {
        return new File(new File(parent, subdir), filename);
    }

    private void initSettings() {
        File tempSettingsFile;
        if (this.userSettingsFile == null) {
            tempSettingsFile = this.newFile(System.getProperty("user.home"), ".ant", "settings.xml");
            if (tempSettingsFile.exists()) {
                this.userSettingsFile = tempSettingsFile;
            } else {
                tempSettingsFile = this.newFile(System.getProperty("user.home"), ".m2", "settings.xml");
                if (tempSettingsFile.exists()) {
                    this.userSettingsFile = tempSettingsFile;
                }
            }
        }
        if (this.globalSettingsFile == null) {
            tempSettingsFile = this.newFile(System.getProperty("ant.home"), "etc", "settings.xml");
            if (tempSettingsFile.exists()) {
                this.globalSettingsFile = tempSettingsFile;
            } else {
                Vector env = Execute.getProcEnvironment();
                Iterator iter = env.iterator();
                while (iter.hasNext()) {
                    String var = (String)iter.next();
                    if (!var.startsWith("M2_HOME=")) continue;
                    String m2Home = var.substring("M2_HOME=".length());
                    tempSettingsFile = this.newFile(m2Home, "conf", "settings.xml");
                    if (!tempSettingsFile.exists()) break;
                    this.globalSettingsFile = tempSettingsFile;
                    break;
                }
            }
        }
        Settings userSettings = this.loadSettings(this.userSettingsFile);
        Settings globalSettings = this.loadSettings(this.globalSettingsFile);
        SettingsUtils.merge(userSettings, globalSettings, "global-level");
        this.settings = userSettings;
        if (StringUtils.isEmpty(this.settings.getLocalRepository())) {
            String location = this.newFile(System.getProperty("user.home"), ".m2", "repository").getAbsolutePath();
            this.settings.setLocalRepository(location);
        }
        WagonManager wagonManager = (WagonManager)this.lookup(WagonManager.ROLE);
        wagonManager.setDownloadMonitor(new AntDownloadMonitor());
        if (this.settings.isOffline()) {
            this.log("You are working in offline mode.", 2);
            wagonManager.setOnline(false);
        } else {
            wagonManager.setOnline(true);
        }
    }

    private Settings loadSettings(File settingsFile) {
        Settings settings = null;
        try {
            if (settingsFile != null) {
                this.log("Loading Maven settings file: " + settingsFile.getPath(), 3);
                settings = this.readSettings(settingsFile);
            }
        }
        catch (IOException e) {
            this.log("Error reading settings file '" + settingsFile + "' - ignoring. Error was: " + e.getMessage(), 1);
        }
        catch (XmlPullParserException e) {
            this.log("Error parsing settings file '" + settingsFile + "' - ignoring. Error was: " + e.getMessage(), 1);
        }
        if (settings == null) {
            settings = new Settings();
            RuntimeInfo rtInfo = new RuntimeInfo(settings);
            settings.setRuntimeInfo(rtInfo);
        }
        return settings;
    }

    public void setSettingsFile(File settingsFile) {
        if (!settingsFile.exists()) {
            throw new BuildException("settingsFile does not exist: " + settingsFile.getAbsolutePath());
        }
        this.userSettingsFile = settingsFile;
        this.settings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Settings readSettings(File settingsFile) throws IOException, XmlPullParserException {
        Settings settings = null;
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(settingsFile);
            StringWriter sWriter = new StringWriter();
            IOUtil.copy((Reader)reader, (Writer)sWriter);
            String rawInput = sWriter.toString();
            try {
                RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
                interpolator.addValueSource(new EnvarBasedValueSource());
                rawInput = interpolator.interpolate(rawInput, "settings");
            }
            catch (Exception e) {
                this.log("Failed to initialize environment variable resolver. Skipping environment substitution in settings.");
            }
            StringReader sReader = new StringReader(rawInput);
            SettingsXpp3Reader modelReader = new SettingsXpp3Reader();
            settings = modelReader.read(sReader);
            RuntimeInfo rtInfo = new RuntimeInfo(settings);
            rtInfo.setFile(settingsFile);
            settings.setRuntimeInfo(rtInfo);
        }
        finally {
            IOUtil.close(reader);
        }
        return settings;
    }

    protected RemoteRepository createAntRemoteRepository(Repository pomRepository) {
        RemoteRepository r = this.createAntRemoteRepositoryBase(pomRepository);
        if (pomRepository.getSnapshots() != null) {
            r.addSnapshots(AbstractArtifactTask.convertRepositoryPolicy(pomRepository.getSnapshots()));
        }
        if (pomRepository.getReleases() != null) {
            r.addReleases(AbstractArtifactTask.convertRepositoryPolicy(pomRepository.getReleases()));
        }
        return r;
    }

    protected RemoteRepository createAntRemoteRepositoryBase(RepositoryBase pomRepository) {
        RemoteRepository r = new RemoteRepository();
        r.setId(pomRepository.getId());
        r.setUrl(pomRepository.getUrl());
        r.setLayout(pomRepository.getLayout());
        return r;
    }

    protected void updateRepositoryWithSettings(RemoteRepository repository) {
        org.apache.maven.settings.Proxy proxy;
        Server server;
        Mirror mirror = this.getMirror(this.getSettings().getMirrors(), repository);
        if (mirror != null) {
            repository.setUrl(mirror.getUrl());
            repository.setId(mirror.getId());
        }
        if (repository.getAuthentication() == null && (server = this.getSettings().getServer(repository.getId())) != null) {
            repository.addAuthentication(new Authentication(server));
        }
        if (repository.getProxy() == null && (proxy = this.getSettings().getActiveProxy()) != null) {
            repository.addProxy(new Proxy(proxy));
        }
    }

    protected Object lookup(String role) {
        try {
            return this.getContainer().lookup(role);
        }
        catch (ComponentLookupException e) {
            throw new BuildException("Unable to find component: " + role, (Throwable)e);
        }
    }

    protected Object lookup(String role, String roleHint) {
        try {
            return this.getContainer().lookup(role, roleHint);
        }
        catch (ComponentLookupException e) {
            throw new BuildException("Unable to find component: " + role + "[" + roleHint + "]", (Throwable)e);
        }
    }

    protected synchronized PlexusContainer getContainer() {
        if (this.container == null) {
            this.container = (PlexusContainer)this.getProject().getReference(PlexusContainer.class.getName());
            if (this.container == null) {
                try {
                    ClassWorld classWorld = new ClassWorld();
                    classWorld.newRealm("plexus.core", ((Object)((Object)this)).getClass().getClassLoader());
                    Embedder embedder = new Embedder();
                    embedder.start(classWorld);
                    this.container = embedder.getContainer();
                }
                catch (PlexusContainerException e) {
                    throw new BuildException("Unable to start embedder", (Throwable)e);
                }
                catch (DuplicateRealmException e) {
                    throw new BuildException("Unable to create embedder ClassRealm", (Throwable)e);
                }
                this.getProject().addReference(PlexusContainer.class.getName(), (Object)this.container);
            }
        }
        return this.container;
    }

    public Pom initializePom(ArtifactRepository localArtifactRepository) {
        Pom pom = this.getPom();
        if (pom != null) {
            MavenProjectBuilder projectBuilder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
            pom.initialiseMavenProject(projectBuilder, localArtifactRepository);
        }
        return pom;
    }

    protected Pom createDummyPom(ArtifactRepository localRepository) {
        Pom pom = new Pom();
        pom.setMavenProject(this.createMinimalProject(localRepository));
        return pom;
    }

    protected MavenProject createMinimalProject(ArtifactRepository localRepository) {
        MavenProjectBuilder projectBuilder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        DefaultProjectBuilderConfiguration builderConfig = new DefaultProjectBuilderConfiguration();
        builderConfig.setLocalRepository(localRepository);
        builderConfig.setGlobalProfileManager(this.getProfileManager());
        try {
            return projectBuilder.buildStandaloneSuperProject(builderConfig);
        }
        catch (ProjectBuildingException e) {
            throw new BuildException("Unable to create dummy Pom", (Throwable)e);
        }
    }

    protected Artifact createDummyArtifact() {
        ArtifactFactory factory = (ArtifactFactory)this.lookup(ArtifactFactory.ROLE);
        return factory.createBuildArtifact("unspecified", "unspecified", "0.0", "jar");
    }

    public String[] getSupportedProtocols() {
        try {
            Map wagonMap = this.getContainer().lookupMap(Wagon.ROLE);
            ArrayList protocols = new ArrayList();
            Iterator iter = wagonMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                protocols.add(entry.getKey());
            }
            return protocols.toArray(new String[protocols.size()]);
        }
        catch (ComponentLookupException e) {
            throw new BuildException("Unable to lookup Wagon providers", (Throwable)e);
        }
    }

    public String getSupportedProtocolsAsString() {
        return StringUtils.join(this.getSupportedProtocols(), ", ");
    }

    public void diagnoseError(Throwable error) {
        try {
            ErrorDiagnostics diagnostics = (ErrorDiagnostics)this.container.lookup(ErrorDiagnostics.ROLE);
            StringBuffer message = new StringBuffer();
            message.append("An error has occurred while processing the Maven artifact tasks.\n");
            message.append(" Diagnosis:\n\n");
            message.append(diagnostics.diagnose(error));
            message.append("\n\n");
            this.log(message.toString(), 2);
        }
        catch (ComponentLookupException e) {
            this.log("Failed to retrieve error diagnoser.", 4);
        }
    }

    public void addPom(Pom pom) {
        this.pom = pom;
    }

    public Pom getPom() {
        Pom thePom = this.pom;
        if (thePom != null && this.getPomRefId() != null) {
            throw new BuildException("You cannot specify both a nested \"pom\" element and a \"pomrefid\" attribute");
        }
        if (this.getPomRefId() != null) {
            Object pomRefObj = this.getProject().getReference(this.getPomRefId());
            if (pomRefObj instanceof Pom) {
                thePom = (Pom)((Object)pomRefObj);
            } else {
                throw new BuildException("Reference '" + this.pomRefId + "' was not found.");
            }
        }
        return thePom;
    }

    public String getPomRefId() {
        return this.pomRefId;
    }

    public void setPomRefId(String pomRefId) {
        this.pomRefId = pomRefId;
    }

    public LocalRepository getLocalRepository() {
        if (this.localRepository == null) {
            this.localRepository = this.getDefaultLocalRepository();
        }
        return this.localRepository;
    }

    protected ProfileManager getProfileManager() {
        if (this.profileManager == null) {
            this.profileManager = new DefaultProfileManager(this.getContainer(), this.getSettings(), System.getProperties());
        }
        return this.profileManager;
    }

    public void addLocalRepository(LocalRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setProfiles(String profiles) {
        if (profiles != null) {
            this.log("Profiles not yet supported, ignoring profiles '" + profiles + "'", 1);
        }
    }

    private static RepositoryPolicy convertRepositoryPolicy(org.apache.maven.model.RepositoryPolicy pomRepoPolicy) {
        RepositoryPolicy policy = new RepositoryPolicy();
        policy.setEnabled(pomRepoPolicy.isEnabled());
        policy.setUpdatePolicy(pomRepoPolicy.getUpdatePolicy());
        return policy;
    }

    public void execute() {
        this.showVersion();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (plexusClassLoader != null) {
                Thread.currentThread().setContextClassLoader(plexusClassLoader);
            }
            this.initSettings();
            this.doExecute();
        }
        catch (BuildException e) {
            this.diagnoseError(e);
            throw e;
        }
        finally {
            plexusClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    protected abstract void doExecute();

    private Mirror getMirror(List mirrors, RemoteRepository repository) {
        String repositoryId = repository.getId();
        if (repositoryId != null) {
            Mirror mirror;
            Iterator it = mirrors.iterator();
            while (it.hasNext()) {
                mirror = (Mirror)it.next();
                if (!repositoryId.equals(mirror.getMirrorOf())) continue;
                return mirror;
            }
            it = mirrors.iterator();
            while (it.hasNext()) {
                mirror = (Mirror)it.next();
                if (!this.matchPattern(repository, mirror.getMirrorOf())) continue;
                return mirror;
            }
        }
        return null;
    }

    boolean matchPattern(RemoteRepository originalRepository, String pattern) {
        boolean result = false;
        String originalId = originalRepository.getId();
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos = pattern.split(",");
            for (int i = 0; i < repos.length; ++i) {
                String repo = repos[i];
                if (repo.length() > 1 && repo.startsWith("!")) {
                    if (!originalId.equals(repo.substring(1))) continue;
                    result = false;
                    break;
                }
                if (originalId.equals(repo)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo) && this.isExternalRepo(originalRepository)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    boolean isExternalRepo(RemoteRepository originalRepository) {
        try {
            URL url = new URL(originalRepository.getUrl());
            return !url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1") && !url.getProtocol().equals("file");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    protected void showVersion() {
        Properties properties = new Properties();
        String antTasksPropertiesPath = "META-INF/maven/org.apache.maven/maven-ant-tasks/pom.properties";
        InputStream resourceAsStream = AbstractArtifactTask.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-ant-tasks/pom.properties");
        try {
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
            String version = properties.getProperty("version", "unknown");
            String builtOn = properties.getProperty("builtOn");
            if (builtOn != null) {
                this.log("Maven Ant Tasks version: " + version + " built on " + builtOn, 3);
            } else {
                this.log("Maven Ant Tasks version: " + version, 3);
            }
        }
        catch (IOException e) {
            this.log("Unable to determine version from Maven Ant Tasks JAR file: " + e.getMessage(), 1);
        }
    }
}

