/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.base.algorithm;

import com.opensymphony.oscache.base.algorithm.AbstractConcurrentReadCache;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUCache
extends AbstractConcurrentReadCache {
    private static final Log log = LogFactory.getLog((Class)LRUCache.class);
    private Collection list = new LinkedHashSet();
    private volatile boolean removeInProgress = false;

    public LRUCache() {
    }

    public LRUCache(int capacity) {
        this();
        this.maxEntries = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRetrieved(Object key) {
        while (this.removeInProgress) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Collection collection = this.list;
        synchronized (collection) {
            this.list.remove(key);
            this.list.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemPut(Object key) {
        Collection collection = this.list;
        synchronized (collection) {
            this.list.remove(key);
            this.list.add(key);
        }
    }

    protected Object removeItem() {
        Object toRemove;
        this.removeInProgress = true;
        try {
            toRemove = this.removeFirst();
        }
        catch (Exception e) {
            do {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.list.size() == 0);
            toRemove = this.removeFirst();
        }
        this.removeInProgress = false;
        return toRemove;
    }

    protected void itemRemoved(Object key) {
        this.list.remove(key);
    }

    private Object removeFirst() {
        Iterator it = this.list.iterator();
        Object toRemove = it.next();
        it.remove();
        return toRemove;
    }
}

