/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.pages;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import net.sourceforge.xhtmldoclet.AbstractPageWriter;
import net.sourceforge.xhtmldoclet.AbstractXhtmlWriter;
import net.sourceforge.xhtmldoclet.Config;
import net.sourceforge.xhtmldoclet.Doclet;

public final class ClassSummary
extends AbstractPageWriter {
    private static final String EXTENDS = CONF.propertyText("extends", new Object[0]);
    private ClassDoc classDoc;
    private ClassDoc prev;
    private ClassDoc next;
    private String pkgName;
    private String className;
    private ClassType classType;
    private ClassDoc[] innerClasses;
    private ConstructorDoc[] constructors;
    private MethodDoc[] methods;
    private FieldDoc[] fields;
    private FieldDoc[] enumConstants;
    private boolean hasNonPublicConstructor = false;
    private final int spacesPerTab = 4;

    public static void generateClassSummary(ClassDoc classDoc, ClassDoc prev, ClassDoc next) {
        String filename = classDoc.name() + ClassSummary.CONF.ext;
        String path = DirectoryManager.getDirectoryPath((PackageDoc)classDoc.containingPackage());
        try {
            new ClassSummary(filename, path, classDoc, prev, next);
        }
        catch (IOException exc) {
            throw Doclet.exception(exc, filename);
        }
    }

    private ClassSummary(String filename, String pathToFile, ClassDoc classDoc, ClassDoc prevClass, ClassDoc nextClass) throws IOException {
        super(filename, pathToFile);
        ClassSummary.CONF.currentPkg = classDoc.containingPackage();
        ClassSummary.CONF.currentClass = classDoc;
        this.pkgName = classDoc.containingPackage().name();
        this.className = classDoc.name();
        this.classDoc = classDoc;
        this.prev = prevClass;
        this.next = nextClass;
        this.windowTitle = this.className;
        if (classDoc.isInterface()) {
            this.classType = ClassType.INTERFACE;
            this.pageType = "INTERFACE";
        } else if (classDoc.isAnnotationType()) {
            this.classType = ClassType.ANNOTATION;
            this.pageType = "ANNOTATION";
        } else if (classDoc.isEnum()) {
            this.classType = ClassType.ENUM;
            this.pageType = "ENUM";
        } else if (classDoc.isException()) {
            this.classType = ClassType.EXCEPTION;
            this.pageType = "EXCEPTION";
        } else if (classDoc.isError()) {
            this.classType = ClassType.ERROR;
            this.pageType = "ERROR";
        } else if (classDoc.isClass()) {
            this.classType = ClassType.CLASS;
            this.pageType = "CLASS";
        }
        this.innerClasses = classDoc.isIncluded() ? classDoc.innerClasses() : null;
        this.enumConstants = classDoc.isIncluded() ? classDoc.enumConstants() : null;
        this.fields = classDoc.isIncluded() ? classDoc.fields() : null;
        this.constructors = classDoc.isIncluded() ? classDoc.constructors() : null;
        this.methods = classDoc.isIncluded() ? classDoc.methods() : null;
        for (ConstructorDoc ped : this.constructors) {
            if (!ped.isProtected() && !ped.isPrivate()) continue;
            this.hasNonPublicConstructor = true;
        }
        this.printXhtmlHeader(ClassSummary.CONF.metakeywords.getMetaKeywords(classDoc), true, null);
        this.printEntityCaptionPackage((Doc)classDoc, this.classType.type, classDoc.containingPackage().name());
        this.println(this.openDivWithID("Overview"));
        this.println(this.open("dl"));
        this.headingDeclaration();
        this.headingHierarchy();
        this.printEnclosingClass();
        this.headingTypeParameters();
        if (classDoc.isInterface()) {
            this.headingSuperinterfaces();
            this.headingSubinterfaces();
            this.headingImplementingClasses();
        }
        if (!classDoc.isInterface()) {
            this.headingImplementedInterfaces();
            this.headingKnownDirectSubclasses();
        }
        this.headingDeprecatedInfo();
        this.headingAdditionalTags();
        this.println(this.close("dl"));
        this.headingDescription();
        this.println(this.close("div") + this.getComment("Overview"));
        this.println(this.openDivWithID("Summaries"));
        this.summaryInnerClasses();
        this.summaryEnumConstants();
        this.summaryFields();
        this.summaryConstructors();
        this.summaryMethods();
        this.println(this.close("div") + this.getComment("Summaries"));
        this.println(this.openDivWithID("Details"));
        this.detailEnumConstants();
        this.detailFields();
        this.detailConstructors();
        this.detailMethods();
        this.println(this.close("div") + this.getComment("Details"));
        this.printXhtmlFooter();
        this.close();
    }

    private void headingDeprecatedInfo() {
        if (Util.isDeprecated((ProgramElementDoc)this.classDoc)) {
            Tag[] deprs = this.classDoc.tags("deprecated");
            this.println(this.open("dt id=\"Deprecated\"") + (Object)((Object)Heading.DEPRECATED) + this.close("dt"));
            if (deprs.length > 0) {
                Tag[] commentTags = deprs[0].inlineTags();
                String deprecationComments = "";
                deprecationComments = commentTags.length > 0 ? this.commentTagsToString(null, (Doc)this.classDoc, deprs[0].inlineTags(), false) : "(No explanation given.)" + this.close("dd");
                this.println(this.open("dd class=\"deprecated\"") + deprecationComments + this.close("dd"));
            }
        }
    }

    private void headingDeclaration() {
        Type[] implementedInterfaces;
        ClassDoc superclass;
        this.println(this.open("dt") + (Object)((Object)Heading.DECLARATION) + this.close("dt"));
        StringBuffer modifiers = new StringBuffer(this.classDoc.modifiers() + " ");
        if (this.classDoc.isEnum()) {
            modifiers.append("enum ");
            int index = modifiers.indexOf("abstract");
            if (index >= 0) {
                modifiers.delete(index, index + "abstract".length());
            }
            if ((index = modifiers.indexOf("final")) >= 0) {
                modifiers.delete(index, index + "final".length());
            }
            modifiers = new StringBuffer(Util.replaceText((String)modifiers.toString(), (String)"  ", (String)" "));
        } else if (!this.classDoc.isInterface()) {
            modifiers.append("class ");
        }
        this.printDeclarationAnnotationInfo(this.classDoc, 0, true);
        this.print(this.open("dd class=\"code\"") + modifiers.toString());
        this.print(this.bold(this.className + this.typeParameters((Doc)this.classDoc)));
        this.println(this.close("dd"));
        boolean isInterface = this.classDoc.isInterface();
        if (!isInterface && (superclass = Util.getFirstVisibleSuperClass((ClassDoc)this.classDoc, (Configuration)CONF).asClassDoc()) != null) {
            String superclassLink = this.linkToLabelHref(this.escapeHTML(superclass.name()), this.hrefToDoc((Doc)superclass)) + this.typeParameters((Doc)superclass);
            this.println(this.open("dd class=\"code\"") + "extends " + superclassLink + this.close("dd"));
        }
        if ((implementedInterfaces = this.classDoc.interfaceTypes()) != null && implementedInterfaces.length > 0) {
            this.print(this.open("dd class=\"code\""));
            int counter = 0;
            for (Type type : implementedInterfaces) {
                ClassDoc c = type.asClassDoc();
                if (!c.isPublic() && !Util.isLinkable((ClassDoc)c, (Configuration)CONF)) continue;
                if (counter++ == 0) {
                    this.print(isInterface ? "extends " : "implements ");
                } else {
                    this.print(", ");
                }
                this.print(this.linkToLabelHref(c.name(), this.hrefToDoc((Doc)c)) + this.typeParameters((Doc)c));
            }
            this.print(this.close("dd"));
        }
    }

    private void headingDescription() {
        if (!ClassSummary.CONF.nocomment && this.classDoc.inlineTags().length > 0) {
            this.println(this.openDivWithID("Description"));
            this.print(this.inlineComment((Doc)this.classDoc));
            this.println(this.close("div") + this.getComment("Description"));
        }
    }

    private void headingHierarchy() {
        if (!this.classDoc.isClass()) {
            return;
        }
        this.println(this.open("dt") + (Object)((Object)Heading.HIERARCHY) + this.close("dt"));
        this.print(this.open("dd") + this.open("pre") + this.open("span"));
        this.printTreeForClassHelper((Type)this.classDoc);
        this.println(this.close("span") + this.close("pre") + this.close("dd"));
    }

    private void headingSuperinterfaces() {
        List interfaces = Util.getAllInterfaces((Type)this.classDoc, (Configuration)CONF);
        if (this.classDoc.isInterface() && interfaces.size() > 0) {
            this.println(this.open("dt") + (Object)((Object)Heading.SUPERINTERFACES) + this.close("dt"));
            this.println(this.open("dd") + this.open("ul"));
            for (Type type : interfaces) {
                this.println(this.open("li") + this.linkToClass(type.asClassDoc()) + this.typeParameters((Doc)type.asClassDoc()) + this.close("li"));
            }
            this.println(this.close("ul") + this.close("dd"));
        }
    }

    private void headingSubinterfaces() {
        List subInterfaces = ClassSummary.CONF.classTree.allSubs(this.classDoc, false);
        if (this.classDoc.isInterface() && subInterfaces.size() > 0) {
            this.println(this.open("dt") + (Object)((Object)Heading.SUBINTERFACES) + this.close("dt"));
            this.println(this.open("dd") + this.open("ul"));
            for (Type type : subInterfaces) {
                this.println(this.open("li") + this.linkToClass(type.asClassDoc()) + this.typeParameters((Doc)type.asClassDoc()) + this.close("li"));
            }
            this.println(this.close("ul") + this.close("dd"));
        }
    }

    private void headingImplementingClasses() {
        if (!this.classDoc.isInterface()) {
            return;
        }
        if (this.classDoc.qualifiedName().equals("java.lang.Cloneable") || this.classDoc.qualifiedName().equals("java.io.Serializable")) {
            return;
        }
        List implementingClasses = ClassSummary.CONF.classTree.implementingclasses(this.classDoc);
        if (implementingClasses.size() > 0) {
            this.println(this.open("dt") + (Object)((Object)Heading.IMPLEMENTING_CLASSES) + this.close("dt"));
            this.println(this.open("dd") + this.open("ul"));
            for (ClassDoc doc : implementingClasses) {
                this.println(this.open("li") + this.linkToClass(doc.asClassDoc()) + this.typeParameters((Doc)doc.asClassDoc()) + this.close("li"));
            }
            this.println(this.close("ul") + this.close("dd"));
        }
    }

    private void headingImplementedInterfaces() {
        List interfaces = Util.getAllInterfaces((Type)this.classDoc, (Configuration)CONF);
        if (this.classDoc.isClass() && interfaces.size() > 0) {
            this.println(this.open("dt") + (Object)((Object)Heading.IMPLEMENTED_INTERFACES) + this.close("dt"));
            this.println(this.open("dd") + this.open("ul"));
            for (Type type : interfaces) {
                this.println(this.open("li") + this.linkToClass(type.asClassDoc()) + this.typeParameters((Doc)type.asClassDoc()) + this.close("li"));
            }
            this.println(this.close("ul") + this.close("dd"));
        }
    }

    private void headingKnownDirectSubclasses() {
        if (this.classDoc.isClass() && ClassSummary.CONF.classTree.subs(this.classDoc, false).size() > 0) {
            if (this.classDoc.qualifiedName().equals("java.lang.Object") || this.classDoc.qualifiedName().equals("org.omg.CORBA.Object")) {
                return;
            }
            this.println(this.open("dt") + (Object)((Object)Heading.KNOWN_DIRECT_SUBCLASSES) + this.close("dt"));
            List subclasses = ClassSummary.CONF.classTree.subs(this.classDoc, false);
            this.println(this.open("dd") + this.open("ul"));
            for (ClassDoc doc : subclasses) {
                this.println(this.open("li") + this.linkToClass(doc) + this.close("li"));
            }
            this.println(this.close("ul") + this.close("dd"));
        }
    }

    private void headingTypeParameters() {
        if (this.classDoc.typeParamTags().length > 0) {
            this.println(this.open("dt") + (Object)((Object)Heading.TYPE_PARAMETERS) + this.close("dt"));
            for (ParamTag tag : this.classDoc.typeParamTags()) {
                this.println(this.open("dd") + this.open("code") + tag.parameterName() + this.close("code") + " - " + tag.parameterComment() + this.close("dd"));
            }
        }
    }

    private void headingAdditionalTags() {
        this.println(this.open("dt") + "[Print @since, @version, @author, etc.]" + this.close("dt"));
    }

    private int printTreeForClassHelper(Type type) {
        Type sup = Util.getFirstVisibleSuperClass((ClassDoc)(type instanceof ClassDoc ? (ClassDoc)type : type.asClassDoc()), (Configuration)CONF);
        int indent = 0;
        if (sup != null) {
            indent = this.printTreeForClassHelper(sup);
            this.println();
            this.print(this.spaces(4 * indent - 2, false));
            this.print(this.imgSrcAlt(this.pathToDocRoot + "image-files/inherit.gif", EXTENDS));
        }
        if (type.equals(this.classDoc)) {
            this.typeParameters((Doc)this.classDoc);
            String endClass = "";
            endClass = CONF.shouldExcludeQualifier(this.classDoc.containingPackage().name()) ? type.asClassDoc().name() : type.asClassDoc().qualifiedName();
            this.print(this.bold(endClass + this.typeParameters((Doc)this.classDoc)));
        } else {
            this.print(this.linkToClass(type.asClassDoc(), true));
        }
        return indent + 1;
    }

    private void printDeclarationAnnotationInfo(ClassDoc cd, int indent, boolean lineBreak) {
        List annotations = this.getAnnotations(indent, cd.annotations(), lineBreak);
        if (annotations.size() > 0) {
            Iterator iter = annotations.iterator();
            while (iter.hasNext()) {
                this.print(this.open("dd class=\"code\"") + (String)iter.next() + this.close("dd"));
            }
        }
    }

    private List getAnnotations(int indent, AnnotationDesc[] descList, boolean linkBreak) {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < descList.length; ++i) {
            AnnotationTypeDoc annotationDoc = descList[i].annotationType();
            if (!Util.isDocumentedAnnotation((AnnotationTypeDoc)annotationDoc)) continue;
            StringBuffer annotation = new StringBuffer();
            annotation.append(this.linkToClass((ClassDoc)annotationDoc));
            AnnotationDesc.ElementValuePair[] pairs = descList[i].elementValues();
            if (pairs.length > 0) {
                annotation.append('(');
                for (int j = 0; j < pairs.length; ++j) {
                    if (j > 0) {
                        annotation.append(",");
                        if (linkBreak) {
                            annotation.append(DocletConstants.NL);
                            int spaces = annotationDoc.name().length() + 2;
                            for (int k = 0; k < spaces + indent; ++k) {
                                annotation.append(' ');
                            }
                        }
                    }
                    annotation.append(this.getDocLink(29, (MemberDoc)pairs[j].element(), pairs[j].element().name(), false));
                    annotation.append('=');
                    AnnotationValue annotationValue = pairs[j].value();
                    ArrayList<AnnotationValue> annotationTypeValues = new ArrayList<AnnotationValue>();
                    if (annotationValue.value() instanceof AnnotationValue[]) {
                        AnnotationValue[] annotationArray = (AnnotationValue[])annotationValue.value();
                        for (int k = 0; k < annotationArray.length; ++k) {
                            annotationTypeValues.add(annotationArray[k]);
                        }
                    } else {
                        annotationTypeValues.add(annotationValue);
                    }
                    annotation.append(annotationTypeValues.size() == 1 ? "" : "{");
                    Iterator iter = annotationTypeValues.iterator();
                    while (iter.hasNext()) {
                        annotation.append(this.annotationValueToString((AnnotationValue)iter.next()));
                        annotation.append(iter.hasNext() ? "," : "");
                    }
                    annotation.append(annotationTypeValues.size() == 1 ? "" : "}");
                }
                annotation.append(")");
            }
            annotation.append(linkBreak ? DocletConstants.NL : "");
            results.add(annotation.toString());
        }
        return results;
    }

    private String annotationValueToString(AnnotationValue annotationValue) {
        Object value = annotationValue.value();
        if (value instanceof Type) {
            Type type = (Type)annotationValue.value();
            if (type.asClassDoc() != null) {
                String label = (type.asClassDoc().isIncluded() ? type.typeName() : type.qualifiedTypeName()) + type.dimension() + ".class";
                return this.linkToLabelHref(label, this.linkToClass(type.asClassDoc()));
            }
            return type.typeName() + type.dimension() + ".class";
        }
        if (value instanceof AnnotationDesc) {
            List list = this.getAnnotations(0, new AnnotationDesc[]{(AnnotationDesc)value}, false);
            StringBuffer buf = new StringBuffer();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next());
            }
            return buf.toString();
        }
        if (value instanceof FieldDoc) {
            return this.getDocLink(29, (MemberDoc)((FieldDoc)value), ((FieldDoc)value).name(), false);
        }
        return annotationValue.toString();
    }

    private void printEnclosingClass() {
        ClassDoc outerClass = this.classDoc.containingClass();
        if (outerClass != null) {
            if (outerClass.isInterface()) {
                this.println(this.open("dt") + (Object)((Object)Heading.ENCLOSING_INTERFACE) + this.close("dt"));
            } else {
                this.println(this.open("dt") + (Object)((Object)Heading.ENCLOSING_CLASS) + this.close("dt"));
            }
            this.println(this.open("dd") + this.linkToClass(outerClass) + this.typeParameters((Doc)outerClass) + this.close("dd"));
        }
    }

    private void summaryInnerClasses() {
        if (this.innerClasses.length == 0) {
            return;
        }
        this.println(this.openDivWithID("Inner-Class-Summary"));
        this.println(this.open("h2") + (Object)((Object)Summary.INNER_CLASS) + this.close("h2"));
        this.println(this.open("table"));
        for (ClassDoc c : new TreeSet<ClassDoc>(Arrays.asList(this.innerClasses))) {
            this.println(this.open("tr"));
            this.printTH(this.modifiersString((ProgramElementDoc)c) + this.classFlavor(c, true));
            this.printTD(this.linkToClass(c));
            this.println(this.close("tr"));
        }
        this.println(this.close("table"));
        this.println(this.close("div") + this.getComment("Inner-Class-Summary"));
    }

    private void summaryConstructors() {
        if (this.constructors.length == 0) {
            return;
        }
        this.println(this.openDivWithID("Constructor-Summary"));
        this.println(this.open("h2") + (Object)((Object)Summary.CONSTRUCTOR) + this.close("h2"));
        this.println(this.open("table"));
        for (ConstructorDoc c : new TreeSet<ConstructorDoc>(Arrays.asList(this.constructors))) {
            this.println(this.open("tr"));
            if (this.hasNonPublicConstructor) {
                this.printTH(this.modifiersString((ProgramElementDoc)c));
            }
            this.printTD(this.definitionList(this.bold(this.linkToLabelHref(c.name(), this.hrefToDoc((Doc)c))) + this.getJoinedParameters((ExecutableMemberDoc)c, true, false, true), this.getCommentSummary((Doc)c)));
            this.println(this.close("tr"));
        }
        this.println(this.close("table"));
        this.println(this.close("div") + this.getComment("Constructor-Summary"));
    }

    private void detailConstructors() {
        if (this.constructors.length == 0) {
            return;
        }
        this.println(this.openDivWithID("Constructor-Detail"));
        this.println(this.open("h2") + (Object)((Object)Detail.CONSTRUCTOR) + this.close("h2"));
        for (ConstructorDoc c : this.constructors) {
            this.println(this.openDivWithID(this.memberAnchor((MemberDoc)c)));
            this.println(this.open("h3") + c.name() + this.close("h3"));
            String modifiers = this.modifiersString((ProgramElementDoc)c, true);
            int indent = (modifiers + c.name()).length() + 1;
            String exceptions = this.getJoinedStrings(this.getExceptionStrings((ExecutableMemberDoc)c, true), ",\n" + this.spaces(indent, false));
            this.print(this.open("pre") + modifiers + this.bold(c.name()) + this.getJoinedParameters((ExecutableMemberDoc)c, true, false, true, ",\n" + this.spaces(indent, false)));
            if (exceptions != null) {
                this.print("\n" + this.spaces(indent - "throws ".length(), false) + "throws " + this.getJoinedStrings(this.getExceptionStrings((ExecutableMemberDoc)c, true), ",\n" + this.spaces(indent, false)));
            }
            this.println(this.close("pre"));
            this.println(this.close("div"));
        }
        this.println(this.close("div") + this.getComment("Constructor-Detail"));
    }

    private void summaryMethods() {
        if (this.methods.length == 0) {
            return;
        }
        this.println(this.openDivWithID("Method-Summary"));
        this.println(this.open("h2") + (Object)((Object)Summary.METHOD) + this.close("h2"));
        this.println(this.open("table"));
        for (MethodDoc m : new TreeSet<MethodDoc>(Arrays.asList(this.methods))) {
            this.println(this.open("tr"));
            this.printTH(this.modifiersString((ProgramElementDoc)m) + this.linkToType((MemberDoc)m));
            this.printTD(this.definitionList(this.bold(this.signatureLink((ExecutableMemberDoc)m)) + this.getJoinedParameters((ExecutableMemberDoc)m, true, false, true), this.getCommentSummary((Doc)m)));
            this.println(this.close("tr"));
        }
        this.println(this.close("table"));
        this.println(this.close("div") + this.getComment("Method-Summary"));
    }

    private void detailMethods() {
        if (this.methods.length == 0) {
            return;
        }
        this.println(this.openDivWithID("Method-Detail"));
        this.println(this.open("h2") + (Object)((Object)Detail.METHOD) + this.close("h2"));
        for (MethodDoc m : this.methods) {
            this.println(this.openDivWithID(this.memberAnchor((MemberDoc)m)));
            this.println(this.open("h3") + m.name() + this.close("h3"));
            String modifiers = this.modifiersString((ProgramElementDoc)m, true);
            int indent = (modifiers + this.getTypeString((MemberDoc)m, false, false) + m.name()).length() + 2;
            String exceptions = this.getJoinedStrings(this.getExceptionStrings((ExecutableMemberDoc)m, true), ",\n" + this.spaces(indent, false));
            this.print(this.open("pre") + modifiers + this.getTypeString((MemberDoc)m, true, false) + " " + this.bold(m.name()) + this.getJoinedParameters((ExecutableMemberDoc)m, true, false, true, ",\n" + this.spaces(indent, false)));
            if (exceptions != null) {
                this.print("\n" + this.spaces(indent - "throws ".length(), false) + "throws " + this.getJoinedStrings(this.getExceptionStrings((ExecutableMemberDoc)m, true), ",\n" + this.spaces(indent, false)));
            }
            this.println(this.close("pre"));
            this.println(this.close("div"));
        }
        this.println(this.close("div") + this.getComment("Method-Detail"));
    }

    private void summaryFields() {
        if (this.fields.length == 0) {
            return;
        }
        this.println(this.openDivWithID("Field-Summary"));
        this.println(this.open("h2") + (Object)((Object)Summary.FIELD) + this.close("h2"));
        this.println(this.open("table"));
        for (FieldDoc f : new TreeSet<FieldDoc>(Arrays.asList(this.fields))) {
            String name = f.name();
            this.println(this.open("tr"));
            this.printTH(this.modifiersString((ProgramElementDoc)f) + this.linkToType((MemberDoc)f));
            this.printTD(this.definitionList(this.bold(this.linkToLabelHref(name, "#" + name)), this.getCommentSummary((Doc)f)));
            this.println(this.close("tr"));
        }
        this.println(this.close("table"));
        this.println(this.close("div") + this.getComment("Field-Summary"));
    }

    private void detailFields() {
        if (this.fields.length == 0) {
            return;
        }
        this.println(this.openDivWithID("Field-Detail"));
        this.println(this.open("h2") + (Object)((Object)Detail.FIELD) + this.close("h2"));
        for (FieldDoc f : this.fields) {
            this.println(this.openDivWithID(f.name()));
            this.println(this.open("h3") + f.name() + this.close("h3"));
            this.println(this.open("pre") + f.modifiers() + " " + this.linkToType(f.type()) + " " + this.bold(f.name()) + this.close("pre"));
            this.println(this.open("dl"));
            if (f.constantValueExpression() != null) {
                this.printDT("See Also:");
                this.printDD(this.linkToLabelHref("Constant Field Values", this.pathToDocRoot + "constant-values" + ClassSummary.CONF.ext + "#" + f.qualifiedName()));
            }
            this.println(this.close("dl"));
            this.println(this.close("div"));
        }
        this.println(this.close("div") + this.getComment("Field-Detail"));
    }

    private void summaryEnumConstants() {
        if (this.enumConstants.length == 0) {
            return;
        }
        this.println(this.openDivWithID("Enum-Constant-Summary"));
        this.println(this.open("h2") + (Object)((Object)Summary.ENUM_CONSTANT) + this.close("h2"));
        this.println(this.open("table"));
        for (FieldDoc ec : new TreeSet<FieldDoc>(Arrays.asList(this.enumConstants))) {
            this.println(this.open("tr"));
            this.printTD(this.linkToLabelHref(ec.name(), "#" + ec.name()));
            this.println(this.close("tr"));
        }
        this.println(this.close("table"));
        this.println(this.close("div") + this.getComment("Enum-Constant-Summary"));
    }

    private void detailEnumConstants() {
        if (this.enumConstants.length == 0) {
            return;
        }
        this.println(this.openDivWithID("Enum-Constant-Detail"));
        this.println(this.open("h2") + (Object)((Object)Detail.ENUM_CONSTANT) + this.close("h2"));
        this.println(this.close("div") + this.getComment("Enum-Constant-Detail"));
    }

    protected void navLinkPackage() {
        this.println(this.listItem(this.linkToLabelHrefTitle(PACKAGE, "package-summary" + ClassSummary.CONF.ext, CONF.propertyText("navtitle.Package", this.pkgName))));
    }

    protected void navLinkClass() {
        this.println(this.listItemCurrent(CLASS));
    }

    protected void navLinkUse() {
        this.println(this.listItem(this.linkToLabelHrefTitle(USE, "class-use" + SLASH + this.filename, CONF.propertyText("navtitle.Use", this.classDoc.name()))));
    }

    protected void navLinkTree() {
        this.println(this.listItem(this.linkToLabelHrefTitle(TREE, "package-tree" + ClassSummary.CONF.ext, CONF.propertyText("navtitle.Tree.package", this.pkgName))));
    }

    protected void navWithinPage() {
        this.print(this.open("td id=\"WithinPage\""));
        Vector<String> summaries = new Vector<String>();
        if (this.innerClasses.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("Inner_Classes", new Object[0]), "#Inner-Class-Summary"));
        }
        if (this.constructors.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("Constructors", new Object[0]), "#Constructor-Summary"));
        }
        if (this.fields.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("Fields", new Object[0]), "#Field-Summary"));
        }
        if (this.methods.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("Methods", new Object[0]), "#Method-Summary"));
        }
        if (this.enumConstants.length > 0) {
            summaries.add(this.linkToLabelHref(CONF.propertyText("Enums", new Object[0]), "#Enum-Summary"));
        }
        Vector<String> details = new Vector<String>();
        if (this.constructors.length > 0) {
            details.add(this.linkToLabelHref(CONF.propertyText("Constructors", new Object[0]), "#Constructor-Detail"));
        }
        if (this.fields.length > 0) {
            details.add(this.linkToLabelHref(CONF.propertyText("Fields", new Object[0]), "#Field-Detail"));
        }
        if (this.methods.length > 0) {
            details.add(this.linkToLabelHref(CONF.propertyText("Methods", new Object[0]), "#Method-Detail"));
        }
        if (this.enumConstants.length > 0) {
            details.add(this.linkToLabelHref(CONF.propertyText("Enums", new Object[0]), "#Enum-Detail"));
        }
        this.printUnorderedListWithLast(summaries);
        this.printUnorderedListWithLast(details);
        this.println(this.close("td"));
        this.println(this.open("td class=\"labels\""));
        AbstractXhtmlWriter.TagBuilder strongTag = (AbstractXhtmlWriter)this.new AbstractXhtmlWriter.TagBuilder("strong");
        this.println(strongTag.getOpenTextClose(SUMMARY) + this.empty("br") + strongTag.getOpenTextClose(DETAIL));
        this.println(this.close("td"));
    }

    protected void navPreviousNext() {
        this.println(this.openULWithID("PreviousNext"));
        this.println(this.listItem(this.linkToLabelHref(PREV_CLASS, this.hrefToDoc((Doc)this.prev))) + this.listItemLast(this.linkToLabelHref(NEXT_CLASS, this.hrefToDoc((Doc)this.next))));
        this.println(this.close("ul"));
    }

    static /* synthetic */ Config access$000() {
        return CONF;
    }

    static /* synthetic */ Config access$100() {
        return CONF;
    }

    static /* synthetic */ Config access$200() {
        return CONF;
    }

    static /* synthetic */ Config access$300() {
        return CONF;
    }

    static /* synthetic */ Config access$400() {
        return CONF;
    }

    static /* synthetic */ Config access$500() {
        return CONF;
    }

    static /* synthetic */ Config access$600() {
        return CONF;
    }

    static /* synthetic */ Config access$700() {
        return CONF;
    }

    static /* synthetic */ Config access$800() {
        return CONF;
    }

    static /* synthetic */ Config access$900() {
        return CONF;
    }

    static /* synthetic */ Config access$1000() {
        return CONF;
    }

    static /* synthetic */ Config access$1100() {
        return CONF;
    }

    static /* synthetic */ Config access$1200() {
        return CONF;
    }

    static /* synthetic */ Config access$1300() {
        return CONF;
    }

    static /* synthetic */ Config access$1400() {
        return CONF;
    }

    static /* synthetic */ Config access$1500() {
        return CONF;
    }

    static /* synthetic */ Config access$1600() {
        return CONF;
    }

    static /* synthetic */ Config access$1700() {
        return CONF;
    }

    static /* synthetic */ Config access$1800() {
        return CONF;
    }

    static /* synthetic */ Config access$1900() {
        return CONF;
    }

    static /* synthetic */ Config access$2000() {
        return CONF;
    }

    static /* synthetic */ Config access$2100() {
        return CONF;
    }

    static /* synthetic */ Config access$2200() {
        return CONF;
    }

    static /* synthetic */ Config access$2300() {
        return CONF;
    }

    static /* synthetic */ Config access$2400() {
        return CONF;
    }

    static /* synthetic */ Config access$2500() {
        return CONF;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Detail {
        CONSTRUCTOR(ClassSummary.access$2200().propertyText("detail.Constructor", new Object[0])),
        FIELD(ClassSummary.access$2300().propertyText("detail.Field", new Object[0])),
        METHOD(ClassSummary.access$2400().propertyText("detail.Method", new Object[0])),
        ENUM_CONSTANT(ClassSummary.access$2500().propertyText("detail.EnumConstant", new Object[0]));

        private String detail;

        private Detail(String detail) {
            this.detail = detail;
        }

        public String toString() {
            return this.detail;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Summary {
        INNER_CLASS(ClassSummary.access$1700().propertyText("summary.InnerClass", new Object[0])),
        CONSTRUCTOR(ClassSummary.access$1800().propertyText("summary.Constructor", new Object[0])),
        FIELD(ClassSummary.access$1900().propertyText("summary.Field", new Object[0])),
        METHOD(ClassSummary.access$2000().propertyText("summary.Method", new Object[0])),
        ENUM_CONSTANT(ClassSummary.access$2100().propertyText("summary.EnumConstant", new Object[0]));

        private String summary;

        private Summary(String summary) {
            this.summary = summary;
        }

        public String toString() {
            return this.summary;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Heading {
        DECLARATION(ClassSummary.access$600().propertyText("heading.Declaration", new Object[0])),
        ENCLOSING_CLASS(ClassSummary.access$700().propertyText("heading.EnclosingClass", new Object[0])),
        ENCLOSING_INTERFACE(ClassSummary.access$800().propertyText("heading.EnclosingInterface", new Object[0])),
        HIERARCHY(ClassSummary.access$900().propertyText("heading.Hierarchy", new Object[0])),
        IMPLEMENTED_INTERFACES(ClassSummary.access$1000().propertyText("heading.ImplementedInterfaces", new Object[0])),
        IMPLEMENTING_CLASSES(ClassSummary.access$1100().propertyText("heading.ImplementingClasses", new Object[0])),
        KNOWN_DIRECT_SUBCLASSES(ClassSummary.access$1200().propertyText("heading.KnownDirectSubclasses", new Object[0])),
        SUPERINTERFACES(ClassSummary.access$1300().propertyText("heading.Superinterfaces", new Object[0])),
        SUBINTERFACES(ClassSummary.access$1400().propertyText("heading.Subinterfaces", new Object[0])),
        TYPE_PARAMETERS(ClassSummary.access$1500().propertyText("heading.TypeParameters", new Object[0])),
        DEPRECATED(ClassSummary.access$1600().propertyText("heading.Deprecated", new Object[0]));

        private String heading;

        private Heading(String heading) {
            this.heading = heading;
        }

        public String toString() {
            return this.heading;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ClassType {
        CLASS(ClassSummary.access$000().propertyText("Class", new Object[0])),
        INTERFACE(ClassSummary.access$100().propertyText("Interface", new Object[0])),
        ENUM(ClassSummary.access$200().propertyText("Enum", new Object[0])),
        EXCEPTION(ClassSummary.access$300().propertyText("Exception", new Object[0])),
        ERROR(ClassSummary.access$400().propertyText("Error", new Object[0])),
        ANNOTATION(ClassSummary.access$500().propertyText("Annotation_Type", new Object[0]));

        private String type;

        private ClassType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

