/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xhtmldoclet.writers;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.doclets.internal.toolkit.util.links.LinkFactory;
import com.sun.tools.doclets.internal.toolkit.util.links.LinkInfo;
import com.sun.tools.doclets.internal.toolkit.util.links.LinkOutput;
import net.sourceforge.xhtmldoclet.Config;
import net.sourceforge.xhtmldoclet.writers.HtmlDocletWriter;
import net.sourceforge.xhtmldoclet.writers.LinkInfoImpl;
import net.sourceforge.xhtmldoclet.writers.LinkOutputImpl;

public class LinkFactoryImpl
extends LinkFactory {
    private HtmlDocletWriter m_writer;

    public LinkFactoryImpl(HtmlDocletWriter writer) {
        this.m_writer = writer;
    }

    protected LinkOutput getOutputInstance() {
        return new LinkOutputImpl();
    }

    protected LinkOutput getClassLink(LinkInfo linkInfo) {
        LinkInfoImpl classLinkInfo = (LinkInfoImpl)linkInfo;
        boolean noLabel = linkInfo.label == null || linkInfo.label.length() == 0;
        ClassDoc classDoc = classLinkInfo.classDoc;
        String title = classLinkInfo.where == null || classLinkInfo.where.length() == 0 ? this.getClassToolTip(classDoc, classLinkInfo.type != null && !classDoc.qualifiedTypeName().equals(classLinkInfo.type.qualifiedTypeName())) : "";
        StringBuffer label = new StringBuffer(classLinkInfo.getClassLinkLabel(this.m_writer.configuration));
        classLinkInfo.displayLength += label.length();
        if (noLabel && classLinkInfo.excludeTypeParameterLinks) {
            label.append(this.getTypeParameterLinks(linkInfo).toString());
        }
        Config configuration = Config.getInstance();
        LinkOutputImpl linkOutput = new LinkOutputImpl();
        if (classDoc.isIncluded()) {
            if (configuration.isGeneratedDoc((Doc)classDoc)) {
                String filename = this.pathString(classLinkInfo);
                linkOutput.append(this.m_writer.getHyperLink(filename, classLinkInfo.where, label.toString(), classLinkInfo.isBold, classLinkInfo.styleName, title, classLinkInfo.target));
                if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
                    linkOutput.append(this.getTypeParameterLinks(linkInfo).toString());
                }
                return linkOutput;
            }
        } else {
            String crossLink = this.m_writer.getCrossClassLink(classDoc.qualifiedName(), classLinkInfo.where, label.toString(), classLinkInfo.isBold, classLinkInfo.styleName, true);
            if (crossLink != null) {
                linkOutput.append(crossLink);
                if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
                    linkOutput.append(this.getTypeParameterLinks(linkInfo).toString());
                }
                return linkOutput;
            }
        }
        linkOutput.append(label.toString());
        if (noLabel && !classLinkInfo.excludeTypeParameterLinks) {
            linkOutput.append(this.getTypeParameterLinks(linkInfo).toString());
        }
        return linkOutput;
    }

    protected LinkOutput getTypeParameterLink(LinkInfo linkInfo, Type typeParam) {
        LinkInfoImpl typeLinkInfo = new LinkInfoImpl(linkInfo.getContext(), typeParam);
        typeLinkInfo.excludeTypeBounds = linkInfo.excludeTypeBounds;
        typeLinkInfo.excludeTypeParameterLinks = linkInfo.excludeTypeParameterLinks;
        LinkOutput output = this.getLinkOutput(typeLinkInfo);
        ((LinkInfoImpl)linkInfo).displayLength += typeLinkInfo.displayLength;
        return output;
    }

    private String getClassToolTip(ClassDoc classDoc, boolean isTypeLink) {
        Config configuration = Config.getInstance();
        if (isTypeLink) {
            return configuration.getText("doclet.Href_Title_Type_Param", classDoc.name());
        }
        if (classDoc.isInterface()) {
            return configuration.getText("doclet.Href_Title_Interface", Util.getPackageName((PackageDoc)classDoc.containingPackage()));
        }
        if (classDoc.isAnnotationType()) {
            return configuration.getText("doclet.Href_Title_Annotation", Util.getPackageName((PackageDoc)classDoc.containingPackage()));
        }
        if (classDoc.isEnum()) {
            return configuration.getText("doclet.Href_Title_Enum", Util.getPackageName((PackageDoc)classDoc.containingPackage()));
        }
        return configuration.getText("doclet.Href_Title_Class", Util.getPackageName((PackageDoc)classDoc.containingPackage()));
    }

    private String pathString(LinkInfoImpl linkInfo) {
        if (linkInfo.context == 13) {
            return linkInfo.classDoc.name() + ".html";
        }
        StringBuffer buf = new StringBuffer(this.m_writer.relativePath);
        buf.append(DirectoryManager.getPathToPackage((PackageDoc)linkInfo.classDoc.containingPackage(), (String)(linkInfo.classDoc.name() + ".html")));
        return buf.toString();
    }
}

