/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.content;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.auth.acl.Acl;
import com.ecyrd.jspwiki.auth.acl.AclEntry;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Permission;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;
import net.sourceforge.stripes.util.Base64;
import org.apache.commons.lang.StringEscapeUtils;

public class Exporter {
    private WikiEngine m_engine;
    private PrintWriter m_out;
    private MimetypesFileTypeMap m_mimeTypes = new MimetypesFileTypeMap();
    private static final String NS_JSPWIKI = "http://www.jspwiki.org/ns#";
    private static final String STRING = "String";
    private static final String JSPWIKI_CONTENT_TYPE = "text/x-wiki.jspwiki";
    private static final String NAME = "Name";
    private static final String BINARY = "Binary";
    private static final String DATE = "Date";
    private SimpleDateFormat m_isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public Exporter(WikiEngine engine, OutputStream outStream) throws UnsupportedEncodingException {
        this.m_engine = engine;
        this.m_out = new PrintWriter(new OutputStreamWriter(outStream, "UTF-8"));
    }

    public void export() throws ProviderException, IOException {
        Collection allPages = this.m_engine.getPageManager().getAllPages();
        this.m_out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.m_out.println("<!--");
        this.m_out.println("This is an JSR-170 -compliant Document Tree export of a jspwiki 2.8 repository.\nIt is meant to be imported to the /wiki:spaces/ node of the JCR repository, as it\ndescribes an entire wiki space.");
        this.m_out.println("-->");
        this.m_out.println("<sv:node xmlns:jcr='http://www.jcp.org/jcr/1.0' xmlns:nt='http://www.jcp.org/jcr/nt/1.0' xmlns:mix='http://www.jcp.org/jcr/mix/1.0' xmlns:sv='http://www.jcp.org/jcr/sv/1.0' xmlns:wiki='http://www.jspwiki.org/ns#'\n         sv:name='" + this.m_engine.getApplicationName() + "'>");
        for (WikiPage p : allPages) {
            this.exportPage(p);
        }
        this.m_out.println("</sv:node> <!-- EOF -->");
        this.m_out.flush();
    }

    private void exportProperty(String name, String value, String type) {
        this.m_out.println("  <sv:property sv:name='" + StringEscapeUtils.escapeXml((String)name) + "' sv:type='" + type + "'>");
        this.m_out.print("    <sv:value>");
        this.m_out.print(StringEscapeUtils.escapeXml((String)value));
        this.m_out.println("</sv:value>");
        this.m_out.println("  </sv:property>");
    }

    private void exportProperty(String name, String[] values, String type) {
        this.m_out.println("  <sv:property sv:name='" + StringEscapeUtils.escapeXml((String)name) + "' sv:type='" + type + "'>");
        for (String value : values) {
            this.m_out.print("    <sv:value>");
            this.m_out.print(StringEscapeUtils.escapeXml((String)value));
            this.m_out.println("</sv:value>");
        }
        this.m_out.println("  </sv:property>");
    }

    private String mkUuid(WikiPage p) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(p.getWiki().getBytes("UTF-8"));
        out.write(p.getName().getBytes("UTF-8"));
        return UUID.nameUUIDFromBytes(out.toByteArray()).toString();
    }

    private String guessMimeType(WikiPage p) {
        if (p instanceof Attachment) {
            return this.m_mimeTypes.getContentType(((Attachment)p).getFileName());
        }
        return JSPWIKI_CONTENT_TYPE;
    }

    protected void exportPage(WikiPage p) throws IOException, ProviderException {
        this.exportCommonHeader(p);
        Map attrMap = p.getAttributes();
        for (Map.Entry e : attrMap.entrySet()) {
            if (((String)e.getKey()).equals("changenote")) {
                this.exportProperty("wiki:changeNote", (String)e.getValue(), STRING);
                continue;
            }
            this.exportProperty((String)e.getKey(), e.getValue().toString(), STRING);
        }
        Acl acl = p.getAcl();
        if (acl != null) {
            ArrayList<String> propval = new ArrayList<String>();
            Enumeration ee = acl.entries();
            while (ee.hasMoreElements()) {
                AclEntry ae = (AclEntry)ee.nextElement();
                StringBuilder sb = new StringBuilder();
                sb.append("ALLOW \"");
                sb.append(ae.getPrincipal().getName());
                sb.append("\" ");
                Enumeration permissions = ae.permissions();
                while (permissions.hasMoreElements()) {
                    Permission perm = (Permission)permissions.nextElement();
                    sb.append(perm.getActions());
                    sb.append(",");
                }
                propval.add(sb.toString());
            }
            this.exportProperty("wiki:acl", propval.toArray(new String[propval.size()]), STRING);
        }
        this.exportProperty("wiki:content", this.m_engine.getPureText(p), STRING);
        Collection atts = this.m_engine.getAttachmentManager().listAttachments(p);
        for (Attachment a : atts) {
            this.exportPage(a);
        }
        this.m_out.println(" </sv:node>");
        this.m_out.flush();
    }

    private void exportCommonHeader(WikiPage p) throws IOException {
        this.m_out.println(" <sv:node sv:name='" + StringEscapeUtils.escapeXml((String)p.getName()) + "'>");
        this.exportProperty("jcr:primaryType", "nt:unstructured", NAME);
        this.exportProperty("jcr:mixinTypes", new String[]{"mix:referenceable", "mix:versionable", "mix:lockable"}, NAME);
        this.exportProperty("wiki:author", p.getAuthor(), STRING);
        this.exportProperty("jcr:uuid", this.mkUuid(p), STRING);
        this.exportProperty("wiki:lastModified", this.m_isoFormat.format(p.getLastModified()), DATE);
        this.exportProperty("wiki:contentType", this.guessMimeType(p), STRING);
    }

    protected void exportPage(Attachment att) throws IOException, ProviderException {
        this.exportCommonHeader(att);
        this.m_out.println("  <sv:property sv:name='" + att.getFileName() + "' sv:type='" + BINARY + "'>");
        this.m_out.print("<sv:value>");
        InputStream binary = this.m_engine.getAttachmentManager().getAttachmentStream(att);
        Base64.InputStream base64 = new Base64.InputStream(binary, 1);
        FileUtil.copyContents(new InputStreamReader((InputStream)base64), this.m_out);
        binary.close();
        this.m_out.println("</sv:value>");
        this.m_out.println("</sv:property>");
        this.m_out.println(" </sv:node>");
        this.m_out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws IOException {
        if (argv.length < 2) {
            System.err.println("Usage: com.ecyrd.jspwiki.content.Exporter <path to jspwiki.properties> <filename>");
            System.exit(1);
        }
        String propFile = argv[0];
        String outFile = argv[1];
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(propFile));
        }
        catch (FileNotFoundException e) {
            System.err.println("Property file not found: " + propFile);
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println("Unable to read properties: " + propFile);
            System.exit(2);
        }
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            WikiEngine engine = new WikiEngine(props);
            Exporter x = new Exporter(engine, out);
            x.export();
        }
        catch (WikiException e) {
            e.printStackTrace(System.err);
            System.exit(3);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(3);
        }
        finally {
            if (out != null) {
                out.close();
            }
            System.exit(0);
        }
    }
}

