/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import org.apache.commons.openpgp.KeyRing;
import org.apache.commons.openpgp.OpenPgpException;
import org.apache.commons.openpgp.OpenPgpStreamingSigner;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;

public class BouncyCastleOpenPgpStreamingSigner
implements OpenPgpStreamingSigner {
    private static final String PROVIDER = "BC";
    private PGPSignatureGenerator sGen;
    private final ByteArrayOutputStream signatureBytes;
    private BCPGOutputStream bOut;

    public BouncyCastleOpenPgpStreamingSigner(String keyId, KeyRing keyRing, boolean asciiArmor) throws OpenPgpException {
        this.signatureBytes = new ByteArrayOutputStream();
        this.init(asciiArmor, this.signatureBytes, keyRing, keyId);
    }

    public BouncyCastleOpenPgpStreamingSigner(OutputStream signature, String keyId, KeyRing keyRing, boolean asciiArmor) throws OpenPgpException {
        this.signatureBytes = null;
        this.init(asciiArmor, signature, keyRing, keyId);
    }

    private void init(boolean asciiArmor, OutputStream signature, KeyRing keyRing, String keyId) throws OpenPgpException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        OutputStream out = asciiArmor ? new ArmoredOutputStream(signature) : signature;
        this.bOut = new BCPGOutputStream(out);
        try {
            PGPSecretKey pgpSec = keyRing.getSecretKey(keyId);
            PGPPrivateKey pgpPrivKey = pgpSec.extractPrivateKey(keyRing.getPassword(), PROVIDER);
            this.sGen = new PGPSignatureGenerator(pgpSec.getPublicKey().getAlgorithm(), 2, PROVIDER);
            this.sGen.initSign(0, pgpPrivKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OpenPgpException("Unable to find the correct algorithm for PGP - check that the Bouncy Castle provider is correctly installed", e);
        }
        catch (NoSuchProviderException e) {
            throw new OpenPgpException("Unable to find the correct provider for PGP - check that the Bouncy Castle provider is correctly installed", e);
        }
        catch (PGPException e) {
            e.printStackTrace();
            throw new OpenPgpException("Error calculating detached signature", e);
        }
    }

    public void update(byte[] buf) throws OpenPgpException {
        this.update(buf, 0, buf.length);
    }

    public void update(byte[] buf, int offset, int length) throws OpenPgpException {
        try {
            this.sGen.update(buf, offset, length);
        }
        catch (SignatureException e) {
            throw new OpenPgpException("Error calculating detached signature", e);
        }
    }

    public byte[] finish() throws OpenPgpException, IOException {
        try {
            this.sGen.generate().encode((OutputStream)this.bOut);
        }
        catch (PGPException e) {
            throw new OpenPgpException("Error calculating detached signature", e);
        }
        catch (SignatureException e) {
            throw new OpenPgpException("Error calculating detached signature", e);
        }
        this.bOut.close();
        return this.signatureBytes != null ? this.signatureBytes.toByteArray() : null;
    }
}

