/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.openpgp.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.openpgp.BouncyCastleKeyRing;
import org.apache.commons.openpgp.BouncyCastleOpenPgpSigner;
import org.apache.commons.openpgp.KeyRing;
import org.apache.commons.openpgp.OpenPgpException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.bouncycastle.openpgp.PGPException;

public class OpenPgpSignerTask
extends Task {
    private File secring;
    private File pubring;
    private String password;
    private String keyId;
    private Collection tosign = new ArrayList();
    private File artefact;
    private boolean asciiarmor = true;
    private Mapper mapperElement;

    public void setSecring(File secring) {
        this.secring = secring;
    }

    public void setPubring(File pubring) {
        this.pubring = pubring;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public void setAsciiarmor(boolean asciiarmor) {
        this.asciiarmor = asciiarmor;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setArtefact(File artefact) {
        this.artefact = artefact;
    }

    public void add(FileSet fs) {
        this.tosign.add(fs);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void execute() {
        FileInputStream pubStream;
        FileInputStream secStream;
        if (this.secring == null) {
            throw new BuildException("secring attribute compulsory");
        }
        if (this.pubring == null) {
            throw new BuildException("pubring attribute compulsory");
        }
        if (this.password == null) {
            throw new BuildException("password attribute compulsory");
        }
        if (this.tosign.size() == 0 && this.artefact == null) {
            throw new BuildException("supply the attribute tosign or one nested fileset");
        }
        if (!this.secring.exists() || !this.secring.canRead()) {
            throw new BuildException("secret keyring file does not exist or is not readable");
        }
        if (!this.pubring.exists() || !this.pubring.canRead()) {
            throw new BuildException("public keyring file does not exist or is not readable");
        }
        BouncyCastleKeyRing keyRing = null;
        try {
            secStream = new FileInputStream(this.secring);
            pubStream = new FileInputStream(this.pubring);
            keyRing = new BouncyCastleKeyRing(secStream, pubStream, this.password.toCharArray());
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        catch (PGPException pgpe) {
            throw new BuildException((Throwable)pgpe);
        }
        if (this.artefact != null) {
            this.dosign((KeyRing)keyRing, this.artefact);
        }
        if (this.tosign.size() != 0) {
            Iterator it = this.tosign.iterator();
            while (it.hasNext()) {
                FileSet fs = (FileSet)it.next();
                this.dosign((KeyRing)keyRing, fs);
            }
        }
        FileUtils.close((InputStream)secStream);
        FileUtils.close((InputStream)pubStream);
    }

    private void dosign(KeyRing keyRing, FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] artefacts = ds.getIncludedFiles();
        for (int counter = 0; counter < artefacts.length; ++counter) {
            this.dosign(keyRing, new File(fs.getDir(this.getProject()), artefacts[counter]), fs.getDir(this.getProject()), artefacts[counter]);
        }
    }

    private void dosign(KeyRing keyRing, File oneartefact) {
        this.dosign(keyRing, oneartefact, oneartefact.getParentFile(), oneartefact.getName());
    }

    private void dosign(KeyRing keyRing, File oneartefact, File basedir, String relpath) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(oneartefact);
            FileNameMapper mapper = this.getMapper();
            String[] mappedFiles = mapper.mapFileName(relpath);
            if (mappedFiles == null || mappedFiles.length != 1) {
                throw new BuildException("mapper returned more or less than one output");
            }
            File signature = new File(basedir, mappedFiles[0]);
            fos = new FileOutputStream(signature);
            BouncyCastleOpenPgpSigner signer = new BouncyCastleOpenPgpSigner();
            signer.detachedSign(fis, fos, this.keyId, keyRing, this.asciiarmor);
        }
        catch (FileNotFoundException fnfe) {
            throw new BuildException((Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        catch (OpenPgpException opgpe) {
            throw new BuildException((Throwable)opgpe);
        }
        FileUtils.close((OutputStream)fos);
        FileUtils.close((InputStream)fis);
    }

    private FileNameMapper getMapper() {
        FileNameMapper mapper = null;
        if (this.mapperElement != null) {
            mapper = this.mapperElement.getImplementation();
        } else {
            mapper = new GlobPatternMapper();
            mapper.setFrom("*");
            if (this.asciiarmor) {
                mapper.setTo("*.asc");
            } else {
                mapper.setTo("*.sig");
            }
        }
        return mapper;
    }
}

